/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.storage;

import com.intellij.history.core.LocalVcs;
import com.intellij.history.core.changes.ChangeList;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.changes.StructuralChange;
import com.intellij.history.core.storage.BrokenStorageException;
import com.intellij.history.core.storage.Content;
import com.intellij.history.core.storage.Storage;
import com.intellij.history.core.storage.StoredContent;
import com.intellij.history.core.tree.Entry;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class StorageChecker {
    private static final Logger LOG = Logger.getInstance((String)("#" + StorageChecker.class.getName()));

    public static void main(String[] args) {
        File dir = new File("C:/temp/local_history_mine");
        FileUtil.delete((File)new File(dir, ".broken"));
        Storage s = new Storage(dir);
        StorageChecker.checkIntegrity(s);
        System.out.println("");
    }

    public static void checkIntegrity(Storage s) {
        LocalVcs.Memento memento = s.load();
        ArrayList<String> badContents = new ArrayList<String>();
        long before = System.currentTimeMillis();
        long entries = StorageChecker.checkEntryContent(s, memento.myRoot, badContents);
        long changes = StorageChecker.checkChangesContent(s, memento.myRoot, memento.myChangeList, badContents);
        long after = System.currentTimeMillis();
        LOG.info("Local history validated in " + (after - before) / 1000L + " seconds\n" + "  file contents: " + entries + "\n" + "  change contents: " + changes);
        if (badContents.isEmpty()) {
            return;
        }
        String formatted = StringUtil.join(badContents, (String)"\n");
        LOG.warn("Invalid contents:\n" + formatted);
    }

    private static long checkEntryContent(Storage s, Entry e, List<String> badContents) {
        if (e.isDirectory()) {
            int result = 0;
            for (Entry child : e.getChildren()) {
                result = (int)((long)result + StorageChecker.checkEntryContent(s, child, badContents));
            }
            return result;
        }
        StorageChecker.checkContent(s, badContents, e.getContent(), " Path: " + e.getPath());
        return 1L;
    }

    private static long checkChangesContent(Storage s, Entry root, ChangeList cl, List<String> badContents) {
        final HashSet allContents = new HashSet();
        try {
            cl.getAcceptFunc(root, new ChangeVisitor(){

                @Override
                public void visit(StructuralChange c) {
                    allContents.addAll(c.getContentsToPurge());
                }
            }, false).doAccept();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (Content c : allContents) {
            StorageChecker.checkContent(s, badContents, c, "");
        }
        return allContents.size();
    }

    private static void checkContent(Storage s, List<String> badContents, Content c, String location) {
        if (!(c instanceof StoredContent)) {
            return;
        }
        StoredContent sc = (StoredContent)c;
        try {
            s.getContentStorage().load(sc.getId());
        }
        catch (BrokenStorageException ex) {
            badContents.add("ContentId: " + sc.getId() + location);
        }
    }
}

