/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.changes;

import com.intellij.history.core.IdPath;
import com.intellij.history.core.Paths;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.changes.RenameChangeAppliedState;
import com.intellij.history.core.changes.RenameChangeNonAppliedState;
import com.intellij.history.core.changes.StructuralChange;
import com.intellij.history.core.storage.Stream;
import com.intellij.history.core.tree.Entry;
import java.io.IOException;

public class RenameChange
extends StructuralChange<RenameChangeNonAppliedState, RenameChangeAppliedState> {
    public RenameChange(String path, String newName) {
        super(path);
        ((RenameChangeNonAppliedState)this.getNonAppliedState()).myNewName = newName;
    }

    public RenameChange(Stream s) throws IOException {
        super(s);
        ((RenameChangeAppliedState)this.getAppliedState()).myOldName = s.readString();
    }

    @Override
    public void write(Stream s) throws IOException {
        super.write(s);
        s.writeString(((RenameChangeAppliedState)this.getAppliedState()).myOldName);
    }

    @Override
    protected RenameChangeAppliedState createAppliedState() {
        return new RenameChangeAppliedState();
    }

    @Override
    protected RenameChangeNonAppliedState createNonAppliedState() {
        return new RenameChangeNonAppliedState();
    }

    public String getOldName() {
        return ((RenameChangeAppliedState)this.getAppliedState()).myOldName;
    }

    @Override
    protected IdPath doApplyTo(Entry r, RenameChangeAppliedState newState) {
        Entry e = r.getEntry(this.getPath());
        newState.myOldName = Paths.getNameOf(e.getName());
        this.rename(e, ((RenameChangeNonAppliedState)this.getNonAppliedState()).myNewName);
        return e.getIdPath();
    }

    @Override
    public void doRevertOn(Entry root) {
        this.rename(this.getEntry(root), ((RenameChangeAppliedState)this.getAppliedState()).myOldName);
    }

    @Override
    public boolean canRevertOn(Entry r) {
        return this.hasNoSuchEntry(this.getEntry(r).getParent(), ((RenameChangeAppliedState)this.getAppliedState()).myOldName);
    }

    private Entry getEntry(Entry r) {
        return r.getEntry(this.getAffectedIdPath());
    }

    private void rename(Entry e, String newName) {
        e.changeName(Paths.renamed(e.getName(), newName));
    }

    @Override
    public void accept(ChangeVisitor v) throws IOException, ChangeVisitor.StopVisitingException {
        v.visit(this);
    }
}

