/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.changes;

import com.intellij.history.core.IdPath;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.storage.Content;
import com.intellij.history.core.storage.Stream;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.utils.Reversed;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ChangeSet
extends Change {
    private String myName;
    private final long myTimestamp;
    private final List<Change> myChanges;

    public ChangeSet(long timestamp, String name, List<Change> changes) {
        this.myTimestamp = timestamp;
        this.myChanges = changes;
        this.myName = name;
    }

    public ChangeSet(long timestamp) {
        this.myTimestamp = timestamp;
        this.myChanges = new ArrayList<Change>();
    }

    public ChangeSet(Stream s) throws IOException {
        this.myName = s.readStringOrNull();
        this.myTimestamp = s.readLong();
        int count = s.readInteger();
        this.myChanges = new ArrayList<Change>(count);
        while (count-- > 0) {
            this.myChanges.add(s.readChange());
        }
    }

    @Override
    public void write(Stream s) throws IOException {
        s.writeStringOrNull(this.myName);
        s.writeLong(this.myTimestamp);
        s.writeInteger(this.myChanges.size());
        for (Change c : this.myChanges) {
            s.writeChange(c);
        }
    }

    public void setName(String name) {
        this.myName = name;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public long getTimestamp() {
        return this.myTimestamp;
    }

    public void addChange(Change c) {
        this.myChanges.add(c);
    }

    @Override
    public List<Change> getChanges() {
        return this.myChanges;
    }

    @Override
    public void applyTo(Entry r) {
        for (Change c : this.myChanges) {
            c.applyTo(r);
        }
    }

    @Override
    public boolean revertOnUpTo(Entry r, Change upTo, boolean revertTargetChange) {
        if (!revertTargetChange && this == upTo) {
            return false;
        }
        for (Change each : Reversed.list(this.myChanges)) {
            if (each.revertOnUpTo(r, upTo, revertTargetChange)) continue;
            return false;
        }
        return this != upTo;
    }

    @Override
    protected void doRevertOn(Entry root) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean affects(IdPath ... pp) {
        for (Change c : this.myChanges) {
            if (!c.affects(pp)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean affectsSameAs(List<Change> cc) {
        for (Change c : this.myChanges) {
            if (!c.affectsSameAs(cc)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean affectsOnlyInside(Entry e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCreationalFor(Entry e) {
        for (Change c : this.myChanges) {
            if (!c.isCreationalFor(e)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Content> getContentsToPurge() {
        ArrayList<Content> result = new ArrayList<Content>();
        for (Change c : this.myChanges) {
            result.addAll(c.getContentsToPurge());
        }
        return result;
    }

    @Override
    public boolean isFileContentChange() {
        return this.myChanges.size() == 1 && this.myChanges.get(0).isFileContentChange();
    }

    @Override
    public void accept(ChangeVisitor v) throws IOException, ChangeVisitor.StopVisitingException {
        v.begin(this);
        for (Change c : Reversed.list(this.myChanges)) {
            c.accept(v);
        }
        v.end(this);
    }
}

