/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core;

import com.intellij.history.core.storage.Stream;
import java.io.IOException;
import java.util.Arrays;

public class IdPath {
    private final int[] myParts;

    public IdPath(int ... parts) {
        this.myParts = parts;
    }

    public IdPath(Stream s) throws IOException {
        this.myParts = new int[s.readInteger()];
        for (int i = 0; i < this.myParts.length; ++i) {
            this.myParts[i] = s.readInteger();
        }
    }

    public void write(Stream s) throws IOException {
        s.writeInteger(this.myParts.length);
        for (int id : this.myParts) {
            s.writeInteger(id);
        }
    }

    public int getId() {
        return this.myParts[this.myParts.length - 1];
    }

    public IdPath getParent() {
        if (this.myParts.length == 1) {
            return null;
        }
        int[] newPath = new int[this.myParts.length - 1];
        System.arraycopy(this.myParts, 0, newPath, 0, newPath.length);
        return new IdPath(newPath);
    }

    public IdPath appendedWith(int id) {
        int[] newPath = new int[this.myParts.length + 1];
        System.arraycopy(this.myParts, 0, newPath, 0, this.myParts.length);
        newPath[newPath.length - 1] = id;
        return new IdPath(newPath);
    }

    public boolean isChildOrParentOf(IdPath p) {
        return this.startsWith(p) || p.startsWith(this);
    }

    public boolean contains(int id) {
        for (int part : this.myParts) {
            if (part != id) continue;
            return true;
        }
        return false;
    }

    public boolean startsWith(IdPath p) {
        if (this.myParts.length < p.myParts.length) {
            return false;
        }
        for (int i = 0; i < p.myParts.length; ++i) {
            if (this.myParts[i] == p.myParts[i]) continue;
            return false;
        }
        return true;
    }

    public boolean rootEquals(int id) {
        return this.myParts[0] == id;
    }

    public IdPath withoutRoot() {
        int[] newPath = new int[this.myParts.length - 1];
        System.arraycopy(this.myParts, 1, newPath, 0, newPath.length);
        return new IdPath(newPath);
    }

    public String toString() {
        String result = "";
        for (int part : this.myParts) {
            result = result + part + ".";
        }
        return result.substring(0, result.length() - 1);
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        return Arrays.equals(this.myParts, ((IdPath)o).myParts);
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }
}

