/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.help.impl;

import com.intellij.CommonBundle;
import com.intellij.help.impl.IdeaHelpBroker;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.HelpSetPath;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.ui.Messages;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.net.URL;
import javax.help.BadIDException;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class HelpManagerImpl
extends HelpManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.help.impl.HelpManagerImpl");
    private HelpSet myHelpSet = null;
    private IdeaHelpBroker myBroker = null;
    @NonNls
    private static final String HELP_HS = "Help.hs";

    public void invokeHelp(String id) {
        if (this.myHelpSet == null) {
            try {
                this.myHelpSet = HelpManagerImpl.createHelpSet();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (this.myHelpSet == null) {
            BrowserUtil.launchBrowser((String)(ApplicationInfoImpl.getInstanceEx().getWebHelpUrl() + "?" + id));
            return;
        }
        if (this.myBroker == null) {
            this.myBroker = new IdeaHelpBroker(this.myHelpSet);
        }
        Window activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        this.myBroker.setActivationWindow(activeWindow);
        if (id != null) {
            try {
                this.myBroker.setCurrentID(id);
            }
            catch (BadIDException e) {
                Messages.showMessageDialog((String)IdeBundle.message((String)"help.topic.not.found.error", (Object[])new Object[]{id}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                return;
            }
        }
        this.myBroker.setDisplayed(true);
    }

    @Nullable
    private static HelpSet createHelpSet() {
        String urlToHelp = ApplicationInfo.getInstance().getHelpURL() + "/" + HELP_HS;
        try {
            IdeaPluginDescriptor[] pluginDescriptors;
            HelpSet helpSet = new HelpSet(null, new URL(urlToHelp));
            Application app = ApplicationManager.getApplication();
            for (IdeaPluginDescriptor pluginDescriptor : pluginDescriptors = app.getPlugins()) {
                HelpSetPath[] sets;
                for (HelpSetPath hsPath : sets = pluginDescriptor.getHelpSets()) {
                    URL hsURL = new URL("jar:file:///" + pluginDescriptor.getPath().getAbsolutePath() + "/help/" + hsPath.getFile() + "!" + hsPath.getPath());
                    try {
                        HelpSet pluginHelpSet = new HelpSet(null, hsURL);
                        helpSet.add(pluginHelpSet);
                    }
                    catch (HelpSetException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
            return helpSet;
        }
        catch (Exception ee) {
            return null;
        }
    }
}

