/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findInProject;

import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindSettings;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.find.replaceInProject.ReplaceInProjectManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.ui.content.Content;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.AdapterProcessor;
import com.intellij.util.Function;
import com.intellij.util.Processor;

public class FindInProjectManager {
    private final Project myProject;
    private boolean myToOpenInNewTab = false;
    private volatile boolean myIsFindInProgress = false;

    public static FindInProjectManager getInstance(Project project) {
        return (FindInProjectManager)ServiceManager.getService((Project)project, FindInProjectManager.class);
    }

    public FindInProjectManager(Project project) {
        this.myProject = project;
    }

    public void findInProject(DataContext dataContext) {
        String s;
        boolean isOpenInNewTabEnabled;
        final boolean[] toOpenInNewTab = new boolean[1];
        Content selectedContent = com.intellij.usageView.UsageViewManager.getInstance((Project)this.myProject).getSelectedContent(true);
        if (selectedContent != null && selectedContent.isPinned()) {
            toOpenInNewTab[0] = true;
            isOpenInNewTabEnabled = false;
        } else {
            toOpenInNewTab[0] = this.myToOpenInNewTab;
            isOpenInNewTabEnabled = com.intellij.usageView.UsageViewManager.getInstance((Project)this.myProject).getReusableContentsCount() > 0;
        }
        final FindManager findManager = FindManager.getInstance((Project)this.myProject);
        final FindModel findModel = (FindModel)findManager.getFindInProjectModel().clone();
        findModel.setReplaceState(false);
        findModel.setOpenInNewTabVisible(true);
        findModel.setOpenInNewTabEnabled(isOpenInNewTabEnabled);
        findModel.setOpenInNewTab(toOpenInNewTab[0]);
        FindInProjectUtil.setDirectoryName(findModel, dataContext);
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        if (!(editor == null || StringUtil.isEmpty((String)(s = editor.getSelectionModel().getSelectedText())) || s.contains("\r") || s.contains("\n"))) {
            findModel.setStringToFind(s);
        }
        findManager.showFindDialog(findModel, new Runnable(){

            @Override
            public void run() {
                UsageViewManager manager;
                findModel.setOpenInNewTabVisible(false);
                final PsiDirectory psiDirectory = FindInProjectUtil.getPsiDirectory(findModel, FindInProjectManager.this.myProject);
                if (findModel.getDirectoryName() != null && psiDirectory == null) {
                    return;
                }
                if (isOpenInNewTabEnabled) {
                    toOpenInNewTab[0] = findModel.isOpenInNewTab();
                    FindInProjectManager.this.myToOpenInNewTab = toOpenInNewTab[0];
                }
                if ((manager = UsageViewManager.getInstance((Project)FindInProjectManager.this.myProject)) == null) {
                    return;
                }
                findManager.getFindInProjectModel().copyFrom(findModel);
                final FindModel findModelCopy = (FindModel)findModel.clone();
                UsageViewPresentation presentation = FindInProjectUtil.setupViewPresentation(FindInProjectManager.this.myToOpenInNewTab, findModelCopy);
                boolean showPanelIfOnlyOneUsage = !FindSettings.getInstance().isSkipResultsWithOneUsage();
                FindUsagesProcessPresentation processPresentation = FindInProjectUtil.setupProcessPresentation(FindInProjectManager.this.myProject, showPanelIfOnlyOneUsage, presentation);
                manager.searchAndShowUsages(new UsageTarget[]{new FindInProjectUtil.StringUsageTarget(findModel.getStringToFind())}, (Factory)new Factory<UsageSearcher>(){

                    public UsageSearcher create() {
                        return new UsageSearcher(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void generate(Processor<Usage> processor) {
                                FindInProjectManager.this.myIsFindInProgress = true;
                                try {
                                    FindInProjectUtil.findUsages(findModelCopy, psiDirectory, FindInProjectManager.this.myProject, (Processor<UsageInfo>)new AdapterProcessor(processor, (Function)UsageInfo2UsageAdapter.CONVERTER));
                                }
                                finally {
                                    FindInProjectManager.this.myIsFindInProgress = false;
                                }
                            }
                        };
                    }
                }, processPresentation, presentation, null);
            }
        });
        findModel.setOpenInNewTabVisible(false);
    }

    public boolean isWorkInProgress() {
        return this.myIsFindInProgress;
    }

    public boolean isEnabled() {
        return !this.myIsFindInProgress && !ReplaceInProjectManager.getInstance(this.myProject).isWorkInProgress();
    }
}

