/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.autodetecting.facetsTree;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetType;
import com.intellij.facet.impl.autodetecting.DetectedFacetManager;
import com.intellij.facet.impl.autodetecting.facetsTree.DetectedFacetsTree;
import com.intellij.facet.impl.autodetecting.model.DetectedFacetInfo;
import com.intellij.facet.impl.autodetecting.model.FacetInfo2;
import com.intellij.facet.impl.autodetecting.model.FacetInfoBackedByFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImplicitFacetsTreeComponent {
    private final DetectedFacetsTree myTree;
    private final DetectedFacetManager myDetectedFacetManager;
    private final Collection<DetectedFacetsTree.FacetTypeNode> myFacetTypeNodes;

    public ImplicitFacetsTreeComponent(DetectedFacetManager detectedFacetManager, Collection<DetectedFacetInfo<Module>> detectedFacets, HashMap<DetectedFacetInfo<Module>, List<VirtualFile>> files) {
        this.myDetectedFacetManager = detectedFacetManager;
        HashMap<FacetType, DetectedFacetsTree.FacetTypeNode> facetTypeNodes = new HashMap<FacetType, DetectedFacetsTree.FacetTypeNode>();
        LinkedHashSet<FacetInfo2<Module>> sortedFacets = new LinkedHashSet<FacetInfo2<Module>>();
        for (DetectedFacetInfo<Module> facet : detectedFacets) {
            ImplicitFacetsTreeComponent.addUnderlying(facet, sortedFacets);
        }
        HashMap<FacetInfo2, RealFacetNode> facetNodes = new HashMap<FacetInfo2, RealFacetNode>();
        for (FacetInfo2 facetInfo2 : sortedFacets) {
            FacetType facetType = ImplicitFacetsTreeComponent.getRootFacetType(facetInfo2);
            DetectedFacetsTree.FacetTypeNode facetTypeNode = (DetectedFacetsTree.FacetTypeNode)((Object)facetTypeNodes.get(facetType));
            if (facetTypeNode == null) {
                facetTypeNode = new DetectedFacetsTree.FacetTypeNode(facetType);
                facetTypeNodes.put(facetType, facetTypeNode);
            }
            Module module = (Module)facetInfo2.getModule();
            ModuleNodeImpl moduleNode = ImplicitFacetsTreeComponent.findOrCreateModuleNode(facetTypeNode, module);
            DetectedFacetsTree.FacetNode parentNode = null;
            FacetInfo2 underlyingFacet = facetInfo2.getUnderlyingFacetInfo();
            if (underlyingFacet != null) {
                parentNode = (DetectedFacetsTree.FacetNode)((Object)facetNodes.get(underlyingFacet));
            }
            VirtualFile projectRoot = ((Module)facetInfo2.getModule()).getProject().getBaseDir();
            DetectedFacetsTree.FacetNode facetNode = facetInfo2 instanceof DetectedFacetInfo ? new FacetNodeImpl((DetectedFacetInfo)facetInfo2, projectRoot, parentNode, files.get(facetInfo2)) : new RealFacetNode((FacetInfoBackedByFacet)facetInfo2, projectRoot, parentNode);
            facetNodes.put(facetInfo2, (RealFacetNode)facetNode);
            if (parentNode != null) continue;
            moduleNode.addRootFacet(facetNode);
        }
        this.myFacetTypeNodes = facetTypeNodes.values();
        this.myTree = new DetectedFacetsTree(this.myFacetTypeNodes);
    }

    public void createFacets() {
        for (DetectedFacetsTree.FacetTypeNode facetTypeNode : this.myFacetTypeNodes) {
            for (DetectedFacetsTree.ModuleNode moduleNode : facetTypeNode.getModuleNodes()) {
                boolean accept = facetTypeNode.isChecked() && moduleNode.isChecked();
                this.processFacetNodes(moduleNode.getRootFacets(), accept, null);
            }
        }
    }

    private void processFacetNodes(List<DetectedFacetsTree.FacetNode> facetNodes, boolean accept, Facet underlyingFacet) {
        for (DetectedFacetsTree.FacetNode facetNode : facetNodes) {
            Facet facet = null;
            if (facetNode instanceof FacetNodeImpl) {
                DetectedFacetInfo<Module> detectedFacetInfo = ((FacetNodeImpl)facetNode).getDetectedFacetInfo();
                if (accept && facetNode.isChecked()) {
                    facet = this.myDetectedFacetManager.createFacet(detectedFacetInfo, underlyingFacet);
                } else {
                    this.myDetectedFacetManager.disableDetectionInFile(detectedFacetInfo);
                }
            } else {
                facet = ((RealFacetNode)facetNode).myFacetInfo.getFacet();
            }
            this.processFacetNodes(facetNode.getChildren(), accept && facetNode.isChecked(), facet);
        }
    }

    private static void addUnderlying(FacetInfo2<Module> facet, Collection<FacetInfo2<Module>> sortedFacets) {
        FacetInfo2<Module> underlying = facet.getUnderlyingFacetInfo();
        if (underlying != null && !sortedFacets.contains(underlying)) {
            ImplicitFacetsTreeComponent.addUnderlying(underlying, sortedFacets);
        }
        sortedFacets.add(facet);
    }

    private static ModuleNodeImpl findOrCreateModuleNode(DetectedFacetsTree.FacetTypeNode facetTypeNode, Module module) {
        for (DetectedFacetsTree.ModuleNode node : facetTypeNode.getModuleNodes()) {
            ModuleNodeImpl moduleNode = (ModuleNodeImpl)node;
            if (!moduleNode.myModule.equals(module)) continue;
            return moduleNode;
        }
        ModuleNodeImpl moduleNode = new ModuleNodeImpl(module);
        facetTypeNode.addModuleNode(moduleNode);
        return moduleNode;
    }

    private static FacetType getRootFacetType(FacetInfo2<?> detectedFacet) {
        FacetInfo2<?> underlyingFacet;
        FacetInfo2<?> facet = detectedFacet;
        while ((underlyingFacet = facet.getUnderlyingFacetInfo()) != null) {
            facet = underlyingFacet;
        }
        return facet.getFacetType();
    }

    public DetectedFacetsTree getTree() {
        return this.myTree;
    }

    private static class ModuleNodeImpl
    extends DetectedFacetsTree.ModuleNode {
        private final Module myModule;

        private ModuleNodeImpl(Module module) {
            super(module);
            this.myModule = module;
        }

        @Override
        public String getModuleName() {
            return this.myModule.getName();
        }

        @Override
        public String getModuleDescription() {
            return "";
        }
    }

    private static class RealFacetNode
    extends DetectedFacetsTree.FacetNode {
        private final FacetInfoBackedByFacet myFacetInfo;

        private RealFacetNode(FacetInfoBackedByFacet facetInfo, VirtualFile projectRoot, @Nullable DetectedFacetsTree.FacetNode parent) {
            super(facetInfo, facetInfo.getFacetType(), projectRoot, VirtualFile.EMPTY_ARRAY, parent);
            this.myFacetInfo = facetInfo;
        }

        @Override
        public String getDescription() {
            return "";
        }

        @Override
        public String getName() {
            return this.myFacetInfo.getFacetName();
        }
    }

    private static class FacetNodeImpl
    extends DetectedFacetsTree.FacetNode {
        private final DetectedFacetInfo<Module> myDetectedFacetInfo;

        private FacetNodeImpl(@NotNull DetectedFacetInfo<Module> detectedFacet, VirtualFile projectRoot, @Nullable DetectedFacetsTree.FacetNode parent, @NotNull List<VirtualFile> files) {
            if (detectedFacet == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/facetsTree/ImplicitFacetsTreeComponent$FacetNodeImpl.<init> must not be null");
            }
            if (files == null) {
                throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/facet/impl/autodetecting/facetsTree/ImplicitFacetsTreeComponent$FacetNodeImpl.<init> must not be null");
            }
            super(detectedFacet, detectedFacet.getFacetType(), projectRoot, VfsUtil.toVirtualFileArray(files), parent);
            this.myDetectedFacetInfo = detectedFacet;
        }

        public DetectedFacetInfo<Module> getDetectedFacetInfo() {
            return this.myDetectedFacetInfo;
        }

        @Override
        public String getName() {
            return this.myDetectedFacetInfo.getFacetName();
        }
    }
}

