/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.impl.FacetUtil;
import com.intellij.facet.impl.ProjectFacetManagerEx;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="ProjectFacetManager", storages={@Storage(id="other", file="$PROJECT_FILE$")})
public class ProjectFacetManagerImpl
extends ProjectFacetManagerEx
implements PersistentStateComponent<ProjectFacetManagerState> {
    @NonNls
    public static final String COMPONENT_NAME = "ProjectFacetManager";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.facet.impl.ProjectFacetManagerImpl");
    private ProjectFacetManagerState myState = new ProjectFacetManagerState();
    private Project myProject;

    public ProjectFacetManagerImpl(Project project) {
        this.myProject = project;
    }

    public ProjectFacetManagerState getState() {
        return this.myState;
    }

    public void loadState(ProjectFacetManagerState state) {
        this.myState = state;
    }

    public <F extends Facet> List<F> getFacets(@NotNull FacetTypeId<F> typeId) {
        if (typeId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/ProjectFacetManagerImpl.getFacets must not be null");
        }
        return this.getFacets(typeId, ModuleManager.getInstance((Project)this.myProject).getModules());
    }

    public <F extends Facet> List<F> getFacets(@NotNull FacetTypeId<F> typeId, Module[] modules) {
        if (typeId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/ProjectFacetManagerImpl.getFacets must not be null");
        }
        ArrayList result = new ArrayList();
        for (Module module : modules) {
            result.addAll(FacetManager.getInstance((Module)module).getFacetsByType(typeId));
        }
        return result;
    }

    public <C extends FacetConfiguration> C createDefaultConfiguration(@NotNull FacetType<?, C> facetType) {
        if (facetType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/ProjectFacetManagerImpl.createDefaultConfiguration must not be null");
        }
        FacetConfiguration configuration = facetType.createDefaultConfiguration();
        DefaultFacetConfigurationState state = this.myState.getDefaultConfigurations().get(facetType.getStringId());
        if (state != null) {
            Element defaultConfiguration = state.getDefaultConfiguration();
            try {
                FacetUtil.loadFacetConfiguration(configuration, defaultConfiguration);
            }
            catch (InvalidDataException e) {
                LOG.info((Throwable)e);
            }
        }
        return (C)configuration;
    }

    public <C extends FacetConfiguration> void setDefaultConfiguration(@NotNull FacetType<?, C> facetType, @NotNull C configuration) {
        if (facetType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/ProjectFacetManagerImpl.setDefaultConfiguration must not be null");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/ProjectFacetManagerImpl.setDefaultConfiguration must not be null");
        }
        Map<String, DefaultFacetConfigurationState> defaultConfigurations = this.myState.getDefaultConfigurations();
        DefaultFacetConfigurationState state = defaultConfigurations.get(facetType.getStringId());
        if (state == null) {
            state = new DefaultFacetConfigurationState();
            defaultConfigurations.put(facetType.getStringId(), state);
        }
        try {
            Element element = FacetUtil.saveFacetConfiguration(configuration);
            state.setDefaultConfiguration(element);
        }
        catch (WriteExternalException e) {
            LOG.info((Throwable)e);
        }
    }

    public static class ProjectFacetManagerState {
        private Map<String, DefaultFacetConfigurationState> myDefaultConfigurations = new HashMap<String, DefaultFacetConfigurationState>();

        @Tag(value="default-configurations")
        @MapAnnotation(surroundWithTag=false, surroundKeyWithTag=false, surroundValueWithTag=false, keyAttributeName="facet-type")
        public Map<String, DefaultFacetConfigurationState> getDefaultConfigurations() {
            return this.myDefaultConfigurations;
        }

        public void setDefaultConfigurations(Map<String, DefaultFacetConfigurationState> defaultConfigurations) {
            this.myDefaultConfigurations = defaultConfigurations;
        }
    }

    @Tag(value="default-facet-configuration")
    public static class DefaultFacetConfigurationState {
        private Element myDefaultConfiguration;

        @Tag(value="configuration")
        public Element getDefaultConfiguration() {
            return this.myDefaultConfiguration;
        }

        public void setDefaultConfiguration(Element defaultConfiguration) {
            this.myDefaultConfiguration = defaultConfiguration;
        }
    }
}

