/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.actions.AddToWatchActionHandler;
import com.intellij.debugger.actions.EvaluateActionHandler;
import com.intellij.debugger.actions.ForceRunToCursorActionHandler;
import com.intellij.debugger.actions.ForceStepIntoActionHandler;
import com.intellij.debugger.actions.ForceStepOverActionHandler;
import com.intellij.debugger.actions.MuteBreakpointsActionHandler;
import com.intellij.debugger.actions.PauseActionHandler;
import com.intellij.debugger.actions.QuickEvaluateActionHandler;
import com.intellij.debugger.actions.ResumeActionHandler;
import com.intellij.debugger.actions.RunToCursorActionHandler;
import com.intellij.debugger.actions.ShowExecutionPointActionHandler;
import com.intellij.debugger.actions.SmartStepIntoActionHandler;
import com.intellij.debugger.actions.StepIntoActionHandler;
import com.intellij.debugger.actions.StepOutActionHandler;
import com.intellij.debugger.actions.StepOverActionHandler;
import com.intellij.debugger.actions.ToggleLineBreakpointActionHandler;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.settings.DebuggerDataViewsConfigurable;
import com.intellij.debugger.settings.DebuggerHotswapConfigurable;
import com.intellij.debugger.settings.DebuggerLaunchingConfigurable;
import com.intellij.debugger.settings.DebuggerSteppingConfigurable;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.settings.UserRenderersConfigurable;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointFactory;
import com.intellij.debugger.ui.breakpoints.BreakpointPanel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.xdebugger.AbstractDebuggerSession;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import com.intellij.xdebugger.impl.actions.DebuggerToggleActionHandler;
import com.intellij.xdebugger.impl.breakpoints.ui.AbstractBreakpointPanel;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointPanelProvider;
import com.intellij.xdebugger.impl.evaluate.quick.common.QuickEvaluateHandler;
import com.intellij.xdebugger.impl.settings.DebuggerSettingsPanelProvider;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class JavaDebuggerSupport
extends DebuggerSupport {
    private final JavaBreakpointPanelProvider myBreakpointPanelProvider = new JavaBreakpointPanelProvider();
    private final StepOverActionHandler myStepOverActionHandler = new StepOverActionHandler();
    private final StepIntoActionHandler myStepIntoActionHandler = new StepIntoActionHandler();
    private final StepOutActionHandler myStepOutActionHandler = new StepOutActionHandler();
    private final ForceStepOverActionHandler myForceStepOverActionHandler = new ForceStepOverActionHandler();
    private final ForceStepIntoActionHandler myForceStepIntoActionHandler = new ForceStepIntoActionHandler();
    private final RunToCursorActionHandler myRunToCursorActionHandler = new RunToCursorActionHandler();
    private final ForceRunToCursorActionHandler myForceRunToCursorActionHandler = new ForceRunToCursorActionHandler();
    private final ResumeActionHandler myResumeActionHandler = new ResumeActionHandler();
    private final PauseActionHandler myPauseActionHandler = new PauseActionHandler();
    private final ToggleLineBreakpointActionHandler myToggleLineBreakpointActionHandler = new ToggleLineBreakpointActionHandler();
    private final ShowExecutionPointActionHandler myShowExecutionPointActionHandler = new ShowExecutionPointActionHandler();
    private final EvaluateActionHandler myEvaluateActionHandler = new EvaluateActionHandler();
    private final QuickEvaluateActionHandler myQuickEvaluateHandler = new QuickEvaluateActionHandler();
    private final JavaDebuggerSettingsPanelProvider myDebuggerSettingsPanelProvider = new JavaDebuggerSettingsPanelProvider();
    private final MuteBreakpointsActionHandler myMuteBreakpointsHandler = new MuteBreakpointsActionHandler();
    private final DebuggerActionHandler mySmartStepIntoHandler = new SmartStepIntoActionHandler();
    private final DebuggerActionHandler myAddToWatchedActionHandler = new AddToWatchActionHandler();

    @Override
    @NotNull
    public BreakpointPanelProvider<?> getBreakpointPanelProvider() {
        JavaBreakpointPanelProvider javaBreakpointPanelProvider = this.myBreakpointPanelProvider;
        if (javaBreakpointPanelProvider == null) {
            throw new IllegalStateException("@NotNull method com/intellij/debugger/ui/JavaDebuggerSupport.getBreakpointPanelProvider must not return null");
        }
        return javaBreakpointPanelProvider;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getStepOverHandler() {
        StepOverActionHandler stepOverActionHandler = this.myStepOverActionHandler;
        if (stepOverActionHandler == null) {
            throw new IllegalStateException("@NotNull method com/intellij/debugger/ui/JavaDebuggerSupport.getStepOverHandler must not return null");
        }
        return stepOverActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getStepIntoHandler() {
        StepIntoActionHandler stepIntoActionHandler = this.myStepIntoActionHandler;
        if (stepIntoActionHandler == null) {
            throw new IllegalStateException("@NotNull method com/intellij/debugger/ui/JavaDebuggerSupport.getStepIntoHandler must not return null");
        }
        return stepIntoActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getSmartStepIntoHandler() {
        DebuggerActionHandler debuggerActionHandler = this.mySmartStepIntoHandler;
        if (debuggerActionHandler == null) {
            throw new IllegalStateException("@NotNull method com/intellij/debugger/ui/JavaDebuggerSupport.getSmartStepIntoHandler must not return null");
        }
        return debuggerActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getStepOutHandler() {
        StepOutActionHandler stepOutActionHandler = this.myStepOutActionHandler;
        if (stepOutActionHandler == null) {
            throw new IllegalStateException("@NotNull method com/intellij/debugger/ui/JavaDebuggerSupport.getStepOutHandler must not return null");
        }
        return stepOutActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getForceStepOverHandler() {
        ForceStepOverActionHandler forceStepOverActionHandler = this.myForceStepOverActionHandler;
        if (forceStepOverActionHandler == null) {
            throw new IllegalStateException("@NotNull method com/intellij/debugger/ui/JavaDebuggerSupport.getForceStepOverHandler must not return null");
        }
        return forceStepOverActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getForceStepIntoHandler() {
        ForceStepIntoActionHandler forceStepIntoActionHandler = this.myForceStepIntoActionHandler;
        if (forceStepIntoActionHandler == null) {
            throw new IllegalStateException("@NotNull method com/intellij/debugger/ui/JavaDebuggerSupport.getForceStepIntoHandler must not return null");
        }
        return forceStepIntoActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getRunToCursorHandler() {
        RunToCursorActionHandler runToCursorActionHandler = this.myRunToCursorActionHandler;
        if (runToCursorActionHandler == null) {
            throw new IllegalStateException("@NotNull method com/intellij/debugger/ui/JavaDebuggerSupport.getRunToCursorHandler must not return null");
        }
        return runToCursorActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getForceRunToCursorHandler() {
        ForceRunToCursorActionHandler forceRunToCursorActionHandler = this.myForceRunToCursorActionHandler;
        if (forceRunToCursorActionHandler == null) {
            throw new IllegalStateException("@NotNull method com/intellij/debugger/ui/JavaDebuggerSupport.getForceRunToCursorHandler must not return null");
        }
        return forceRunToCursorActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getResumeActionHandler() {
        ResumeActionHandler resumeActionHandler = this.myResumeActionHandler;
        if (resumeActionHandler == null) {
            throw new IllegalStateException("@NotNull method com/intellij/debugger/ui/JavaDebuggerSupport.getResumeActionHandler must not return null");
        }
        return resumeActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getPauseHandler() {
        PauseActionHandler pauseActionHandler = this.myPauseActionHandler;
        if (pauseActionHandler == null) {
            throw new IllegalStateException("@NotNull method com/intellij/debugger/ui/JavaDebuggerSupport.getPauseHandler must not return null");
        }
        return pauseActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getToggleLineBreakpointHandler() {
        ToggleLineBreakpointActionHandler toggleLineBreakpointActionHandler = this.myToggleLineBreakpointActionHandler;
        if (toggleLineBreakpointActionHandler == null) {
            throw new IllegalStateException("@NotNull method com/intellij/debugger/ui/JavaDebuggerSupport.getToggleLineBreakpointHandler must not return null");
        }
        return toggleLineBreakpointActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getShowExecutionPointHandler() {
        ShowExecutionPointActionHandler showExecutionPointActionHandler = this.myShowExecutionPointActionHandler;
        if (showExecutionPointActionHandler == null) {
            throw new IllegalStateException("@NotNull method com/intellij/debugger/ui/JavaDebuggerSupport.getShowExecutionPointHandler must not return null");
        }
        return showExecutionPointActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getEvaluateHandler() {
        EvaluateActionHandler evaluateActionHandler = this.myEvaluateActionHandler;
        if (evaluateActionHandler == null) {
            throw new IllegalStateException("@NotNull method com/intellij/debugger/ui/JavaDebuggerSupport.getEvaluateHandler must not return null");
        }
        return evaluateActionHandler;
    }

    @Override
    @NotNull
    public QuickEvaluateHandler getQuickEvaluateHandler() {
        QuickEvaluateActionHandler quickEvaluateActionHandler = this.myQuickEvaluateHandler;
        if (quickEvaluateActionHandler == null) {
            throw new IllegalStateException("@NotNull method com/intellij/debugger/ui/JavaDebuggerSupport.getQuickEvaluateHandler must not return null");
        }
        return quickEvaluateActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getAddToWatchesActionHandler() {
        DebuggerActionHandler debuggerActionHandler = this.myAddToWatchedActionHandler;
        if (debuggerActionHandler == null) {
            throw new IllegalStateException("@NotNull method com/intellij/debugger/ui/JavaDebuggerSupport.getAddToWatchesActionHandler must not return null");
        }
        return debuggerActionHandler;
    }

    @Override
    @NotNull
    public DebuggerToggleActionHandler getMuteBreakpointsHandler() {
        MuteBreakpointsActionHandler muteBreakpointsActionHandler = this.myMuteBreakpointsHandler;
        if (muteBreakpointsActionHandler == null) {
            throw new IllegalStateException("@NotNull method com/intellij/debugger/ui/JavaDebuggerSupport.getMuteBreakpointsHandler must not return null");
        }
        return muteBreakpointsActionHandler;
    }

    @Override
    public AbstractDebuggerSession getCurrentSession(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/debugger/ui/JavaDebuggerSupport.getCurrentSession must not be null");
        }
        DebuggerContextImpl context = DebuggerManagerEx.getInstanceEx(project).getContext();
        return context != null ? context.getDebuggerSession() : null;
    }

    @Override
    @NotNull
    public DebuggerSettingsPanelProvider getSettingsPanelProvider() {
        JavaDebuggerSettingsPanelProvider javaDebuggerSettingsPanelProvider = this.myDebuggerSettingsPanelProvider;
        if (javaDebuggerSettingsPanelProvider == null) {
            throw new IllegalStateException("@NotNull method com/intellij/debugger/ui/JavaDebuggerSupport.getSettingsPanelProvider must not return null");
        }
        return javaDebuggerSettingsPanelProvider;
    }

    public static class JavaDebuggerSettingsPanelProvider
    extends DebuggerSettingsPanelProvider {
        @Override
        public int getPriority() {
            return 1;
        }

        @Override
        public Configurable getRootConfigurable() {
            return new DebuggerLaunchingConfigurable();
        }

        @Override
        public Collection<? extends Configurable> getConfigurables(Project project) {
            ArrayList<Object> configurables = new ArrayList<Object>();
            configurables.add(new DebuggerDataViewsConfigurable(project));
            configurables.add(new DebuggerSteppingConfigurable(project));
            configurables.add(new UserRenderersConfigurable(project));
            configurables.add(new DebuggerHotswapConfigurable());
            return configurables;
        }

        @Override
        public void apply() {
            NodeRendererSettings.getInstance().fireRenderersChanged();
        }
    }

    private static class JavaBreakpointPanelProvider
    extends BreakpointPanelProvider<Breakpoint> {
        private JavaBreakpointPanelProvider() {
        }

        @Override
        @NotNull
        public Collection<AbstractBreakpointPanel<Breakpoint>> getBreakpointPanels(@NotNull Project project, @NotNull DialogWrapper parentDialog) {
            BreakpointFactory[] allFactories;
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/debugger/ui/JavaDebuggerSupport$JavaBreakpointPanelProvider.getBreakpointPanels must not be null");
            }
            if (parentDialog == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/debugger/ui/JavaDebuggerSupport$JavaBreakpointPanelProvider.getBreakpointPanels must not be null");
            }
            ArrayList<AbstractBreakpointPanel<Breakpoint>> panels = new ArrayList<AbstractBreakpointPanel<Breakpoint>>();
            for (BreakpointFactory factory : allFactories = (BreakpointFactory[])ApplicationManager.getApplication().getExtensions(BreakpointFactory.EXTENSION_POINT_NAME)) {
                BreakpointPanel panel = factory.createBreakpointPanel(project, parentDialog);
                if (panel == null) continue;
                panel.setupPanelUI();
                panels.add(panel);
            }
            ArrayList<AbstractBreakpointPanel<Breakpoint>> arrayList = panels;
            if (arrayList == null) {
                throw new IllegalStateException("@NotNull method com/intellij/debugger/ui/JavaDebuggerSupport$JavaBreakpointPanelProvider.getBreakpointPanels must not return null");
            }
            return arrayList;
        }

        @Override
        public int getPriority() {
            return 1;
        }

        @Override
        public Breakpoint findBreakpoint(@NotNull Project project, @NotNull Document document, int offset) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/debugger/ui/JavaDebuggerSupport$JavaBreakpointPanelProvider.findBreakpoint must not be null");
            }
            if (document == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/debugger/ui/JavaDebuggerSupport$JavaBreakpointPanelProvider.findBreakpoint must not be null");
            }
            return DebuggerManagerEx.getInstanceEx(project).getBreakpointManager().findBreakpoint(document, offset, null);
        }

        @Override
        public void onDialogClosed(Project project) {
            DebuggerManagerEx.getInstanceEx(project).getBreakpointManager().updateAllRequests();
        }
    }
}

