/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerManagerListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.HotSwapFile;
import com.intellij.debugger.impl.HotSwapProgress;
import com.intellij.debugger.impl.MultiProcessCommand;
import com.intellij.debugger.impl.ReloadClassesWorker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.ex.CompilerPathsEx;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectClasspathTraversing;
import com.intellij.openapi.roots.ProjectRootsTraversing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class HotSwapManager
extends AbstractProjectComponent {
    private final Map<DebuggerSession, Long> myTimeStamps = new HashMap();
    private static final String CLASS_EXTENSION = ".class";

    public HotSwapManager(Project project, DebuggerManagerEx manager) {
        super(project);
        manager.addDebuggerManagerListener(new DebuggerManagerListener(){

            @Override
            public void sessionCreated(DebuggerSession session) {
                HotSwapManager.this.myTimeStamps.put(session, System.currentTimeMillis());
            }

            @Override
            public void sessionRemoved(DebuggerSession session) {
                HotSwapManager.this.myTimeStamps.remove(session);
            }
        });
    }

    @NotNull
    public String getComponentName() {
        if ("HotSwapManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/debugger/impl/HotSwapManager.getComponentName must not return null");
        }
        return "HotSwapManager";
    }

    private long getTimeStamp(DebuggerSession session) {
        Long tStamp = this.myTimeStamps.get(session);
        return tStamp != null ? tStamp : 0L;
    }

    void setTimeStamp(DebuggerSession session, long tStamp) {
        this.myTimeStamps.put(session, tStamp);
    }

    public HashMap<String, HotSwapFile> getModifiedClasses(DebuggerSession session, final HotSwapProgress progress) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        final long timeStamp = this.getTimeStamp(session);
        final HashMap modifiedClasses = new HashMap();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                List allClasses = ProjectRootsTraversing.collectRoots((Project)HotSwapManager.this.myProject, (ProjectRootsTraversing.RootTraversePolicy)ProjectClasspathTraversing.FULL_CLASSPATH_RECURSIVE).getRootDirs();
                VirtualFile[] allDirs = VfsUtil.toVirtualFileArray((Collection)allClasses);
                final FileTypeManager fileTypeManager = FileTypeManager.getInstance();
                CompilerPathsEx.visitFiles((VirtualFile[])allDirs, (CompilerPathsEx.FileVisitor)new CompilerPathsEx.FileVisitor(){

                    protected void acceptDirectory(VirtualFile file, String fileRoot, String filePath) {
                        progress.setText(DebuggerBundle.message((String)"progress.hotswap.scanning.path", (Object[])new Object[]{filePath}));
                        if (file.getFileSystem() instanceof JarFileSystem && FileTypes.ARCHIVE.equals(fileTypeManager.getFileTypeByFile(file))) {
                            if (file.getTimeStamp() > timeStamp) {
                                super.acceptDirectory(file, fileRoot, filePath);
                            }
                        } else {
                            super.acceptDirectory(file, fileRoot, filePath);
                        }
                    }

                    protected void acceptFile(VirtualFile file, String fileRoot, String filePath) {
                        if (file.getTimeStamp() > timeStamp && StdFileTypes.CLASS.equals(fileTypeManager.getFileTypeByFile(file)) && (SystemInfo.isFileSystemCaseSensitive ? filePath.endsWith(HotSwapManager.CLASS_EXTENSION) : StringUtil.endsWithIgnoreCase((String)filePath, (String)HotSwapManager.CLASS_EXTENSION))) {
                            progress.setText(DebuggerBundle.message((String)"progress.hotswap.scanning.path", (Object[])new Object[]{filePath}));
                            String qualifiedName = filePath.substring(fileRoot.length() + 1, filePath.length() - HotSwapManager.CLASS_EXTENSION.length()).replace('/', '.');
                            modifiedClasses.put((Object)qualifiedName, (Object)new HotSwapFile(file));
                        }
                    }
                });
            }
        });
        return modifiedClasses;
    }

    public static HotSwapManager getInstance(Project project) {
        return (HotSwapManager)((Object)project.getComponent(HotSwapManager.class));
    }

    private void reloadClasses(DebuggerSession session, Map<String, HotSwapFile> classesToReload, HotSwapProgress progress) {
        long newSwapTime = System.currentTimeMillis();
        new ReloadClassesWorker(session, progress).reloadClasses(classesToReload);
        this.setTimeStamp(session, newSwapTime);
    }

    public static Map<DebuggerSession, Map<String, HotSwapFile>> getModifiedClasses(List<DebuggerSession> sessions, final HotSwapProgress swapProgress) {
        HashMap modifiedClasses = new HashMap();
        final MultiProcessCommand scanClassesCommand = new MultiProcessCommand();
        swapProgress.setCancelWorker(new Runnable(){

            @Override
            public void run() {
                scanClassesCommand.terminate();
            }
        });
        for (final DebuggerSession debuggerSession : sessions) {
            if (!debuggerSession.isAttached()) continue;
            scanClassesCommand.addCommand(debuggerSession.getProcess(), new DebuggerCommandImpl((Map)modifiedClasses){
                final /* synthetic */ Map val$modifiedClasses;
                {
                    this.val$modifiedClasses = map;
                }

                @Override
                protected void action() throws Exception {
                    swapProgress.setDebuggerSession(debuggerSession);
                    HashMap<String, HotSwapFile> sessionClasses = HotSwapManager.getInstance(swapProgress.getProject()).getModifiedClasses(debuggerSession, swapProgress);
                    if (!sessionClasses.isEmpty()) {
                        this.val$modifiedClasses.put(debuggerSession, sessionClasses);
                    }
                }
            });
        }
        swapProgress.setTitle(DebuggerBundle.message((String)"progress.hotswap.scanning.classes", (Object[])new Object[0]));
        scanClassesCommand.run();
        return swapProgress.isCancelled() ? new HashMap() : modifiedClasses;
    }

    public static void reloadModifiedClasses(final Map<DebuggerSession, Map<String, HotSwapFile>> modifiedClasses, final HotSwapProgress reloadClassesProgress) {
        final MultiProcessCommand reloadClassesCommand = new MultiProcessCommand();
        reloadClassesProgress.setCancelWorker(new Runnable(){

            @Override
            public void run() {
                reloadClassesCommand.terminate();
            }
        });
        for (final DebuggerSession debuggerSession : modifiedClasses.keySet()) {
            reloadClassesCommand.addCommand(debuggerSession.getProcess(), new DebuggerCommandImpl(){

                @Override
                protected void action() throws Exception {
                    reloadClassesProgress.setDebuggerSession(debuggerSession);
                    HotSwapManager.getInstance(reloadClassesProgress.getProject()).reloadClasses(debuggerSession, (Map)modifiedClasses.get(debuggerSession), reloadClassesProgress);
                }
            });
        }
        reloadClassesProgress.setTitle(DebuggerBundle.message((String)"progress.hotswap.reloading", (Object[])new Object[0]));
        reloadClassesCommand.run();
    }
}

