/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RequestHint {
    public static final int STOP = 0;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.RequestHint");
    private final int myDepth;
    private SourcePosition myPosition;
    private int myFrameCount;
    private VirtualMachineProxyImpl myVirtualMachineProxy;
    @Nullable
    private final SmartStepFilter myTargetMethodSignature;
    private boolean myIgnoreFilters;
    private boolean myRestoreBreakpoints;
    private final boolean mySkipThisMethod = false;

    public RequestHint(ThreadReferenceProxyImpl stepThread, SuspendContextImpl suspendContext, @NotNull SmartStepFilter smartStepFilter) {
        if (smartStepFilter == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/debugger/engine/RequestHint.<init> must not be null");
        }
        this(stepThread, suspendContext, 1, smartStepFilter);
    }

    public RequestHint(ThreadReferenceProxyImpl stepThread, SuspendContextImpl suspendContext, int depth) {
        this(stepThread, suspendContext, depth, null);
    }

    private RequestHint(final ThreadReferenceProxyImpl stepThread, final SuspendContextImpl suspendContext, int depth, SmartStepFilter smartStepFilter) {
        this.myIgnoreFilters = false;
        this.myRestoreBreakpoints = false;
        this.mySkipThisMethod = false;
        DebugProcessImpl debugProcess = suspendContext.getDebugProcess();
        this.myDepth = depth;
        this.myTargetMethodSignature = smartStepFilter;
        this.myVirtualMachineProxy = debugProcess.getVirtualMachineProxy();
        try {
            this.myFrameCount = stepThread.frameCount();
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    RequestHint.this.myPosition = ContextUtil.getSourcePosition(new StackFrameContext(){

                        public StackFrameProxy getFrameProxy() {
                            try {
                                return stepThread.frame(0);
                            }
                            catch (EvaluateException e) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Throwable)e);
                                }
                                return null;
                            }
                        }

                        public DebugProcess getDebugProcess() {
                            return suspendContext.getDebugProcess();
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            this.myPosition = null;
        }
    }

    public void setIgnoreFilters(boolean ignoreFilters) {
        this.myIgnoreFilters = ignoreFilters;
    }

    public void setRestoreBreakpoints(boolean restoreBreakpoints) {
        this.myRestoreBreakpoints = restoreBreakpoints;
    }

    public boolean isRestoreBreakpoints() {
        return this.myRestoreBreakpoints;
    }

    public boolean isIgnoreFilters() {
        return this.myIgnoreFilters;
    }

    public int getDepth() {
        return this.myDepth;
    }

    public int getNextStepDepth(final SuspendContextImpl context) {
        try {
            Integer resultDepth;
            if ((this.myDepth == 2 || this.myDepth == 1) && this.myPosition != null && (resultDepth = (Integer)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Integer>(){

                public Integer compute() {
                    boolean filesEqual;
                    SourcePosition locationPosition = ContextUtil.getSourcePosition((StackFrameContext)context);
                    if (locationPosition == null) {
                        return null;
                    }
                    int frameCount = -1;
                    ThreadReferenceProxyImpl contextThread = context.getThread();
                    if (contextThread != null) {
                        try {
                            frameCount = contextThread.frameCount();
                        }
                        catch (EvaluateException e) {
                            // empty catch block
                        }
                    }
                    if ((filesEqual = RequestHint.this.myPosition.getFile().equals(locationPosition.getFile())) && RequestHint.this.myPosition.getLine() == locationPosition.getLine() && RequestHint.this.myFrameCount == frameCount) {
                        return RequestHint.this.myDepth;
                    }
                    if (RequestHint.this.myDepth == 1 && filesEqual && RequestHint.this.myFrameCount == frameCount && RequestHint.this.myPosition.getLine() != locationPosition.getLine()) {
                        return 0;
                    }
                    return null;
                }
            })) != null) {
                return resultDepth;
            }
            if (this.myDepth == 1) {
                Location location;
                Method method;
                DebuggerSettings settings = DebuggerSettings.getInstance();
                StackFrameProxyImpl frameProxy = context.getFrameProxy();
                if (settings.SKIP_SYNTHETIC_METHODS && frameProxy != null && (method = (location = frameProxy.location()).method()) != null && (this.myVirtualMachineProxy.canGetSyntheticAttribute() ? method.isSynthetic() : method.name().indexOf(36) >= 0)) {
                    return this.myDepth;
                }
                if (!this.myIgnoreFilters) {
                    boolean isGetter;
                    if (settings.SKIP_GETTERS && (isGetter = ((Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                        public Boolean compute() {
                            PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)PositionUtil.getContextElement((StackFrameContext)context), PsiMethod.class);
                            return psiMethod != null && DebuggerUtils.isSimpleGetter((PsiMethod)psiMethod) ? Boolean.TRUE : Boolean.FALSE;
                        }
                    })).booleanValue())) {
                        return 3;
                    }
                    if (frameProxy != null) {
                        if (settings.SKIP_CONSTRUCTORS && (method = (location = frameProxy.location()).method()) != null && method.isConstructor()) {
                            return 3;
                        }
                        if (settings.SKIP_CLASSLOADERS && DebuggerUtilsEx.isAssignableFrom("java.lang.ClassLoader", (location = frameProxy.location()).declaringType())) {
                            return 3;
                        }
                    }
                }
                if (this.myTargetMethodSignature != null && !this.myTargetMethodSignature.shouldStopAtLocation(context)) {
                    return 3;
                }
            }
        }
        catch (VMDisconnectedException e) {
        }
        catch (EvaluateException e) {
            LOG.error((Throwable)e);
        }
        return 0;
    }

    public static final class SmartStepFilter {
        private final JVMName myDeclaringClassName;
        @NonNls
        private final String myTargetMethodName;
        private final JVMName myTargetMethodSignature;

        public SmartStepFilter(PsiMethod psiMethod) {
            this.myDeclaringClassName = JVMNameUtil.getJVMQualifiedName(psiMethod.getContainingClass());
            this.myTargetMethodName = psiMethod.isConstructor() ? "<init>" : psiMethod.getName();
            this.myTargetMethodSignature = JVMNameUtil.getJVMSignature(psiMethod);
        }

        public boolean shouldStopAtLocation(SuspendContextImpl context) {
            try {
                StackFrameProxyImpl frameProxy = context.getFrameProxy();
                if (frameProxy == null) {
                    return true;
                }
                Location location = frameProxy.location();
                Method method = location.method();
                if (!this.myTargetMethodName.equals(method.name())) {
                    return false;
                }
                DebugProcessImpl process = context.getDebugProcess();
                if (!SmartStepFilter.signatureMatches(method, this.myTargetMethodSignature.getName(process))) {
                    return false;
                }
                ObjectReference thisObject = frameProxy.thisObject();
                ReferenceType locationClass = thisObject != null ? thisObject.referenceType() : method.declaringType();
                return DebuggerUtilsEx.isAssignableFrom(this.myDeclaringClassName.getName(process), locationClass);
            }
            catch (EvaluateException e) {
                LOG.info((Throwable)e);
                return true;
            }
        }

        private static boolean signatureMatches(Method method, String expectedSignature) throws EvaluateException {
            if (expectedSignature.equals(method.signature())) {
                return true;
            }
            for (Method candidate : method.declaringType().methodsByName(method.name())) {
                if (candidate == method || !candidate.isBridge() || !expectedSignature.equals(candidate.signature())) continue;
                return true;
            }
            return false;
        }
    }
}

