/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.progress.util.ProgressWindowWithNotification;
import com.intellij.openapi.project.Project;
import com.sun.jdi.Value;
import org.jetbrains.annotations.Nullable;

public abstract class BaseValueAction
extends DebuggerAction {
    public void actionPerformed(AnActionEvent e) {
        DebuggerContextImpl debuggerContext;
        DataContext actionContext = e.getDataContext();
        final Project project = (Project)PlatformDataKeys.PROJECT.getData(actionContext);
        final Value value = BaseValueAction.getValue(actionContext);
        if (value == null) {
            return;
        }
        DebuggerManagerEx debuggerManager = DebuggerManagerEx.getInstanceEx(project);
        if (debuggerManager != null && (debuggerContext = debuggerManager.getContext()) != null && debuggerContext.getDebuggerSession() != null) {
            final ProgressWindowWithNotification progressWindow = new ProgressWindowWithNotification(true, project);
            SuspendContextCommandImpl copyValueAction = new SuspendContextCommandImpl(debuggerContext.getSuspendContext()){

                @Override
                public PrioritizedTask.Priority getPriority() {
                    return PrioritizedTask.Priority.HIGH;
                }

                @Override
                public void contextAction() throws Exception {
                    progressWindow.setText(DebuggerBundle.message((String)"progress.evaluating", (Object[])new Object[]{"toString()"}));
                    final String valueAsString = DebuggerUtilsEx.getValueOrErrorAsString(debuggerContext.createEvaluationContext(), value);
                    if (progressWindow.isCanceled()) {
                        return;
                    }
                    DebuggerInvocationUtil.swingInvokeLater(project, new Runnable(){

                        @Override
                        public void run() {
                            String text = valueAsString;
                            if (text == null) {
                                text = "";
                            }
                            BaseValueAction.this.processText(project, text);
                        }
                    });
                }
            };
            progressWindow.setTitle(DebuggerBundle.message((String)"title.evaluating", (Object[])new Object[0]));
            debuggerContext.getDebugProcess().getManagerThread().startProgress(copyValueAction, progressWindow);
        }
    }

    protected abstract void processText(Project var1, String var2);

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Value value = BaseValueAction.getValue(e.getDataContext());
        presentation.setEnabled(value != null);
        presentation.setVisible(value != null);
    }

    @Nullable
    public static Value getValue(DataContext context) {
        DebuggerTreeNodeImpl selectedNode = BaseValueAction.getSelectedNode(context);
        if (selectedNode == null) {
            return null;
        }
        NodeDescriptorImpl descriptor = selectedNode.getDescriptor();
        if (!(descriptor instanceof ValueDescriptorImpl)) {
            return null;
        }
        return ((ValueDescriptorImpl)descriptor).getValue();
    }
}

