/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.progress;

import com.intellij.compiler.CompilerManagerImpl;
import com.intellij.compiler.CompilerMessageImpl;
import com.intellij.compiler.impl.CompilerErrorTreeView;
import com.intellij.compiler.progress.CompilerProgressDialog;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.ide.errorTreeView.impl.ErrorTreeViewConfiguration;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbModeAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.peer.PeerFactory;
import com.intellij.pom.Navigatable;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.MessageView;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompilerTask
extends Task.Backgroundable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.progress.CompilerProgressIndicator");
    private static final boolean IS_UNIT_TEST_MODE = ApplicationManager.getApplication().isUnitTestMode();
    private static final int UPDATE_INTERVAL = 50;
    private static final Key<Key<?>> CONTENT_ID_KEY = Key.create((String)"CONTENT_ID");
    private Key<Key<?>> myContentIdKey;
    private final Key<Key<?>> myContentId;
    private CompilerProgressDialog myDialog;
    private NewErrorTreeViewPanel myErrorTreeView;
    private final Object myMessageViewLock;
    private final String myContentName;
    private final boolean myHeadlessMode;
    private boolean myIsBackgroundMode;
    private int myErrorCount;
    private int myWarningCount;
    private final Alarm myAlarm;
    private boolean myMessagesAutoActivated;
    private volatile ProgressIndicator myIndicator;
    private Runnable myCompileWork;
    private final AtomicBoolean myMessageViewWasPrepared;
    private Runnable myRestartWork;
    private CloseListener myCloseListener;
    private final Runnable myRepaintRequest;

    public CompilerTask(@NotNull Project project, boolean compileInBackground, String contentName, boolean headlessMode) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/progress/CompilerTask.<init> must not be null");
        }
        super(project, contentName);
        this.myContentIdKey = CONTENT_ID_KEY;
        this.myContentId = Key.create((String)"compile_content");
        this.myMessageViewLock = new Object();
        this.myErrorCount = 0;
        this.myWarningCount = 0;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD);
        this.myMessagesAutoActivated = false;
        this.myIndicator = new EmptyProgressIndicator();
        this.myMessageViewWasPrepared = new AtomicBoolean(false);
        this.myRepaintRequest = new Runnable(){
            private final Runnable myRepaintRunnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String s = CompilerTask.this.myIndicator.getText();
                    if (CompilerTask.this.myIndicator.getFraction() > 0.0) {
                        s = s + " " + (int)(CompilerTask.this.myIndicator.getFraction() * 100.0 + 0.5) + "%";
                    }
                    Object object = CompilerTask.this.myMessageViewLock;
                    synchronized (object) {
                        if (CompilerTask.this.myIsBackgroundMode) {
                            if (CompilerTask.this.myErrorTreeView != null) {
                                CompilerTask.this.myErrorTreeView.setProgressStatistics("");
                            }
                        } else if (CompilerTask.this.myDialog != null) {
                            CompilerTask.this.myDialog.setStatusText(s);
                            CompilerTask.this.myDialog.setStatisticsText("");
                        }
                    }
                }
            };

            @Override
            public void run() {
                SwingUtilities.invokeLater(this.myRepaintRunnable);
            }
        };
        this.myIsBackgroundMode = compileInBackground;
        this.myContentName = contentName;
        this.myHeadlessMode = headlessMode || IS_UNIT_TEST_MODE;
    }

    public void setContentIdKey(Key<Key<?>> contentIdKey) {
        this.myContentIdKey = contentIdKey != null ? contentIdKey : CONTENT_ID_KEY;
    }

    public String getProcessId() {
        return "compilation";
    }

    public DumbModeAction getDumbModeAction() {
        return DumbModeAction.WAIT;
    }

    public boolean shouldStartInBackground() {
        return this.myIsBackgroundMode;
    }

    public ProgressIndicator getIndicator() {
        return this.myIndicator;
    }

    @Nullable
    public Task.NotificationInfo getNotificationInfo() {
        return new Task.NotificationInfo("Compiler", "Compilation Finished", this.myErrorCount + " Errors, " + this.myWarningCount + " Warnings", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/progress/CompilerTask.run must not be null");
        }
        this.myIndicator = indicator;
        ProjectManager projectManager = ProjectManager.getInstance();
        this.myCloseListener = new CloseListener();
        projectManager.addProjectManagerListener(this.myProject, (ProjectManagerListener)this.myCloseListener);
        Semaphore semaphore = ((CompilerManagerImpl)CompilerManager.getInstance((Project)this.myProject)).getCompilationSemaphore();
        semaphore.acquireUninterruptibly();
        try {
            if (!this.isHeadless()) {
                this.addIndicatorDelegate();
            }
            this.myCompileWork.run();
        }
        finally {
            indicator.stop();
            projectManager.removeProjectManagerListener(this.myProject, (ProjectManagerListener)this.myCloseListener);
            semaphore.release();
        }
    }

    private void prepareMessageView() {
        if (!this.myIndicator.isRunning()) {
            return;
        }
        if (this.myMessageViewWasPrepared.getAndSet(true)) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = CompilerTask.this.myMessageViewLock;
                synchronized (object) {
                    if (CompilerTask.this.myErrorTreeView == null) {
                        CompilerTask.this.removeAllContents(CompilerTask.this.myProject, null);
                    }
                }
            }
        });
    }

    private void addIndicatorDelegate() {
        ((ProgressIndicatorEx)this.myIndicator).addStateDelegate(new ProgressIndicatorBase(){

            @Override
            public void cancel() {
                super.cancel();
                CompilerTask.this.closeUI();
            }

            @Override
            public void stop() {
                super.stop();
                if (!this.isCanceled()) {
                    CompilerTask.this.closeUI();
                }
            }

            @Override
            public void setText(String text) {
                CompilerTask.this.updateProgressText();
            }

            @Override
            public void setText2(String text) {
                CompilerTask.this.updateProgressText();
            }

            @Override
            public void setFraction(double fraction) {
                CompilerTask.this.updateProgressText();
            }

            @Override
            protected void onProgressChange() {
                CompilerTask.this.prepareMessageView();
            }
        });
    }

    public void cancel() {
        if (!this.myIndicator.isCanceled()) {
            this.myIndicator.cancel();
        }
    }

    public void addMessage(final CompilerMessage message) {
        this.prepareMessageView();
        CompilerMessageCategory messageCategory = message.getCategory();
        if (CompilerMessageCategory.WARNING.equals((Object)messageCategory)) {
            ++this.myWarningCount;
        } else if (CompilerMessageCategory.ERROR.equals((Object)messageCategory)) {
            ++this.myErrorCount;
            this.informWolf(message);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            this.openMessageView();
            this.doAddMessage(message);
        } else {
            Window window = this.getWindow();
            ModalityState modalityState = window != null ? ModalityState.stateForComponent((Component)window) : ModalityState.NON_MODAL;
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!CompilerTask.this.myProject.isDisposed()) {
                        CompilerTask.this.openMessageView();
                        CompilerTask.this.doAddMessage(message);
                    }
                }
            }, modalityState);
        }
    }

    private void informWolf(CompilerMessage message) {
        WolfTheProblemSolver wolf = WolfTheProblemSolver.getInstance((Project)this.myProject);
        VirtualFile file = CompilerTask.getVirtualFile(message);
        wolf.queue(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAddMessage(CompilerMessage message) {
        Object object = this.myMessageViewLock;
        synchronized (object) {
            if (this.myErrorTreeView != null) {
                boolean shouldAutoActivate;
                Navigatable navigatable = message.getNavigatable();
                VirtualFile file = message.getVirtualFile();
                CompilerMessageCategory category = message.getCategory();
                int type = CompilerTask.translateCategory(category);
                String[] text = CompilerTask.convertMessage(message);
                if (navigatable != null) {
                    String groupName = file != null ? file.getPresentableUrl() : category.getPresentableText();
                    this.myErrorTreeView.addMessage(type, text, groupName, navigatable, message.getExportTextPrefix(), message.getRenderTextPrefix(), message.getVirtualFile());
                } else {
                    this.myErrorTreeView.addMessage(type, text, file, -1, -1, message.getVirtualFile());
                }
                boolean bl = shouldAutoActivate = !this.myMessagesAutoActivated && (CompilerMessageCategory.ERROR.equals((Object)category) || CompilerMessageCategory.WARNING.equals((Object)category) && !ErrorTreeViewConfiguration.getInstance(this.myProject).isHideWarnings());
                if (shouldAutoActivate) {
                    this.myMessagesAutoActivated = true;
                    this.activateMessageView();
                }
            }
        }
    }

    private static String[] convertMessage(CompilerMessage message) {
        String text = message.getMessage();
        if (!text.contains("\n")) {
            return new String[]{text};
        }
        ArrayList<String> lines = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(text, "\n", false);
        while (tokenizer.hasMoreTokens()) {
            lines.add(tokenizer.nextToken());
        }
        return ArrayUtil.toStringArray(lines);
    }

    public static int translateCategory(CompilerMessageCategory category) {
        if (CompilerMessageCategory.ERROR.equals((Object)category)) {
            return 4;
        }
        if (CompilerMessageCategory.WARNING.equals((Object)category)) {
            return 5;
        }
        if (CompilerMessageCategory.STATISTICS.equals((Object)category)) {
            return 2;
        }
        if (CompilerMessageCategory.INFORMATION.equals((Object)category)) {
            return 3;
        }
        LOG.error("Unknown message category: " + category);
        return 0;
    }

    public void start(Runnable compileWork, Runnable restartWork) {
        this.myCompileWork = compileWork;
        this.myRestartWork = restartWork;
        this.queue();
    }

    private void updateProgressText() {
        if (this.isHeadlessMode()) {
            return;
        }
        if (this.myAlarm.getActiveRequestCount() == 0) {
            this.myAlarm.addRequest(this.myRepaintRequest, 50);
        }
    }

    public void sendToBackground() {
        this.myIsBackgroundMode = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CompilerTask.this.closeProgressDialog();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openMessageView() {
        JComponent component;
        if (this.isHeadlessMode()) {
            return;
        }
        if (this.myIndicator.isCanceled()) {
            return;
        }
        Object object = this.myMessageViewLock;
        synchronized (object) {
            if (this.myErrorTreeView != null) {
                return;
            }
            this.myErrorTreeView = new CompilerErrorTreeView(this.myProject, this.myRestartWork);
            this.myErrorTreeView.setProcessController(new NewErrorTreeViewPanel.ProcessController(){

                @Override
                public void stopProcess() {
                    CompilerTask.this.cancel();
                }

                @Override
                public boolean isProcessStopped() {
                    return !CompilerTask.this.myIndicator.isRunning();
                }
            });
            component = this.myErrorTreeView.getComponent();
        }
        MessageView messageView = MessageView.SERVICE.getInstance(this.myProject);
        Content content = PeerFactory.getInstance().getContentFactory().createContent(component, this.myContentName, true);
        content.putUserData(this.myContentIdKey, this.myContentId);
        messageView.getContentManager().addContent(content);
        this.myCloseListener.setContent(content, messageView.getContentManager());
        this.removeAllContents(this.myProject, content);
        messageView.getContentManager().setSelectedContent(content);
        this.updateProgressText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showCompilerContent() {
        Object object = this.myMessageViewLock;
        synchronized (object) {
            if (this.myErrorTreeView != null) {
                Content[] contents;
                MessageView messageView = MessageView.SERVICE.getInstance(this.myProject);
                for (Content content : contents = messageView.getContentManager().getContents()) {
                    if (content.getUserData(this.myContentIdKey) == null) continue;
                    messageView.getContentManager().setSelectedContent(content);
                    return;
                }
            }
        }
    }

    private void removeAllContents(Project project, Content notRemove) {
        Content[] contents;
        MessageView messageView = MessageView.SERVICE.getInstance(project);
        for (Content content : contents = messageView.getContentManager().getContents()) {
            if (content.isPinned() || content == notRemove || content.getUserData(this.myContentIdKey) == null) continue;
            messageView.getContentManager().removeContent(content, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateMessageView() {
        Object object = this.myMessageViewLock;
        synchronized (object) {
            if (this.myErrorTreeView != null) {
                ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ToolWindowId.MESSAGES_WINDOW).activate(null);
            }
        }
    }

    private void closeUI() {
        if (this.isHeadlessMode()) {
            return;
        }
        Window window = this.getWindow();
        ModalityState modalityState = window != null ? ModalityState.stateForComponent((Component)window) : ModalityState.NON_MODAL;
        Application application = ApplicationManager.getApplication();
        application.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CompilerTask.this.closeProgressDialog();
                Object object = CompilerTask.this.myMessageViewLock;
                synchronized (object) {
                    if (CompilerTask.this.myErrorTreeView != null) {
                        boolean shouldRetainView;
                        boolean bl = shouldRetainView = CompilerTask.this.myErrorCount > 0 || CompilerTask.this.myWarningCount > 0 && !CompilerTask.this.myErrorTreeView.isHideWarnings();
                        if (shouldRetainView) {
                            CompilerTask.this.addMessage(new CompilerMessageImpl(CompilerTask.this.myProject, CompilerMessageCategory.STATISTICS, CompilerBundle.message((String)"statistics.error.count", (Object[])new Object[]{CompilerTask.this.myErrorCount}), null, -1, -1, null));
                            CompilerTask.this.addMessage(new CompilerMessageImpl(CompilerTask.this.myProject, CompilerMessageCategory.STATISTICS, CompilerBundle.message((String)"statistics.warnings.count", (Object[])new Object[]{CompilerTask.this.myWarningCount}), null, -1, -1, null));
                            CompilerTask.this.myErrorTreeView.selectFirstMessage();
                        } else {
                            CompilerTask.this.removeAllContents(CompilerTask.this.myProject, null);
                        }
                    }
                }
            }
        }, modalityState);
    }

    public Window getWindow() {
        if (!this.myIsBackgroundMode && this.myDialog != null) {
            Container pane = this.myDialog.getContentPane();
            return pane != null ? SwingUtilities.windowForComponent(pane) : null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeProgressDialog() {
        Object object = this.myMessageViewLock;
        synchronized (object) {
            if (this.myDialog != null) {
                this.myDialog.close(1);
                this.myDialog = null;
            }
        }
    }

    public boolean isHeadless() {
        return this.myHeadlessMode;
    }

    private boolean isHeadlessMode() {
        return this.myHeadlessMode;
    }

    private static VirtualFile getVirtualFile(CompilerMessage message) {
        Navigatable navigatable;
        VirtualFile virtualFile = message.getVirtualFile();
        if (virtualFile == null && (navigatable = message.getNavigatable()) instanceof OpenFileDescriptor) {
            virtualFile = ((OpenFileDescriptor)navigatable).getFile();
        }
        return virtualFile;
    }

    public static TextRange getTextRange(CompilerMessage message) {
        Navigatable navigatable = message.getNavigatable();
        if (navigatable instanceof OpenFileDescriptor) {
            int offset = ((OpenFileDescriptor)navigatable).getOffset();
            return new TextRange(offset, offset);
        }
        return new TextRange(0, 0);
    }

    private class CloseListener
    extends ContentManagerAdapter
    implements ProjectManagerListener {
        private Content myContent;
        private ContentManager myContentManager;
        private boolean myIsApplicationExitingOrProjectClosing = false;
        private boolean myUserAcceptedCancel = false;

        private CloseListener() {
        }

        public boolean canCloseProject(final Project project) {
            assert (project != null);
            if (this.shouldAskUser()) {
                int result = Messages.showOkCancelDialog((Project)CompilerTask.this.myProject, (String)CompilerBundle.message((String)"warning.compiler.running.on.project.close", (Object[])new Object[0]), (String)CompilerBundle.message((String)"compiler.running.dialog.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
                if (result != 0) {
                    return false;
                }
                this.myUserAcceptedCancel = true;
                final MessageBusConnection connection = project.getMessageBus().connect();
                connection.subscribe(CompilerTopics.COMPILATION_STATUS, (Object)new CompilationStatusListener(){

                    public void compilationFinished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                        connection.disconnect();
                        ProjectUtil.closeProject(project);
                    }
                });
                CompilerTask.this.cancel();
                return false;
            }
            return !CompilerTask.this.myIndicator.isRunning();
        }

        public void setContent(Content content, ContentManager contentManager) {
            this.myContent = content;
            this.myContentManager = contentManager;
            contentManager.addContentManagerListener((ContentManagerListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void contentRemoved(ContentManagerEvent event) {
            if (event.getContent() == this.myContent) {
                Object object = CompilerTask.this.myMessageViewLock;
                synchronized (object) {
                    if (CompilerTask.this.myErrorTreeView != null) {
                        CompilerTask.this.myErrorTreeView.dispose();
                        CompilerTask.this.myErrorTreeView = null;
                        if (CompilerTask.this.myIndicator.isRunning()) {
                            CompilerTask.this.cancel();
                        }
                    }
                }
                this.myContentManager.removeContentManagerListener((ContentManagerListener)this);
                this.myContent.release();
                this.myContent = null;
            }
        }

        public void contentRemoveQuery(ContentManagerEvent event) {
            if (event.getContent() == this.myContent && !CompilerTask.this.myIndicator.isCanceled() && this.shouldAskUser()) {
                int result = Messages.showOkCancelDialog((Project)CompilerTask.this.myProject, (String)CompilerBundle.message((String)"warning.compiler.running.on.toolwindow.close", (Object[])new Object[0]), (String)CompilerBundle.message((String)"compiler.running.dialog.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
                if (result != 0) {
                    event.consume();
                }
                this.myUserAcceptedCancel = true;
            }
        }

        private boolean shouldAskUser() {
            return !this.myUserAcceptedCancel && !this.myIsApplicationExitingOrProjectClosing && CompilerTask.this.myIndicator.isRunning();
        }

        public void projectOpened(Project project) {
        }

        public void projectClosed(Project project) {
            if (this.myContent != null) {
                this.myContentManager.removeContent(this.myContent, true);
            }
        }

        public void projectClosing(Project project) {
            this.myIsApplicationExitingOrProjectClosing = true;
        }
    }
}

