/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.rmiCompiler;

import com.intellij.compiler.OutputParser;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.compiler.impl.javaCompiler.CompilerParsingThread;
import com.intellij.compiler.impl.javaCompiler.javac.JavacOutputParser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.rt.compiler.JavacResourcesReader;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class JavacOutputParserPool {
    protected final Project myProject;
    private final CompileContext myContext;
    private final Map<Sdk, OutputParser> myProjectToParserMap = new HashMap<Sdk, OutputParser>();

    protected JavacOutputParserPool(Project project, CompileContext context) {
        this.myProject = project;
        this.myContext = context;
    }

    public OutputParser getJavacOutputParser(Sdk jdk) throws IOException {
        OutputParser outputParser = this.myProjectToParserMap.get(jdk);
        if (outputParser == null) {
            outputParser = this.createJavacOutputParser(jdk);
            this.myProjectToParserMap.put(jdk, outputParser);
        }
        return outputParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OutputParser createJavacOutputParser(final Sdk jdk) throws IOException {
        JavacOutputParser outputParser = new JavacOutputParser(this.myProject);
        String[] setupCmdLine = (String[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<String[]>(){

            public String[] compute() {
                return JavacOutputParserPool.createParserSetupCommand(jdk);
            }
        });
        Process setupProcess = Runtime.getRuntime().exec(setupCmdLine);
        CompilerParsingThread setupProcessParsingThread = new CompilerParsingThread(setupProcess, outputParser, true, true, this.myContext);
        Future parsingThreadFuture = ApplicationManager.getApplication().executeOnPooledThread((Runnable)setupProcessParsingThread);
        try {
            setupProcess.waitFor();
        }
        catch (InterruptedException ignored) {
        }
        finally {
            setupProcessParsingThread.setProcessTerminated(true);
        }
        try {
            parsingThreadFuture.get();
        }
        catch (InterruptedException e) {
        }
        catch (ExecutionException e) {
            // empty catch block
        }
        return outputParser;
    }

    private static String[] createParserSetupCommand(Sdk jdk) {
        VirtualFile homeDirectory = jdk.getHomeDirectory();
        if (homeDirectory == null) {
            throw new IllegalArgumentException(CompilerBundle.jdkHomeNotFoundMessage((Sdk)jdk));
        }
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(((JavaSdkType)jdk.getSdkType()).getVMExecutablePath(jdk));
        CompilerUtil.addLocaleOptions(commandLine, false);
        commandLine.add("-classpath");
        commandLine.add(((JavaSdkType)jdk.getSdkType()).getToolsPath(jdk) + File.pathSeparator + JavaSdkUtil.getIdeaRtJarPath());
        commandLine.add(JavacResourcesReader.class.getName());
        return ArrayUtil.toStringArray(commandLine);
    }
}

