/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.ModuleChunk;
import com.intellij.compiler.ant.artifacts.ArtifactsGenerator;
import com.intellij.compiler.ant.taskdefs.Target;
import com.intellij.openapi.compiler.CompilerBundle;
import java.io.IOException;
import java.io.PrintWriter;
import org.jetbrains.annotations.NotNull;

public class CleanProject
extends Generator {
    private final Target myTarget;

    public CleanProject(@NotNull GenerationOptions genOptions, @NotNull ArtifactsGenerator artifactsGenerator) {
        if (genOptions == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/ant/CleanProject.<init> must not be null");
        }
        if (artifactsGenerator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/compiler/ant/CleanProject.<init> must not be null");
        }
        StringBuffer dependencies = new StringBuffer();
        ModuleChunk[] chunks = genOptions.getModuleChunks();
        for (int idx = 0; idx < chunks.length; ++idx) {
            if (idx > 0) {
                dependencies.append(", ");
            }
            dependencies.append(BuildProperties.getModuleCleanTargetName((String)chunks[idx].getName()));
        }
        for (String target : artifactsGenerator.getCleanTargetNames()) {
            if (dependencies.length() > 0) {
                dependencies.append(", ");
            }
            dependencies.append(target);
        }
        this.myTarget = new Target("clean", dependencies.toString(), CompilerBundle.message((String)"generated.ant.build.clean.all.task.comment", (Object[])new Object[0]), null);
    }

    public void generate(PrintWriter out) throws IOException {
        this.myTarget.generate(out);
    }
}

