/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.InspectionProfileConvertor;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ModifiableModel;
import com.intellij.codeInspection.ex.InspectionTool;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.codeInspection.ex.VisibleTreeState;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ExternalInfo;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.profile.Profile;
import com.intellij.profile.ProfileEx;
import com.intellij.profile.ProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.SeverityProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionProfileImpl
extends ProfileEx
implements ModifiableModel,
InspectionProfile,
ExternalizableScheme {
    @NonNls
    private static InspectionProfileImpl DEFAULT_PROFILE;
    private static final Logger LOG;
    @NonNls
    private static final String VALID_VERSION = "1.0";
    private Map<String, ToolsImpl> myTools = new HashMap<String, ToolsImpl>();
    private Map<String, Boolean> myDisplayLevelMap;
    private Map<String, Element> myDeinstalledInspectionsSettings = new TreeMap<String, Element>();
    private boolean myLockedProfile = false;
    protected InspectionProfileImpl mySource;
    private InspectionProfileImpl myBaseProfile = null;
    @NonNls
    private static final String VERSION_TAG = "version";
    @NonNls
    private static final String INSPECTION_TOOL_TAG = "inspection_tool";
    @NonNls
    static final String ENABLED_TAG = "enabled";
    @NonNls
    static final String LEVEL_TAG = "level";
    @NonNls
    private static final String CLASS_TAG = "class";
    @NonNls
    private static final String PROFILE_NAME_TAG = "profile_name";
    @NonNls
    private static final String ROOT_ELEMENT_TAG = "inspections";
    @NonNls
    static final String SCOPE = "scope";
    private String myEnabledTool = null;
    @NonNls
    private static final String USED_LEVELS = "used_levels";
    final InspectionToolRegistrar myRegistrar;
    @NonNls
    private static final String IS_LOCKED = "is_locked";
    private final ExternalInfo myExternalInfo = new ExternalInfo();
    static final String NAME = "name";
    public static boolean INIT_INSPECTIONS;
    private boolean myModified = false;
    private final AtomicBoolean myInitialized = new AtomicBoolean(false);
    private VisibleTreeState myVisibleTreeState = new VisibleTreeState();

    public void setModified(boolean modified) {
        this.myModified = modified;
    }

    public InspectionProfileImpl(InspectionProfileImpl inspectionProfile) {
        super(inspectionProfile.getName());
        this.myRegistrar = inspectionProfile.myRegistrar;
        this.myTools = new HashMap<String, ToolsImpl>();
        this.myVisibleTreeState = new VisibleTreeState(inspectionProfile.myVisibleTreeState);
        this.myDeinstalledInspectionsSettings = new LinkedHashMap<String, Element>(inspectionProfile.myDeinstalledInspectionsSettings);
        this.myBaseProfile = inspectionProfile.myBaseProfile;
        this.myLocal = inspectionProfile.myLocal;
        this.myLockedProfile = inspectionProfile.myLockedProfile;
        this.mySource = inspectionProfile;
        this.setProfileManager(inspectionProfile.getProfileManager());
        this.copyFrom(inspectionProfile);
        this.initInspectionTools();
    }

    public InspectionProfileImpl(String inspectionProfile, InspectionToolRegistrar registrar, ProfileManager profileManager) {
        super(inspectionProfile);
        this.myRegistrar = registrar;
        this.myBaseProfile = InspectionProfileImpl.getDefaultProfile();
        this.setProfileManager(profileManager);
    }

    public InspectionProfileImpl(@NonNls String name) {
        super(name);
        this.myRegistrar = InspectionToolRegistrar.getInstance();
        this.setProfileManager((ProfileManager)InspectionProfileManager.getInstance());
    }

    public InspectionProfile getParentProfile() {
        return this.mySource;
    }

    public void setProfileManager(@NotNull ProfileManager profileManager) {
        if (profileManager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ex/InspectionProfileImpl.setProfileManager must not be null");
        }
        super.setProfileManager(profileManager);
    }

    public String getBaseProfileName() {
        if (this.myBaseProfile == null) {
            return null;
        }
        return this.myBaseProfile.getName();
    }

    public void setBaseProfile(InspectionProfile profile) {
        this.myBaseProfile = (InspectionProfileImpl)profile;
    }

    public boolean isChanged() {
        if (this.mySource != null && this.mySource.myLockedProfile != this.myLockedProfile) {
            return true;
        }
        return this.myModified;
    }

    public VisibleTreeState getExpandedNodes() {
        return this.myVisibleTreeState;
    }

    private static boolean toolSettingsAreEqual(String toolName, InspectionProfileImpl profile1, InspectionProfileImpl profile2) {
        ToolsImpl toolList1 = profile1.myTools.get(toolName);
        ToolsImpl toolList2 = profile2.myTools.get(toolName);
        if (toolList1 == null && toolList2 == null) {
            return true;
        }
        if (toolList1 != null && toolList2 != null) {
            return toolList1.equalTo(toolList2);
        }
        return false;
    }

    public boolean isProperSetting(HighlightDisplayKey key) {
        Map<String, Boolean> diffMap = this.getDisplayLevelMap();
        if (diffMap != null) {
            ToolsImpl tools = this.myBaseProfile.getTools(key.toString());
            ToolsImpl currentTools = this.myTools.get(key.toString());
            if (tools != null && currentTools != null) {
                diffMap.put(key.toString(), tools.equalTo(currentTools));
            } else {
                diffMap.put(key.toString(), tools == currentTools);
            }
            return diffMap.get(key.toString()) == false;
        }
        return false;
    }

    public void resetToBase() {
        this.copyToolsConfigurations(this.myBaseProfile);
        this.myDisplayLevelMap = null;
    }

    public void resetToEmpty() {
        InspectionProfileEntry[] profileEntries;
        for (InspectionProfileEntry entry : profileEntries = this.getInspectionTools(null)) {
            this.disableTool(entry.getShortName());
        }
    }

    public HighlightDisplayLevel getErrorLevel(@NotNull HighlightDisplayKey inspectionToolKey, PsiElement element) {
        HighlightDisplayLevel level;
        if (inspectionToolKey == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ex/InspectionProfileImpl.getErrorLevel must not be null");
        }
        ToolsImpl tools = this.getTools(inspectionToolKey.toString());
        HighlightDisplayLevel highlightDisplayLevel = level = tools != null ? tools.getLevel(element) : HighlightDisplayLevel.WARNING;
        if (!((SeverityProvider)this.getProfileManager()).getOwnSeverityRegistrar().isSeverityValid(level.getSeverity().toString())) {
            level = HighlightDisplayLevel.WARNING;
            this.setErrorLevel(inspectionToolKey, level);
        }
        return level;
    }

    public void readExternal(Element element) throws InvalidDataException {
        Element highlightElement;
        super.readExternal(element);
        String locked = element.getAttributeValue(IS_LOCKED);
        if (locked != null) {
            this.myLockedProfile = Boolean.parseBoolean(locked);
        }
        this.myBaseProfile = InspectionProfileImpl.getDefaultProfile();
        String version = element.getAttributeValue(VERSION_TAG);
        if (version == null || !version.equals(VALID_VERSION)) {
            try {
                element = InspectionProfileConvertor.convertToNewFormat(element, this);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
            catch (JDOMException e) {
                LOG.error((Throwable)e);
            }
        }
        if ((highlightElement = element.getChild(USED_LEVELS)) != null) {
            ((SeverityProvider)this.getProfileManager()).getOwnSeverityRegistrar().readExternal(highlightElement);
        }
        for (Object o : element.getChildren(INSPECTION_TOOL_TAG)) {
            Element toolElement = (Element)o;
            String toolClassName = toolElement.getAttributeValue(CLASS_TAG);
            this.myDeinstalledInspectionsSettings.put(toolClassName, toolElement);
        }
    }

    public Set<HighlightSeverity> getUsedSeverities() {
        LOG.assertTrue(this.myInitialized.get());
        HashSet<HighlightSeverity> result = new HashSet<HighlightSeverity>();
        for (ToolsImpl tools : this.myTools.values()) {
            for (ScopeToolState state : tools.getTools()) {
                result.add(state.getLevel().getSeverity());
            }
        }
        return result;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        element.setAttribute(VERSION_TAG, VALID_VERSION);
        element.setAttribute(IS_LOCKED, String.valueOf(this.myLockedProfile));
        if (!this.myInitialized.get()) {
            for (Element el : this.myDeinstalledInspectionsSettings.values()) {
                element.addContent((Element)el.clone());
            }
            return;
        }
        Map<String, Boolean> diffMap = this.getDisplayLevelMap();
        if (diffMap != null) {
            diffMap = new TreeMap<String, Boolean>(diffMap);
            for (String toolName : this.myDeinstalledInspectionsSettings.keySet()) {
                diffMap.put(toolName, false);
            }
            for (String toolName : diffMap.keySet()) {
                if (!this.myLockedProfile && diffMap.get(toolName).booleanValue()) continue;
                Element toolElement = this.myDeinstalledInspectionsSettings.get(toolName);
                if (toolElement == null) {
                    ToolsImpl toolList = this.myTools.get(toolName);
                    LOG.assertTrue(toolList != null);
                    Element inspectionElement = new Element(INSPECTION_TOOL_TAG);
                    inspectionElement.setAttribute(CLASS_TAG, toolName);
                    toolList.writeExternal(inspectionElement);
                    element.addContent(inspectionElement);
                    continue;
                }
                element.addContent((Element)toolElement.clone());
            }
        }
    }

    public InspectionProfileEntry getInspectionTool(@NotNull String shortName, @NotNull PsiElement element) {
        if (shortName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ex/InspectionProfileImpl.getInspectionTool must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/ex/InspectionProfileImpl.getInspectionTool must not be null");
        }
        ToolsImpl toolList = this.getTools(shortName);
        return toolList != null ? toolList.getInspectionTool(element) : null;
    }

    public InspectionProfileEntry getInspectionTool(@NotNull String shortName) {
        if (shortName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ex/InspectionProfileImpl.getInspectionTool must not be null");
        }
        return this.getTools(shortName).getTool();
    }

    public InspectionProfileEntry getToolById(String id, PsiElement element) {
        this.initInspectionTools();
        for (ToolsImpl toolList : this.myTools.values()) {
            InspectionProfileEntry tool = toolList.getInspectionTool(element);
            String toolId = tool instanceof LocalInspectionToolWrapper ? ((LocalInspectionToolWrapper)tool).getTool().getID() : tool.getShortName();
            if (!id.equals(toolId)) continue;
            return tool;
        }
        return null;
    }

    public void save() throws IOException {
        InspectionProfileManager.getInstance().fireProfileChanged((Profile)this);
    }

    public boolean isEditable() {
        return this.myEnabledTool == null;
    }

    @NotNull
    public String getDisplayName() {
        String string = this.isEditable() ? this.getName() : this.myEnabledTool;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/InspectionProfileImpl.getDisplayName must not return null");
        }
        return string;
    }

    public void setEditable(String displayName) {
        this.myEnabledTool = displayName;
    }

    public void load(Element element) {
        try {
            this.readExternal(element);
        }
        catch (Exception e) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    Messages.showErrorDialog((String)InspectionsBundle.message((String)"inspection.error.loading.message", (Object[])new Object[]{0, InspectionProfileImpl.this.getName()}), (String)InspectionsBundle.message((String)"inspection.errors.occured.dialog.title", (Object[])new Object[0]));
                }
            }, ModalityState.NON_MODAL);
        }
    }

    public boolean isDefault() {
        Map<String, Boolean> map = this.getDisplayLevelMap();
        if (map != null) {
            for (Boolean def : map.values()) {
                if (def.booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isProfileLocked() {
        return this.myLockedProfile;
    }

    public void lockProfile(boolean isLocked) {
        for (ToolsImpl toolList : this.myTools.values()) {
            String key = toolList.getShortName();
            if (!isLocked) continue;
            this.myDisplayLevelMap.put(key, Boolean.FALSE);
        }
        this.myLockedProfile = isLocked;
    }

    @NotNull
    public InspectionProfileEntry[] getInspectionTools(PsiElement element) {
        this.initInspectionTools();
        ArrayList<InspectionProfileEntry> result = new ArrayList<InspectionProfileEntry>();
        for (ToolsImpl toolList : this.myTools.values()) {
            result.add(toolList.getInspectionTool(element));
        }
        InspectionProfileEntry[] inspectionProfileEntryArray = result.toArray(new InspectionTool[result.size()]);
        if (inspectionProfileEntryArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/InspectionProfileImpl.getInspectionTools must not return null");
        }
        return inspectionProfileEntryArray;
    }

    public List<ToolsImpl> getAllEnabledInspectionTools() {
        this.initInspectionTools();
        ArrayList<ToolsImpl> result = new ArrayList<ToolsImpl>();
        for (ToolsImpl toolList : this.myTools.values()) {
            if (!toolList.isEnabled()) continue;
            result.add(toolList);
        }
        return result;
    }

    public void disableTool(String toolId, PsiElement element) {
        this.getTools(toolId).disableTool(element);
    }

    public void disableToolByDefault(String toolId) {
        this.getTools(toolId).getDefaultState().setEnabled(false);
    }

    public void enableToolByDefault(String toolId) {
        this.getTools(toolId).getDefaultState().setEnabled(true);
    }

    public boolean wasInitialized() {
        return this.myInitialized.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initInspectionTools() {
        if (ApplicationManager.getApplication().isUnitTestMode() && !INIT_INSPECTIONS) {
            return;
        }
        AtomicBoolean atomicBoolean = this.myInitialized;
        synchronized (atomicBoolean) {
            if (!this.myInitialized.getAndSet(true)) {
                InspectionTool[] tools;
                if (this.myBaseProfile != null) {
                    this.myBaseProfile.initInspectionTools();
                }
                try {
                    tools = this.myRegistrar.createTools();
                }
                catch (ProcessCanceledException e) {
                    this.myInitialized.set(false);
                    return;
                }
                for (InspectionTool tool : tools) {
                    String shortName = tool.getShortName();
                    HighlightDisplayKey key = HighlightDisplayKey.find((String)shortName);
                    if (key == null) {
                        key = tool instanceof LocalInspectionToolWrapper ? HighlightDisplayKey.register((String)shortName, (String)tool.getDisplayName(), (String)((LocalInspectionToolWrapper)tool).getTool().getID(), (String)((LocalInspectionToolWrapper)tool).getTool().getAlternativeID()) : HighlightDisplayKey.register((String)shortName);
                    }
                    LOG.assertTrue(key != null, (Object)(shortName + " ; number of initialized tools: " + this.myTools.size()));
                    ToolsImpl toolsList = new ToolsImpl(tool, this.myBaseProfile != null ? this.myBaseProfile.getErrorLevel(key) : tool.getDefaultLevel(), !this.myLockedProfile && (this.myBaseProfile != null ? this.myBaseProfile.isToolEnabled(key) : tool.isEnabledByDefault()));
                    Element element = this.myDeinstalledInspectionsSettings.remove(tool.getShortName());
                    if (element != null) {
                        try {
                            toolsList.readExternal(element, this);
                        }
                        catch (InvalidDataException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                    this.myTools.put(tool.getShortName(), toolsList);
                }
                if (this.mySource != null) {
                    this.copyToolsConfigurations(this.mySource);
                }
            }
        }
    }

    private HighlightDisplayLevel getErrorLevel(@NotNull HighlightDisplayKey key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ex/InspectionProfileImpl.getErrorLevel must not be null");
        }
        ToolsImpl tools = this.getTools(key.toString());
        LOG.assertTrue(tools != null, (Object)("profile name: " + this.myName + " base profile: " + (this.myBaseProfile != null ? this.myBaseProfile.getName() : "-") + " key: " + key));
        return tools != null ? tools.getLevel() : HighlightDisplayLevel.WARNING;
    }

    @NotNull
    public ModifiableModel getModifiableModel() {
        InspectionProfileImpl modifiableModel = new InspectionProfileImpl(this);
        modifiableModel.myExternalInfo.copy(this.myExternalInfo);
        InspectionProfileImpl inspectionProfileImpl = modifiableModel;
        if (inspectionProfileImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/InspectionProfileImpl.getModifiableModel must not return null");
        }
        return inspectionProfileImpl;
    }

    public void copyFrom(InspectionProfile profile) {
        super.copyFrom((Profile)profile);
        InspectionProfileImpl inspectionProfile = (InspectionProfileImpl)profile;
        this.myBaseProfile = inspectionProfile.myBaseProfile;
    }

    public void copyToolsConfigurations(InspectionProfileImpl profile) {
        try {
            this.initInspectionTools();
            for (ToolsImpl toolList : profile.myTools.values()) {
                ToolsImpl tools = this.myTools.get(toolList.getShortName());
                ScopeToolState defaultState = toolList.getDefaultState();
                tools.setDefaultState(this.copyToolSettings((InspectionTool)defaultState.getTool()), defaultState.isEnabled(), defaultState.getLevel());
                tools.removeAllScopes();
                tools.setEnabled(toolList.isEnabled());
                List<ScopeToolState> nonDefaultToolStates = toolList.getNonDefaultTools();
                if (nonDefaultToolStates == null) continue;
                for (ScopeToolState state : nonDefaultToolStates) {
                    InspectionTool inspectionTool = this.copyToolSettings((InspectionTool)state.getTool());
                    if (state.getScope() != null) {
                        tools.addTool(state.getScope(), (InspectionProfileEntry)inspectionTool, state.isEnabled(), state.getLevel());
                        continue;
                    }
                    tools.addTool(state.getScopeName(), (InspectionProfileEntry)inspectionTool, state.isEnabled(), state.getLevel());
                }
            }
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    private InspectionTool copyToolSettings(InspectionTool tool) throws WriteExternalException, InvalidDataException {
        String tempRoot = "config";
        Element config = new Element(tempRoot);
        tool.writeSettings(config);
        InspectionTool inspectionTool = this.myRegistrar.createInspectionTool(tool.getShortName(), tool);
        inspectionTool.readSettings(config);
        return inspectionTool;
    }

    public void cleanup(Project project) {
        for (ToolsImpl toolList : this.myTools.values()) {
            if (!toolList.isEnabled()) continue;
            for (InspectionProfileEntry tool : toolList.getAllTools()) {
                tool.projectClosed(project);
                if (((InspectionTool)tool).getContext() == null) continue;
                ((InspectionTool)tool).cleanup();
            }
        }
    }

    public void enableTool(String inspectionTool) {
        ToolsImpl tools = this.getTools(inspectionTool);
        tools.setEnabled(true);
        if (tools.getNonDefaultTools() == null) {
            tools.getDefaultState().setEnabled(true);
        }
    }

    public void enableTool(String inspectionTool, NamedScope namedScope) {
        this.getTools(inspectionTool).enableTool(namedScope);
    }

    public void disableTool(String inspectionTool, NamedScope namedScope) {
        this.getTools(inspectionTool).disableTool(namedScope);
    }

    public void disableTool(String inspectionTool) {
        ToolsImpl tools = this.getTools(inspectionTool);
        tools.setEnabled(false);
        if (tools.getNonDefaultTools() == null) {
            tools.getDefaultState().setEnabled(false);
        }
    }

    public void setErrorLevel(HighlightDisplayKey key, HighlightDisplayLevel level) {
        this.getTools(key.toString()).setLevel(level);
    }

    public boolean isToolEnabled(HighlightDisplayKey key, PsiElement element) {
        if (key == null) {
            return false;
        }
        ToolsImpl toolState = this.getTools(key.toString());
        return toolState != null && toolState.isEnabled(element);
    }

    public boolean isToolEnabled(HighlightDisplayKey key) {
        ToolsImpl toolState = this.getTools(key.toString());
        return toolState != null && toolState.isEnabled();
    }

    public boolean isExecutable() {
        this.initInspectionTools();
        for (ToolsImpl tools : this.myTools.values()) {
            if (!tools.isEnabled()) continue;
            return true;
        }
        return false;
    }

    public void commit() throws IOException {
        LOG.assertTrue(this.mySource != null);
        this.mySource.commit(this);
        this.getProfileManager().updateProfile((Profile)this.mySource);
        this.mySource = null;
    }

    private void commit(InspectionProfileImpl inspectionProfile) {
        this.myName = inspectionProfile.myName;
        this.myLocal = inspectionProfile.myLocal;
        this.myLockedProfile = inspectionProfile.myLockedProfile;
        this.myDisplayLevelMap = inspectionProfile.myDisplayLevelMap;
        this.myVisibleTreeState = inspectionProfile.myVisibleTreeState;
        this.myBaseProfile = inspectionProfile.myBaseProfile;
        this.myTools = inspectionProfile.myTools;
        this.myProfileMananger = inspectionProfile.myProfileMananger;
        this.myExternalInfo.copy(inspectionProfile.getExternalInfo());
        InspectionProfileManager.getInstance().fireProfileChanged((Profile)inspectionProfile);
    }

    public static synchronized InspectionProfileImpl getDefaultProfile() {
        if (DEFAULT_PROFILE == null) {
            DEFAULT_PROFILE = new InspectionProfileImpl("Default");
        }
        return DEFAULT_PROFILE;
    }

    public Document saveToDocument() throws WriteExternalException {
        if (this.isLocal()) {
            Element root = new Element(ROOT_ELEMENT_TAG);
            root.setAttribute(PROFILE_NAME_TAG, this.myName);
            this.writeExternal(root);
            return new Document(root);
        }
        return null;
    }

    public VisibleTreeState getVisibleTreeState() {
        return this.myVisibleTreeState;
    }

    public void setVisibleTreeState(VisibleTreeState state) {
        this.myVisibleTreeState = state;
    }

    public void convert(Element element) {
        List children;
        this.initInspectionTools();
        Element scopes = element.getChild("scopes");
        if (scopes != null && (children = scopes.getChildren(SCOPE)) != null) {
            for (Object s : children) {
                NamedScope scope;
                InspectionProfileImpl inspectionProfile;
                Element scopeElement = (Element)s;
                String profile = scopeElement.getAttributeValue("profile");
                if (profile == null || (inspectionProfile = (InspectionProfileImpl)this.getProfileManager().getProfile(profile)) == null || (scope = this.getProfileManager().getScopesManager().getScope(scopeElement.getAttributeValue(NAME))) == null) continue;
                for (InspectionProfileEntry entry : inspectionProfile.getInspectionTools(null)) {
                    HighlightDisplayKey key = HighlightDisplayKey.find((String)entry.getShortName());
                    try {
                        this.getTools(entry.getShortName()).addTool(scope, (InspectionProfileEntry)this.copyToolSettings((InspectionTool)entry), inspectionProfile.isToolEnabled(key), inspectionProfile.getErrorLevel(key, (NamedScope)null));
                    }
                    catch (Exception e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
            this.reduceConvertedScopes();
        }
    }

    private void reduceConvertedScopes() {
        for (ToolsImpl tools : this.myTools.values()) {
            ScopeToolState toolState = tools.getDefaultState();
            List<ScopeToolState> nonDefaultTools = tools.getNonDefaultTools();
            if (nonDefaultTools == null) continue;
            boolean equal = true;
            boolean isEnabled = toolState.isEnabled();
            for (ScopeToolState state : nonDefaultTools) {
                isEnabled |= state.isEnabled();
                if (state.equalTo(toolState)) continue;
                equal = false;
            }
            tools.setEnabled(isEnabled);
            if (!equal) continue;
            tools.removeAllScopes();
        }
    }

    @NotNull
    public ExternalInfo getExternalInfo() {
        ExternalInfo externalInfo = this.myExternalInfo;
        if (externalInfo == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/InspectionProfileImpl.getExternalInfo must not return null");
        }
        return externalInfo;
    }

    public List<ScopeToolState> getAllTools() {
        this.initInspectionTools();
        ArrayList<ScopeToolState> result = new ArrayList<ScopeToolState>();
        for (ToolsImpl tools : this.myTools.values()) {
            result.addAll(tools.getTools());
        }
        return result;
    }

    public List<ScopeToolState> getDefaultStates() {
        this.initInspectionTools();
        ArrayList<ScopeToolState> result = new ArrayList<ScopeToolState>();
        for (ToolsImpl tools : this.myTools.values()) {
            result.add(tools.getDefaultState());
        }
        return result;
    }

    public List<ScopeToolState> getNonDefaultTools(String shortName) {
        ArrayList<ScopeToolState> result = new ArrayList<ScopeToolState>();
        List<ScopeToolState> nonDefaultTools = this.getTools(shortName).getNonDefaultTools();
        if (nonDefaultTools != null) {
            result.addAll(nonDefaultTools);
        }
        return result;
    }

    public boolean isToolEnabled(HighlightDisplayKey key, NamedScope namedScope) {
        return this.getTools(key.toString()).isEnabled(namedScope);
    }

    public void removeScope(String toolId, int scopeIdx) {
        this.getTools(toolId).removeScope(scopeIdx);
    }

    public void removeAllScopes(String toolId) {
        this.getTools(toolId).removeAllScopes();
    }

    public void setScope(String toolId, int idx, NamedScope namedScope) {
        this.getTools(toolId).setScope(idx, namedScope);
    }

    public void moveScope(String toolId, int idx, int dir) {
        this.getTools(toolId).moveScope(idx, dir);
    }

    @Nullable
    private Map<String, Boolean> getDisplayLevelMap() {
        if (this.myBaseProfile == null) {
            return null;
        }
        if (this.myDisplayLevelMap == null) {
            this.initInspectionTools();
            this.myDisplayLevelMap = new TreeMap<String, Boolean>();
            for (String toolId : this.myTools.keySet()) {
                this.myDisplayLevelMap.put(toolId, InspectionProfileImpl.toolSettingsAreEqual(toolId, this.myBaseProfile, this));
            }
        }
        return this.myDisplayLevelMap;
    }

    public HighlightDisplayLevel getErrorLevel(HighlightDisplayKey key, NamedScope scope) {
        ToolsImpl tools = this.getTools(key.toString());
        return tools != null ? tools.getLevel(scope) : HighlightDisplayLevel.WARNING;
    }

    public ScopeToolState addScope(InspectionProfileEntry tool, NamedScope scope, HighlightDisplayLevel level, boolean enabled) {
        return this.getTools(tool.getShortName()).prependTool(scope, tool, enabled, level);
    }

    public void setErrorLevel(HighlightDisplayKey key, HighlightDisplayLevel level, int scopeIdx) {
        this.getTools(key.toString()).setLevel(level, scopeIdx);
    }

    private ToolsImpl getTools(String toolId) {
        this.initInspectionTools();
        return this.myTools.get(toolId);
    }

    static {
        LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ex.InspectionProfileImpl");
        INIT_INSPECTIONS = false;
    }
}

