/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.CustomSuppressableInspectionTool;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.HTMLComposer;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.ex.DescriptorComposer;
import com.intellij.codeInspection.ex.DescriptorProviderInspection;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.HTMLComposerImpl;
import com.intellij.codeInspection.ex.JobDescriptor;
import com.intellij.codeInspection.ex.ProblemDescriptorImpl;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobalInspectionToolWrapper
extends DescriptorProviderInspection {
    @NotNull
    private final GlobalInspectionTool myTool;

    public GlobalInspectionToolWrapper(@NotNull GlobalInspectionTool globalInspectionTool) {
        if (globalInspectionTool == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ex/GlobalInspectionToolWrapper.<init> must not be null");
        }
        this.myTool = globalInspectionTool;
    }

    @Override
    public void initialize(@NotNull GlobalInspectionContextImpl context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ex/GlobalInspectionToolWrapper.initialize must not be null");
        }
        super.initialize(context);
        RefGraphAnnotator annotator = this.myTool.getAnnotator(this.getRefManager());
        if (annotator != null) {
            ((RefManagerImpl)this.getRefManager()).registerGraphAnnotator(annotator);
        }
    }

    @Override
    public void runInspection(AnalysisScope scope, InspectionManager manager) {
        this.myTool.runInspection(scope, manager, (GlobalInspectionContext)this.getContext(), (ProblemDescriptionsProcessor)this);
    }

    @Override
    public boolean queryExternalUsagesRequests(InspectionManager manager) {
        return this.myTool.queryExternalUsagesRequests(manager, (GlobalInspectionContext)this.getContext(), (ProblemDescriptionsProcessor)this);
    }

    @Override
    @NotNull
    public JobDescriptor[] getJobDescriptors() {
        JobDescriptor[] jobDescriptorArray;
        if (this.isGraphNeeded()) {
            JobDescriptor[] jobDescriptorArray2 = new JobDescriptor[1];
            jobDescriptorArray = jobDescriptorArray2;
            jobDescriptorArray2[0] = GlobalInspectionContextImpl.BUILD_GRAPH;
        } else {
            jobDescriptorArray = JobDescriptor.EMPTY_ARRAY;
        }
        if (jobDescriptorArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/GlobalInspectionToolWrapper.getJobDescriptors must not return null");
        }
        return jobDescriptorArray;
    }

    @NotNull
    public String getDisplayName() {
        String string = this.myTool.getDisplayName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/GlobalInspectionToolWrapper.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = this.myTool.getGroupDisplayName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/GlobalInspectionToolWrapper.getGroupDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String[] getGroupPath() {
        String[] stringArray = this.myTool.getGroupPath();
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/GlobalInspectionToolWrapper.getGroupPath must not return null");
        }
        return stringArray;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        String string = this.myTool.getShortName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/GlobalInspectionToolWrapper.getShortName must not return null");
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return this.myTool.isEnabledByDefault();
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = this.myTool.getDefaultLevel();
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/GlobalInspectionToolWrapper.getDefaultLevel must not return null");
        }
        return highlightDisplayLevel;
    }

    public void readSettings(Element element) throws InvalidDataException {
        this.myTool.readSettings(element);
    }

    public void writeSettings(Element element) throws WriteExternalException {
        this.myTool.writeSettings(element);
    }

    public JComponent createOptionsPanel() {
        return this.myTool.createOptionsPanel();
    }

    @Override
    public boolean isGraphNeeded() {
        return this.myTool.isGraphNeeded();
    }

    @NotNull
    public GlobalInspectionTool getTool() {
        GlobalInspectionTool globalInspectionTool = this.myTool;
        if (globalInspectionTool == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/GlobalInspectionToolWrapper.getTool must not return null");
        }
        return globalInspectionTool;
    }

    public void processFile(final AnalysisScope analysisScope, final InspectionManager manager, final GlobalInspectionContext context, final boolean filterSuppressed) {
        context.getRefManager().iterate(new RefVisitor(){

            public void visitElement(RefEntity refEntity) {
                CommonProblemDescriptor[] descriptors = GlobalInspectionToolWrapper.this.myTool.checkElement(refEntity, analysisScope, manager, context, (ProblemDescriptionsProcessor)GlobalInspectionToolWrapper.this);
                if (descriptors != null) {
                    GlobalInspectionToolWrapper.this.addProblemElement(refEntity, filterSuppressed, descriptors);
                }
            }
        });
    }

    public void projectOpened(Project project) {
        this.myTool.projectOpened(project);
    }

    public void projectClosed(Project project) {
        this.myTool.projectClosed(project);
    }

    @Override
    public HTMLComposerImpl getComposer() {
        return new DescriptorComposer(this){

            @Override
            protected void composeAdditionalDescription(StringBuffer buf, RefEntity refEntity) {
                GlobalInspectionToolWrapper.this.myTool.compose(buf, refEntity, (HTMLComposer)this);
            }
        };
    }

    @Override
    @Nullable
    public IntentionAction findQuickFixes(final CommonProblemDescriptor problemDescriptor, String hint) {
        final QuickFix fix = this.myTool.getQuickFix(hint);
        if (fix != null) {
            if (problemDescriptor instanceof ProblemDescriptor) {
                ProblemDescriptorImpl descriptor = new ProblemDescriptorImpl(((ProblemDescriptor)problemDescriptor).getStartElement(), ((ProblemDescriptor)problemDescriptor).getEndElement(), problemDescriptor.getDescriptionTemplate(), new LocalQuickFix[]{(LocalQuickFix)fix}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, null, false);
                return QuickFixWrapper.wrap(descriptor, 0);
            }
            return new IntentionAction(){

                @NotNull
                public String getText() {
                    String string = fix.getName();
                    if (string == null) {
                        throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/GlobalInspectionToolWrapper$3.getText must not return null");
                    }
                    return string;
                }

                @NotNull
                public String getFamilyName() {
                    String string = fix.getFamilyName();
                    if (string == null) {
                        throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/GlobalInspectionToolWrapper$3.getFamilyName must not return null");
                    }
                    return string;
                }

                public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                    if (project == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ex/GlobalInspectionToolWrapper$3.isAvailable must not be null");
                    }
                    return true;
                }

                public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
                    if (project == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ex/GlobalInspectionToolWrapper$3.invoke must not be null");
                    }
                    fix.applyFix(project, problemDescriptor);
                }

                public boolean startInWriteAction() {
                    return true;
                }
            };
        }
        return null;
    }

    protected Class<? extends InspectionProfileEntry> getDescriptionContextClass() {
        return this.myTool.getClass();
    }

    @Nullable
    public String getStaticDescription() {
        return this.myTool.getStaticDescription();
    }

    @Override
    @Nullable
    public SuppressIntentionAction[] getSuppressActions() {
        if (this.myTool instanceof CustomSuppressableInspectionTool) {
            return ((CustomSuppressableInspectionTool)this.myTool).getSuppressActions(null);
        }
        return super.getSuppressActions();
    }
}

