/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.defaultFileTemplateUsage;

import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.defaultFileTemplateUsage.CatchBodyVisitor;
import com.intellij.codeInspection.defaultFileTemplateUsage.FileHeaderChecker;
import com.intellij.codeInspection.defaultFileTemplateUsage.InspectionOptions;
import com.intellij.codeInspection.defaultFileTemplateUsage.MethodBodyChecker;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.impl.FileTemplateConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiWhiteSpace;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultFileTemplateUsageInspection
extends BaseJavaLocalInspectionTool {
    public boolean CHECK_FILE_HEADER = true;
    public boolean CHECK_TRY_CATCH_SECTION = true;
    public boolean CHECK_METHOD_BODY = true;

    @NotNull
    public String getGroupDisplayName() {
        String string = GENERAL_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/defaultFileTemplateUsage/DefaultFileTemplateUsageInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"default.file.template.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/defaultFileTemplateUsage/DefaultFileTemplateUsageInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("DefaultFileTemplate" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/defaultFileTemplateUsage/DefaultFileTemplateUsageInspection.getShortName must not return null");
        }
        return "DefaultFileTemplate";
    }

    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/defaultFileTemplateUsage/DefaultFileTemplateUsageInspection.checkMethod must not be null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/defaultFileTemplateUsage/DefaultFileTemplateUsageInspection.checkMethod must not be null");
        }
        ArrayList<ProblemDescriptor> descriptors = new ArrayList<ProblemDescriptor>();
        if (this.CHECK_METHOD_BODY) {
            MethodBodyChecker.checkMethodBody(method, manager, descriptors, isOnTheFly);
        }
        if (this.CHECK_TRY_CATCH_SECTION) {
            CatchBodyVisitor visitor = new CatchBodyVisitor(manager, descriptors, isOnTheFly);
            PsiCodeBlock body = method.getBody();
            if (body != null) {
                body.accept((PsiElementVisitor)visitor);
            }
        }
        return descriptors.toArray(new ProblemDescriptor[descriptors.size()]);
    }

    static Pair<? extends PsiElement, ? extends PsiElement> getInteriorRange(PsiCodeBlock codeBlock) {
        PsiElement child;
        int end;
        PsiElement child2;
        int start;
        PsiElement[] children = codeBlock.getChildren();
        if (children.length == 0) {
            return Pair.create((Object)codeBlock, (Object)codeBlock);
        }
        for (start = 0; start < children.length && ((child2 = children[start]) instanceof PsiWhiteSpace || child2 instanceof PsiJavaToken && ((PsiJavaToken)child2).getTokenType() == JavaTokenType.LBRACE); ++start) {
        }
        for (end = children.length - 1; start < end && ((child = children[end]) instanceof PsiWhiteSpace || child instanceof PsiJavaToken && ((PsiJavaToken)child).getTokenType() == JavaTokenType.RBRACE); --end) {
        }
        return Pair.create((Object)children[start], (Object)children[end]);
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiClassInitializer[] initializers;
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/defaultFileTemplateUsage/DefaultFileTemplateUsageInspection.checkClass must not be null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/defaultFileTemplateUsage/DefaultFileTemplateUsageInspection.checkClass must not be null");
        }
        if (!this.CHECK_TRY_CATCH_SECTION) {
            return null;
        }
        CatchBodyVisitor visitor = new CatchBodyVisitor(manager, new ArrayList<ProblemDescriptor>(), isOnTheFly);
        for (PsiClassInitializer initializer : initializers = aClass.getInitializers()) {
            initializer.accept((PsiElementVisitor)visitor);
        }
        return visitor.myProblemDescriptors.toArray(new ProblemDescriptor[visitor.myProblemDescriptors.size()]);
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        ProblemDescriptor[] problemDescriptorArray;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/defaultFileTemplateUsage/DefaultFileTemplateUsageInspection.checkFile must not be null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/defaultFileTemplateUsage/DefaultFileTemplateUsageInspection.checkFile must not be null");
        }
        if (!this.CHECK_FILE_HEADER) {
            return null;
        }
        ProblemDescriptor descriptor = FileHeaderChecker.checkFileHeader(file, manager, isOnTheFly);
        if (descriptor == null) {
            problemDescriptorArray = null;
        } else {
            ProblemDescriptor[] problemDescriptorArray2 = new ProblemDescriptor[1];
            problemDescriptorArray = problemDescriptorArray2;
            problemDescriptorArray2[0] = descriptor;
        }
        return problemDescriptorArray;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new InspectionOptions(this).getComponent();
    }

    public static LocalQuickFix createEditFileTemplateFix(final FileTemplate templateToEdit, final LocalQuickFix replaceTemplateFix) {
        return new LocalQuickFix(){

            @NotNull
            public String getName() {
                String string = InspectionsBundle.message((String)"default.file.template.edit.template", (Object[])new Object[0]);
                if (string == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/codeInspection/defaultFileTemplateUsage/DefaultFileTemplateUsageInspection$1.getName must not return null");
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                String string = this.getName();
                if (string == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/codeInspection/defaultFileTemplateUsage/DefaultFileTemplateUsageInspection$1.getFamilyName must not return null");
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                if (project == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/defaultFileTemplateUsage/DefaultFileTemplateUsageInspection$1.applyFix must not be null");
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/defaultFileTemplateUsage/DefaultFileTemplateUsageInspection$1.applyFix must not be null");
                }
                final FileTemplateConfigurable configurable = new FileTemplateConfigurable();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        configurable.setTemplate(templateToEdit, null);
                    }
                });
                boolean ok = ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable);
                if (ok) {
                    replaceTemplateFix.applyFix(project, (CommonProblemDescriptor)descriptor);
                    FileTemplateManager.getInstance().saveAll();
                }
            }
        };
    }
}

