/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.defaultFileTemplateUsage;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.defaultFileTemplateUsage.DefaultFileTemplateUsageInspection;
import com.intellij.codeInspection.defaultFileTemplateUsage.ReplaceWithFileTemplateFix;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

class CatchBodyVisitor
extends JavaRecursiveElementWalkingVisitor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.defaultFileTemplateUsage.CatchBodyVisitor");
    Collection<ProblemDescriptor> myProblemDescriptors;
    private boolean myOnTheFly;
    private final InspectionManager myManager;

    public CatchBodyVisitor(InspectionManager manager, Collection<ProblemDescriptor> descriptors, boolean onTheFly) {
        this.myManager = manager;
        this.myProblemDescriptors = descriptors;
        this.myOnTheFly = onTheFly;
    }

    public void visitCatchSection(PsiCatchSection section) {
        this.checkSection(section);
        super.visitCatchSection(section);
    }

    public void visitClass(PsiClass aClass) {
    }

    private void checkSection(PsiCatchSection section) {
        PsiParameter templateParameter;
        PsiCodeBlock templateCatchBlock;
        final PsiParameter parameter = section.getParameter();
        if (parameter == null) {
            return;
        }
        PsiCodeBlock catchBlock = section.getCatchBlock();
        if (catchBlock == null) {
            return;
        }
        PsiType type = parameter.getType();
        if (!(type instanceof PsiClassType)) {
            return;
        }
        try {
            PsiJavaParserFacade elementFactory = JavaPsiFacade.getInstance((Project)section.getProject()).getParserFacade();
            PsiCatchSection sectionTemplate = elementFactory.createCatchSection((PsiClassType)type, parameter.getName(), (PsiElement)parameter);
            templateCatchBlock = sectionTemplate.getCatchBlock();
            FileTemplate catchBodyTemplate = FileTemplateManager.getInstance().getDefaultTemplate("Catch Statement Body.java");
            Properties props = new Properties();
            props.setProperty("EXCEPTION", parameter.getName());
            String catchBody = catchBodyTemplate.getText(props);
            PsiCodeBlock codeBlockFromText = elementFactory.createCodeBlockFromText("{\n" + catchBody + "\n}", null);
            templateCatchBlock = (PsiCodeBlock)templateCatchBlock.replace((PsiElement)codeBlockFromText);
            templateParameter = sectionTemplate.getParameter();
        }
        catch (ProcessCanceledException e) {
            return;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return;
        }
        if (!PsiEquivalenceUtil.areElementsEquivalent((PsiElement)catchBlock, (PsiElement)templateCatchBlock, (Comparator)new Comparator<PsiElement>(){

            @Override
            public int compare(PsiElement o1, PsiElement o2) {
                if (o1 == parameter && o2 == templateParameter) {
                    return 0;
                }
                return -1;
            }
        }, (boolean)true)) {
            return;
        }
        Pair<? extends PsiElement, ? extends PsiElement> range = DefaultFileTemplateUsageInspection.getInteriorRange(catchBlock);
        String description = InspectionsBundle.message((String)"default.file.template.description", (Object[])new Object[0]);
        ProblemDescriptor descriptor = this.myManager.createProblemDescriptor((PsiElement)range.first, (PsiElement)range.second, description, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly, CatchBodyVisitor.createQuickFix(section));
        this.myProblemDescriptors.add(descriptor);
    }

    private static LocalQuickFix[] createQuickFix(final PsiCatchSection section) {
        FileTemplate template = FileTemplateManager.getInstance().getCodeTemplate("Catch Statement Body.java");
        ReplaceWithFileTemplateFix replaceWithFileTemplateFix = new ReplaceWithFileTemplateFix(){

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                if (project == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/defaultFileTemplateUsage/CatchBodyVisitor$2.applyFix must not be null");
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/defaultFileTemplateUsage/CatchBodyVisitor$2.applyFix must not be null");
                }
                PsiParameter parameter = section.getParameter();
                if (parameter == null) {
                    return;
                }
                PsiCodeBlock catchBlock = section.getCatchBlock();
                if (catchBlock == null) {
                    return;
                }
                PsiType type = parameter.getType();
                if (!(type instanceof PsiClassType)) {
                    return;
                }
                PsiJavaParserFacade elementFactory = JavaPsiFacade.getInstance((Project)section.getProject()).getParserFacade();
                try {
                    PsiCatchSection sectionTemplate = elementFactory.createCatchSection((PsiClassType)type, parameter.getName(), (PsiElement)parameter);
                    section.replace((PsiElement)sectionTemplate);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        };
        LocalQuickFix editFileTemplateFix = DefaultFileTemplateUsageInspection.createEditFileTemplateFix(template, replaceWithFileTemplateFix);
        if (template.isDefault()) {
            return new LocalQuickFix[]{editFileTemplateFix};
        }
        return new LocalQuickFix[]{replaceWithFileTemplateFix, editFileTemplateFix};
    }
}

