/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaConstValue
extends DfaValue {
    private final Object myValue;

    DfaConstValue(Object value, DfaValueFactory factory) {
        super(factory);
        this.myValue = value;
    }

    public String toString() {
        if (this.myValue == null) {
            return "null";
        }
        return this.myValue.toString();
    }

    public Object getValue() {
        return this.myValue;
    }

    @Override
    public DfaValue createNegated() {
        if (this == this.myFactory.getConstFactory().getTrue()) {
            return this.myFactory.getConstFactory().getFalse();
        }
        if (this == this.myFactory.getConstFactory().getFalse()) {
            return this.myFactory.getConstFactory().getTrue();
        }
        return DfaUnknownValue.getInstance();
    }

    public static class Factory {
        private final DfaConstValue dfaNull;
        private final DfaConstValue dfaFalse;
        private final DfaConstValue dfaTrue;
        private final DfaValueFactory myFactory;
        private final Map<Object, DfaConstValue> myValues;

        Factory(DfaValueFactory factory) {
            this.myFactory = factory;
            this.myValues = new HashMap();
            this.dfaNull = new DfaConstValue(null, factory);
            this.dfaFalse = new DfaConstValue(Boolean.FALSE, factory);
            this.dfaTrue = new DfaConstValue(Boolean.TRUE, factory);
        }

        @Nullable
        public DfaValue create(PsiLiteralExpression expr) {
            PsiType type = expr.getType();
            if (PsiType.NULL.equals(type)) {
                return this.dfaNull;
            }
            Object value = expr.getValue();
            if (value == null) {
                return null;
            }
            return this.createFromValue(value, type);
        }

        @Nullable
        public DfaValue create(PsiVariable variable) {
            Object value = variable.computeConstantValue();
            PsiType type = variable.getType();
            if (value == null) {
                Boolean boo = Factory.computeJavaLangBooleanFieldReference(variable);
                if (boo != null) {
                    DfaConstValue unboxed = this.createFromValue(boo, PsiType.BOOLEAN);
                    return this.myFactory.getBoxedFactory().createBoxed(unboxed);
                }
                return null;
            }
            return this.createFromValue(value, type);
        }

        @Nullable
        private static Boolean computeJavaLangBooleanFieldReference(PsiVariable variable) {
            if (!(variable instanceof PsiField)) {
                return null;
            }
            PsiClass psiClass = ((PsiField)variable).getContainingClass();
            if (psiClass == null || !"java.lang.Boolean".equals(psiClass.getQualifiedName())) {
                return null;
            }
            String name = variable.getName();
            return "TRUE".equals(name) ? Boolean.TRUE : ("FALSE".equals(name) ? Boolean.FALSE : null);
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public DfaConstValue createFromValue(Object value, PsiType type) {
            DfaConstValue instance;
            DfaConstValue dfaConstValue;
            if (value == Boolean.TRUE) {
                dfaConstValue = this.dfaTrue;
                if (dfaConstValue == null) throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/value/DfaConstValue$Factory.createFromValue must not return null");
                return dfaConstValue;
            }
            if (value == Boolean.FALSE) {
                dfaConstValue = this.dfaFalse;
                if (dfaConstValue == null) throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/value/DfaConstValue$Factory.createFromValue must not return null");
                return dfaConstValue;
            }
            if (TypeConversionUtil.isNumericType((PsiType)type) && !PsiType.DOUBLE.equals(type) && !PsiType.FLOAT.equals(type)) {
                value = TypeConversionUtil.computeCastTo((Object)value, (PsiType)PsiType.LONG);
            }
            if ((instance = this.myValues.get(value)) == null) {
                instance = new DfaConstValue(value, this.myFactory);
                this.myValues.put(value, instance);
            }
            if ((dfaConstValue = instance) != null) return dfaConstValue;
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/value/DfaConstValue$Factory.createFromValue must not return null");
        }

        public DfaConstValue getFalse() {
            return this.dfaFalse;
        }

        public DfaConstValue getTrue() {
            return this.dfaTrue;
        }

        public DfaConstValue getNull() {
            return this.dfaNull;
        }
    }
}

