/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.LocalInspectionsPass;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.intention.impl.IntentionHintComponent;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.idea.ActionsBundle;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.IncorrectOperationException;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowIntentionActionsHandler
implements CodeInsightActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler");

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler.invoke must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler.invoke must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler.invoke must not be null");
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        if (HintManagerImpl.getInstanceImpl().performCurrentQuestionAction()) {
            return;
        }
        if (file instanceof PsiCodeFragment) {
            return;
        }
        TemplateState state = TemplateManagerImpl.getTemplateState(editor);
        if (state != null && !state.isFinished()) {
            return;
        }
        DaemonCodeAnalyzerImpl codeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)project);
        codeAnalyzer.autoImportReferenceAtCursor(editor, file);
        ShowIntentionsPass.IntentionsInfo intentions = new ShowIntentionsPass.IntentionsInfo();
        ShowIntentionsPass.getActionsToShow(editor, file, intentions, -1);
        if (!codeAnalyzer.isAllAnalysisFinished(file)) {
            ShowIntentionActionsHandler.runPassesAndShowIntentions(project, editor, file, intentions);
        } else if (!intentions.isEmpty()) {
            IntentionHintComponent.showIntentionHint(project, file, editor, intentions, true);
        }
    }

    private static void runPassesAndShowIntentions(final Project project, final Editor editor, final PsiFile file, final ShowIntentionsPass.IntentionsInfo intentions) {
        intentions.errorFixesToShow.clear();
        intentions.inspectionFixesToShow.clear();
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        final Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        final int offset = editor.getCaretModel().getOffset();
        final PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return;
        }
        Task.Backgroundable task = new Task.Backgroundable(project, ActionsBundle.message((String)"action.ShowIntentionActions.text", (Object[])new Object[0]), true){

            public void run(final @NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler$1.run must not be null");
                }
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        TextRange textRange = element.getTextRange();
                        LocalInspectionsPass pass = new LocalInspectionsPass(file, document, textRange.getStartOffset(), textRange.getEndOffset());
                        pass.collectInformation(indicator);
                        for (HighlightInfo info : pass.getHighlights()) {
                            if (info.quickFixActionRanges == null) continue;
                            boolean isError = info.getSeverity() == HighlightSeverity.ERROR;
                            for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> actionRanges : info.quickFixActionRanges) {
                                IntentionAction action;
                                boolean available;
                                if (!((TextRange)actionRanges.second).contains(offset) || !(available = (action = ((HighlightInfo.IntentionActionDescriptor)actionRanges.first).getAction()) instanceof PsiElementBaseIntentionAction ? ((PsiElementBaseIntentionAction)action).isAvailable(project, editor, element) : action.isAvailable(project, editor, file))) continue;
                                if (isError) {
                                    intentions.errorFixesToShow.add((HighlightInfo.IntentionActionDescriptor)actionRanges.first);
                                    continue;
                                }
                                intentions.inspectionFixesToShow.add((HighlightInfo.IntentionActionDescriptor)actionRanges.first);
                            }
                        }
                    }
                });
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (editor.getComponent().isDisplayable() && !intentions.isEmpty()) {
                            IntentionHintComponent.showIntentionHint(project, file, editor, intentions, true);
                        }
                    }
                });
            }
        };
        ProgressManager.getInstance().run((Task)task);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public static Pair<PsiFile, Editor> availableFor(PsiFile file, Editor editor, IntentionAction action, PsiElement element) {
        PsiFile fileToApply;
        Editor editorToApply;
        if (!file.isValid()) {
            return null;
        }
        Project project = file.getProject();
        int offset = editor.getCaretModel().getOffset();
        PsiElement injected = InjectedLanguageManager.getInstance((Project)project).findInjectedElementAt(file, offset);
        boolean inProject = file.getManager().isInProject((PsiElement)file);
        if (injected != null) {
            PsiFile injectedFile = injected.getContainingFile();
            Editor injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor, injectedFile);
            if (ShowIntentionActionsHandler.isAvailableHere(injectedEditor, injectedFile, injected, inProject, action)) {
                editorToApply = injectedEditor;
                fileToApply = injectedFile;
            } else {
                if (!ShowIntentionActionsHandler.isAvailableHere(editor, file, element, inProject, action)) {
                    return null;
                }
                editorToApply = editor;
                fileToApply = file;
            }
        } else {
            if (!ShowIntentionActionsHandler.isAvailableHere(editor, file, element, inProject, action)) {
                return null;
            }
            editorToApply = editor;
            fileToApply = file;
        }
        return Pair.create((Object)fileToApply, (Object)editorToApply);
    }

    private static boolean isAvailableHere(Editor editor, PsiFile psiFile, PsiElement psiElement, boolean inProject, IntentionAction action) {
        try {
            Project project = psiFile.getProject();
            if (action instanceof PsiElementBaseIntentionAction ? !inProject || !((PsiElementBaseIntentionAction)action).isAvailable(project, editor, psiElement) : !action.isAvailable(project, editor, psiFile)) {
                return false;
            }
        }
        catch (IndexNotReadyException e) {
            return false;
        }
        return true;
    }

    public static void chooseActionAndInvoke(PsiFile file, final Editor editor, final IntentionAction action, String text) {
        final Project project = file.getProject();
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        Pair<PsiFile, Editor> pair = ShowIntentionActionsHandler.availableFor(file, editor, action, element);
        if (pair == null) {
            return;
        }
        final Editor editorToApply = (Editor)pair.second;
        final PsiFile fileToApply = (PsiFile)pair.first;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    action.invoke(project, editorToApply, fileToApply);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
                DaemonCodeAnalyzer.getInstance((Project)project).updateVisibleHighlighters(editor);
            }
        };
        if (action.startInWriteAction()) {
            final Runnable _runnable = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(_runnable);
                }
            };
        }
        CommandProcessor.getInstance().executeCommand(project, runnable, text, null);
    }
}

