/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import org.jetbrains.annotations.NotNull;

public class HtmlClosingTagErrorFilter
extends HighlightErrorFilter {
    public boolean shouldHighlightErrorElement(@NotNull PsiErrorElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/highlighting/HtmlClosingTagErrorFilter.shouldHighlightErrorElement must not be null");
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null || psiFile.getViewProvider().getBaseLanguage() != HTMLLanguage.INSTANCE && HTMLLanguage.INSTANCE != element.getLanguage()) {
            return true;
        }
        PsiElement[] children = element.getChildren();
        return children.length <= 0 || !(children[0] instanceof XmlToken) || XmlTokenType.XML_END_TAG_START != ((XmlToken)children[0]).getTokenType() || !XmlErrorMessages.message("xml.parsing.closing.tag.matches.nothing", new Object[0]).equals(element.getErrorDescription());
    }
}

