/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.LocalInspectionsPass;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class HighlightSuppressedWarningsHandler
extends HighlightUsagesHandlerBase<PsiLiteralExpression> {
    private static final Logger LOG = Logger.getInstance((String)("#" + HighlightSuppressedWarningsHandler.class.getName()));
    private final PsiAnnotation myTarget;
    private final PsiLiteralExpression mySuppressedExpression;

    protected HighlightSuppressedWarningsHandler(Editor editor, PsiFile file, PsiAnnotation target, PsiLiteralExpression suppressedExpression) {
        super(editor, file);
        this.myTarget = target;
        this.mySuppressedExpression = suppressedExpression;
    }

    @Override
    public List<PsiLiteralExpression> getTargets() {
        PsiNameValuePair[] attributes;
        ArrayList<PsiLiteralExpression> result = new ArrayList<PsiLiteralExpression>();
        if (this.mySuppressedExpression != null) {
            result.add(this.mySuppressedExpression);
            return result;
        }
        PsiAnnotationParameterList list = this.myTarget.getParameterList();
        for (PsiNameValuePair attribute : attributes = list.getAttributes()) {
            PsiAnnotationMemberValue[] initializers;
            PsiAnnotationMemberValue value = attribute.getValue();
            if (!(value instanceof PsiArrayInitializerMemberValue)) continue;
            for (PsiAnnotationMemberValue initializer : initializers = ((PsiArrayInitializerMemberValue)value).getInitializers()) {
                if (!(initializer instanceof PsiLiteralExpression)) continue;
                result.add((PsiLiteralExpression)initializer);
            }
        }
        return result;
    }

    @Override
    protected void selectTargets(List<PsiLiteralExpression> targets, final Consumer<List<PsiLiteralExpression>> selectionConsumer) {
        if (targets.size() == 1) {
            selectionConsumer.consume(targets);
        } else {
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<PsiLiteralExpression>("Choose Inspections to Highlight Suppressed Problems from", targets){

                public PopupStep onChosen(PsiLiteralExpression selectedValue, boolean finalChoice) {
                    selectionConsumer.consume(Collections.singletonList(selectedValue));
                    return FINAL_CHOICE;
                }

                @NotNull
                public String getTextFor(PsiLiteralExpression value) {
                    Object o = value.getValue();
                    LOG.assertTrue(o instanceof String);
                    String string = (String)o;
                    if (string == null) {
                        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/highlighting/HighlightSuppressedWarningsHandler$1.getTextFor must not return null");
                    }
                    return string;
                }
            }).showInBestPositionFor(this.myEditor);
        }
    }

    @Override
    public void computeUsages(List<PsiLiteralExpression> targets) {
        Project project = this.myTarget.getProject();
        PsiElement parent = this.myTarget.getParent().getParent();
        final LocalInspectionsPass pass = new LocalInspectionsPass(this.myFile, this.myFile.getViewProvider().getDocument(), parent.getTextRange().getStartOffset(), parent.getTextRange().getEndOffset());
        InspectionProfile inspectionProfile = InspectionProjectProfileManager.getInstance(project).getInspectionProfile();
        for (PsiLiteralExpression target : targets) {
            InspectionProfileEntry toolById;
            Object value = target.getValue();
            if (!(value instanceof String) || !((toolById = ((InspectionProfileImpl)inspectionProfile).getToolById((String)value, (PsiElement)target)) instanceof LocalInspectionToolWrapper)) continue;
            final LocalInspectionToolWrapper tool = new LocalInspectionToolWrapper(((LocalInspectionToolWrapper)toolById).getTool());
            final InspectionManagerEx managerEx = (InspectionManagerEx)InspectionManagerEx.getInstance((Project)project);
            GlobalInspectionContextImpl context = managerEx.createNewGlobalContext(false);
            tool.initialize(context);
            ((RefManagerImpl)context.getRefManager()).inspectionReadActionStarted();
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            Runnable inspect = new Runnable(){

                @Override
                public void run() {
                    pass.doInspectInBatch(managerEx, Collections.singletonList(tool), false);
                }
            };
            if (indicator == null) {
                ((ProgressManagerImpl)ProgressManager.getInstance()).executeProcessUnderProgress(inspect, new ProgressIndicatorBase());
            } else {
                inspect.run();
            }
            for (HighlightInfo info : pass.getInfos()) {
                PsiElement element = CollectHighlightsUtil.findCommonParent((PsiElement)this.myFile, info.startOffset, info.endOffset);
                if (element == null) continue;
                this.addOccurrence(element);
            }
        }
    }
}

