/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.surroundWith;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.generation.surroundWith.JavaExpressionSurrounder;
import com.intellij.codeInsight.generation.surroundWith.JavaWithCastSurrounder;
import com.intellij.codeInsight.generation.surroundWith.JavaWithIfElseExpressionSurrounder;
import com.intellij.codeInsight.generation.surroundWith.JavaWithIfExpressionSurrounder;
import com.intellij.codeInsight.generation.surroundWith.JavaWithNotInstanceofSurrounder;
import com.intellij.codeInsight.generation.surroundWith.JavaWithNotSurrounder;
import com.intellij.codeInsight.generation.surroundWith.JavaWithParenthesesSurrounder;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.surroundWith.SurroundDescriptor;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class JavaExpressionSurroundDescriptor
implements SurroundDescriptor {
    private Surrounder[] mySurrounders = null;
    private static final Surrounder[] SURROUNDERS = new Surrounder[]{new JavaWithParenthesesSurrounder(), new JavaWithCastSurrounder(), new JavaWithNotSurrounder(), new JavaWithNotInstanceofSurrounder(), new JavaWithIfExpressionSurrounder(), new JavaWithIfElseExpressionSurrounder()};

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiElement[] getElementsToSurround(PsiFile file, int startOffset, int endOffset) {
        PsiElement[] psiElementArray;
        PsiExpression expr = CodeInsightUtil.findExpressionInRange(file, startOffset, endOffset);
        if (expr == null) {
            psiElementArray = PsiElement.EMPTY_ARRAY;
            if (PsiElement.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/generation/surroundWith/JavaExpressionSurroundDescriptor.getElementsToSurround must not return null");
            return psiElementArray;
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.surroundwith.expression");
        psiElementArray = new PsiElement[]{expr};
        if (psiElementArray != null) return psiElementArray;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/generation/surroundWith/JavaExpressionSurroundDescriptor.getElementsToSurround must not return null");
    }

    @NotNull
    public Surrounder[] getSurrounders() {
        if (this.mySurrounders == null) {
            ArrayList list = new ArrayList();
            Collections.addAll(list, SURROUNDERS);
            Collections.addAll(list, Extensions.getExtensions((ExtensionPointName)JavaExpressionSurrounder.EP_NAME));
            this.mySurrounders = list.toArray(new Surrounder[list.size()]);
        }
        if (this.mySurrounders == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/generation/surroundWith/JavaExpressionSurroundDescriptor.getSurrounders must not return null");
        }
        return this.mySurrounders;
    }
}

