/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpandRegionHandler
implements CodeInsightActionHandler {
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/folding/impl/ExpandRegionHandler.invoke must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/folding/impl/ExpandRegionHandler.invoke must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/folding/impl/ExpandRegionHandler.invoke must not be null");
        }
        ExpandRegionHandler.expandRegionAtCaret(project, editor);
    }

    public static void expandRegionAtCaret(Project project, final @Nullable Editor editor) {
        if (editor == null) {
            return;
        }
        CodeFoldingManager foldingManager = CodeFoldingManager.getInstance(project);
        foldingManager.updateFoldRegions(editor);
        final int line = editor.getCaretModel().getLogicalPosition().line;
        Runnable processor = new Runnable(){

            @Override
            public void run() {
                FoldRegion region = FoldingUtil.findFoldRegionStartingAtLine(editor, line);
                if (region != null && !region.isExpanded()) {
                    region.setExpanded(true);
                } else {
                    int offset = editor.getCaretModel().getOffset();
                    FoldRegion[] regions = FoldingUtil.getFoldRegionsAtOffset(editor, offset);
                    for (int i = regions.length - 1; i >= 0; --i) {
                        region = regions[i];
                        if (region.isExpanded()) continue;
                        region.setExpanded(true);
                        break;
                    }
                }
            }
        };
        editor.getFoldingModel().runBatchFoldingOperation(processor);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

