/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.JavaLikeQuoteHandler;
import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.codeInsight.editorActions.QuoteHandlerEP;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.codeInsight.highlighting.NontrivialBraceMatcher;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypedHandler
implements TypedActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.editorActions.TypedHandler");
    private final TypedActionHandler myOriginalHandler;
    private static final Map<FileType, QuoteHandler> quoteHandlers = new HashMap<FileType, QuoteHandler>();
    private static final Map<Class<? extends Language>, QuoteHandler> ourBaseLanguageQuoteHandlers = new HashMap<Class<? extends Language>, QuoteHandler>();

    public TypedHandler(TypedActionHandler originalHandler) {
        this.myOriginalHandler = originalHandler;
    }

    @Nullable
    public static QuoteHandler getQuoteHandler(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/editorActions/TypedHandler.getQuoteHandler must not be null");
        }
        QuoteHandler quoteHandler = TypedHandler.getQuoteHandlerForType(file.getFileType());
        if (quoteHandler == null) {
            Language baseLanguage = file.getViewProvider().getBaseLanguage();
            for (Map.Entry<Class<? extends Language>, QuoteHandler> entry : ourBaseLanguageQuoteHandlers.entrySet()) {
                if (!entry.getKey().isInstance(baseLanguage)) continue;
                return entry.getValue();
            }
        }
        return quoteHandler;
    }

    public static void registerBaseLanguageQuoteHandler(Class<? extends Language> languageClass, QuoteHandler quoteHandler) {
        ourBaseLanguageQuoteHandlers.put(languageClass, quoteHandler);
    }

    public static QuoteHandler getQuoteHandlerForType(FileType fileType) {
        if (!quoteHandlers.containsKey(fileType)) {
            QuoteHandlerEP[] handlerEPs;
            QuoteHandler handler = null;
            for (QuoteHandlerEP ep : handlerEPs = (QuoteHandlerEP[])Extensions.getExtensions(QuoteHandlerEP.EP_NAME)) {
                if (!ep.fileType.equals(fileType.getName())) continue;
                handler = ep.getHandler();
                break;
            }
            quoteHandlers.put(fileType, handler);
        }
        return quoteHandlers.get(fileType);
    }

    public static void registerQuoteHandler(FileType fileType, QuoteHandler quoteHandler) {
        quoteHandlers.put(fileType, quoteHandler);
    }

    public void execute(@NotNull Editor editor, char charTyped, @NotNull DataContext dataContext) {
        TypedHandlerDelegate.Result result;
        VirtualFile virtualFile;
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/editorActions/TypedHandler.execute must not be null");
        }
        if (dataContext == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/editorActions/TypedHandler.execute must not be null");
        }
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null || editor.isColumnMode()) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor, charTyped, dataContext);
            }
            return;
        }
        PsiFile file = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
        if (file == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor, charTyped, dataContext);
            }
            return;
        }
        if (editor.isViewer()) {
            return;
        }
        if (!FileDocumentManager.getInstance().requestWriting(editor.getDocument(), project)) {
            return;
        }
        Editor injectedEditor = TypedHandler.injectedEditorIfCharTypedIsSignificant(charTyped, editor, file);
        if (injectedEditor != editor) {
            file = PsiDocumentManager.getInstance((Project)project).getPsiFile(injectedEditor.getDocument());
            editor = injectedEditor;
        }
        TypedHandlerDelegate[] delegates = (TypedHandlerDelegate[])Extensions.getExtensions((ExtensionPointName)TypedHandlerDelegate.EP_NAME);
        AutoPopupController autoPopupController = AutoPopupController.getInstance(project);
        boolean handled = false;
        for (TypedHandlerDelegate delegate : delegates) {
            TypedHandlerDelegate.Result result2 = delegate.checkAutoPopup(charTyped, project, editor, file);
            boolean bl = handled = result2 == TypedHandlerDelegate.Result.STOP;
            if (result2 != TypedHandlerDelegate.Result.CONTINUE) break;
        }
        if (!handled) {
            if (charTyped == '.') {
                autoPopupController.autoPopupMemberLookup(editor, null);
            }
            if (charTyped == '(' && !TypedHandler.isInsideStringLiteral(editor, file)) {
                autoPopupController.autoPopupParameterInfo(editor, null);
            }
        }
        if (!editor.isInsertMode()) {
            this.myOriginalHandler.execute(editor, charTyped, dataContext);
            return;
        }
        if (editor.getSelectionModel().hasSelection()) {
            EditorModificationUtil.deleteSelectedText((Editor)editor);
        }
        FileType fileType = (virtualFile = file.getVirtualFile()) == null ? file.getFileType() : virtualFile.getFileType();
        for (TypedHandlerDelegate delegate : delegates) {
            result = delegate.beforeCharTyped(charTyped, project, editor, file, fileType);
            if (result == TypedHandlerDelegate.Result.STOP) {
                return;
            }
            if (result == TypedHandlerDelegate.Result.DEFAULT) break;
        }
        if (!editor.getSelectionModel().hasBlockSelection() && (')' == charTyped || ']' == charTyped || '}' == charTyped ? TypedHandler.handleRParen(editor, fileType, charTyped) : ('\"' == charTyped || '\'' == charTyped) && this.handleQuote(editor, charTyped, dataContext, file))) {
            return;
        }
        this.myOriginalHandler.execute(editor, charTyped, dataContext);
        if (('(' == charTyped || '[' == charTyped || '{' == charTyped) && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && !editor.getSelectionModel().hasBlockSelection()) {
            TypedHandler.handleAfterLParen(editor, fileType, charTyped);
        } else if ('}' == charTyped) {
            TypedHandler.indentClosingBrace(project, editor);
        }
        for (TypedHandlerDelegate delegate : delegates) {
            result = delegate.charTyped(charTyped, project, editor, file);
            if (result == TypedHandlerDelegate.Result.STOP) {
                return;
            }
            if (result == TypedHandlerDelegate.Result.DEFAULT) break;
        }
        if ('{' == charTyped) {
            TypedHandler.indentOpenedBrace(project, editor);
        }
    }

    private static boolean isInsideStringLiteral(Editor editor, PsiFile file) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return false;
        }
        ParserDefinition definition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(element.getLanguage());
        if (definition != null) {
            TokenSet stringLiteralElements = definition.getStringLiteralElements();
            ASTNode node = element.getNode();
            if (node == null) {
                return false;
            }
            IElementType elementType = node.getElementType();
            if (stringLiteralElements.contains(elementType)) {
                return true;
            }
            PsiElement parent = element.getParent();
            if (parent != null && stringLiteralElements.contains(parent.getNode().getElementType())) {
                return true;
            }
        }
        return false;
    }

    static Editor injectedEditorIfCharTypedIsSignificant(char charTyped, Editor editor, PsiFile oldFile) {
        boolean significant;
        boolean bl = significant = charTyped == '\"' || charTyped == '\'' || charTyped == '[' || charTyped == '(' || charTyped == ']' || charTyped == ')' || charTyped == '{' || charTyped == '}' || charTyped == '.';
        if (!significant) {
            return editor;
        }
        int offset = editor.getCaretModel().getOffset();
        for (DocumentWindow documentWindow : InjectedLanguageUtil.getCachedInjectedDocuments(oldFile)) {
            if (!documentWindow.isValid() || !documentWindow.containsRange(offset, offset)) continue;
            PsiFile injectedFile = PsiDocumentManager.getInstance((Project)oldFile.getProject()).getPsiFile((Document)documentWindow);
            return InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor, injectedFile);
        }
        return editor;
    }

    private static void handleAfterLParen(Editor editor, FileType fileType, char lparenChar) {
        boolean matched;
        int lparenOffset;
        boolean atEndOfDocument;
        int offset = editor.getCaretModel().getOffset();
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        boolean bl = atEndOfDocument = offset == editor.getDocument().getTextLength();
        if (!atEndOfDocument) {
            iterator.retreat();
        }
        if (iterator.atEnd()) {
            return;
        }
        BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator);
        if (iterator.atEnd()) {
            return;
        }
        IElementType braceTokenType = iterator.getTokenType();
        CharSequence fileText = editor.getDocument().getCharsSequence();
        if (!braceMatcher.isLBraceToken(iterator, fileText, fileType)) {
            return;
        }
        if (!iterator.atEnd()) {
            IElementType tokenType;
            iterator.advance();
            IElementType iElementType = tokenType = iterator.atEnd() ? null : iterator.getTokenType();
            if (!BraceMatchingUtil.isPairedBracesAllowedBeforeTypeInFileType(braceTokenType, tokenType, fileType)) {
                return;
            }
            if (!iterator.atEnd() && BraceMatchingUtil.isLBraceToken(iterator, fileText, fileType)) {
                return;
            }
            iterator.retreat();
        }
        if ((lparenOffset = BraceMatchingUtil.findLeftmostLParen(iterator, braceTokenType, fileText, fileType)) < 0) {
            lparenOffset = 0;
        }
        if (!(matched = BraceMatchingUtil.matchBrace(fileText, fileType, iterator = ((EditorEx)editor).getHighlighter().createIterator(lparenOffset), true))) {
            String text;
            if (lparenChar == '(') {
                text = ")";
            } else if (lparenChar == '[') {
                text = "]";
            } else if (lparenChar == '<') {
                text = ">";
            } else if (lparenChar == '{') {
                text = "}";
            } else {
                LOG.error("Unknown char " + lparenChar);
                return;
            }
            editor.getDocument().insertString(offset, (CharSequence)text);
        }
    }

    public static boolean handleRParen(Editor editor, FileType fileType, char charTyped) {
        boolean matched;
        CharSequence text;
        BraceMatcher braceMatcher;
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        if (offset == editor.getDocument().getTextLength()) {
            return false;
        }
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (iterator.atEnd()) {
            return false;
        }
        Language language = iterator.getTokenType().getLanguage();
        ParserDefinition definition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        if (definition != null && !(language instanceof TemplateLanguage)) {
            Lexer lexer = definition.createLexer(editor.getProject());
            lexer.start((CharSequence)Character.toString(charTyped));
            IElementType tokenType = lexer.getTokenType();
            if (tokenType != iterator.getTokenType()) {
                return false;
            }
        }
        if (!(braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator)).isRBraceToken(iterator, text = editor.getDocument().getCharsSequence(), fileType)) {
            return false;
        }
        IElementType tokenType = iterator.getTokenType();
        iterator.retreat();
        IElementType lparenTokenType = braceMatcher.getOppositeBraceTokenType(tokenType);
        int lparenthOffset = BraceMatchingUtil.findLeftmostLParen(iterator, lparenTokenType, text, fileType);
        if (lparenthOffset < 0) {
            if (braceMatcher instanceof NontrivialBraceMatcher) {
                for (IElementType t : ((NontrivialBraceMatcher)braceMatcher).getOppositeBraceTokenTypes(tokenType)) {
                    if (t != lparenTokenType && (lparenthOffset = BraceMatchingUtil.findLeftmostLParen(iterator, t, text, fileType)) >= 0) break;
                }
            }
            if (lparenthOffset < 0) {
                return false;
            }
        }
        if (!(matched = BraceMatchingUtil.matchBrace(text, fileType, iterator = ((EditorEx)editor).getHighlighter().createIterator(lparenthOffset), true))) {
            return false;
        }
        editor.getCaretModel().moveToOffset(offset + 1);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        return true;
    }

    private boolean handleQuote(Editor editor, char quote, DataContext dataContext, PsiFile file) {
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_QUOTE) {
            return false;
        }
        QuoteHandler quoteHandler = TypedHandler.getQuoteHandler(file);
        if (quoteHandler == null) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        CharSequence chars = editor.getDocument().getCharsSequence();
        int length = editor.getDocument().getTextLength();
        if (TypedHandler.isTypingEscapeQuote(editor, quoteHandler, offset)) {
            return false;
        }
        if (offset < length && chars.charAt(offset) == quote && TypedHandler.isClosingQuote(editor, quoteHandler, offset)) {
            editor.getCaretModel().moveToOffset(offset + 1);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            return true;
        }
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (!iterator.atEnd()) {
            IElementType tokenType = iterator.getTokenType();
            if (quoteHandler instanceof JavaLikeQuoteHandler) {
                try {
                    if (!((JavaLikeQuoteHandler)quoteHandler).isAppropriateElementTypeForLiteral(tokenType)) {
                        return false;
                    }
                }
                catch (AbstractMethodError incompatiblePluginErrorThatDoesNotInterestUs) {
                    // empty catch block
                }
            }
        }
        this.myOriginalHandler.execute(editor, quote, dataContext);
        offset = editor.getCaretModel().getOffset();
        if (TypedHandler.isOpeningQuote(editor, quoteHandler, offset - 1) && TypedHandler.hasNonClosedLiterals(editor, quoteHandler, offset - 1)) {
            editor.getDocument().insertString(offset, (CharSequence)String.valueOf(quote));
        }
        return true;
    }

    private static boolean isClosingQuote(Editor editor, QuoteHandler quoteHandler, int offset) {
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (iterator.atEnd()) {
            LOG.assertTrue(false);
            return false;
        }
        return quoteHandler.isClosingQuote(iterator, offset);
    }

    private static boolean isOpeningQuote(Editor editor, QuoteHandler quoteHandler, int offset) {
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (iterator.atEnd()) {
            LOG.assertTrue(false);
            return false;
        }
        return quoteHandler.isOpeningQuote(iterator, offset);
    }

    private static boolean hasNonClosedLiterals(Editor editor, QuoteHandler quoteHandler, int offset) {
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (iterator.atEnd()) {
            LOG.assertTrue(false);
            return false;
        }
        return quoteHandler.hasNonClosedLiteral(editor, iterator, offset);
    }

    private static boolean isTypingEscapeQuote(Editor editor, QuoteHandler quoteHandler, int offset) {
        if (offset == 0) {
            return false;
        }
        CharSequence chars = editor.getDocument().getCharsSequence();
        int offset1 = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(offset - 1), (String)"\\");
        int slashCount = offset - 1 - offset1;
        return slashCount % 2 != 0 && TypedHandler.isInsideLiteral(editor, quoteHandler, offset);
    }

    private static boolean isInsideLiteral(Editor editor, QuoteHandler quoteHandler, int offset) {
        if (offset == 0) {
            return false;
        }
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset - 1);
        if (iterator.atEnd()) {
            LOG.assertTrue(false);
            return false;
        }
        return quoteHandler.isInsideLiteral(iterator);
    }

    private static void indentClosingBrace(@NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/editorActions/TypedHandler.indentClosingBrace must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/editorActions/TypedHandler.indentClosingBrace must not be null");
        }
        TypedHandler.indentBrace(project, editor, '}');
    }

    static void indentOpenedBrace(@NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/editorActions/TypedHandler.indentOpenedBrace must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/editorActions/TypedHandler.indentOpenedBrace must not be null");
        }
        TypedHandler.indentBrace(project, editor, '{');
    }

    private static void indentBrace(final @NotNull Project project, final @NotNull Editor editor, char braceChar) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/editorActions/TypedHandler.indentBrace must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/editorActions/TypedHandler.indentBrace must not be null");
        }
        final int offset = editor.getCaretModel().getOffset() - 1;
        Document document = editor.getDocument();
        CharSequence chars = document.getCharsSequence();
        if (offset < 0 || chars.charAt(offset) != braceChar) {
            return;
        }
        int spaceStart = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(offset - 1), (String)" \t");
        if (spaceStart < 0 || chars.charAt(spaceStart) == '\n' || chars.charAt(spaceStart) == '\r') {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            documentManager.commitDocument(document);
            final PsiFile file = documentManager.getPsiFile(document);
            if (file == null || !file.isWritable()) {
                return;
            }
            PsiElement element = file.findElementAt(offset);
            if (element == null) {
                return;
            }
            EditorHighlighter highlighter = ((EditorEx)editor).getHighlighter();
            HighlighterIterator iterator = highlighter.createIterator(offset);
            BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(file.getFileType(), iterator);
            if (element.getNode() != null && braceMatcher.isStructuralBrace(iterator, chars, file.getFileType())) {
                Runnable action = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            int newOffset = CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, offset);
                            editor.getCaretModel().moveToOffset(newOffset + 1);
                            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                            editor.getSelectionModel().removeSelection();
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                };
                ApplicationManager.getApplication().runWriteAction(action);
            }
        }
    }
}

