/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.hint.ElementLocationUtil;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.ide.actions.ExternalJavaDocAction;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.EdgeBorder;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.View;
import org.jetbrains.annotations.Nullable;

public class DocumentationComponent
extends JPanel
implements Disposable {
    private static final int MAX_WIDTH = 500;
    private static final int MAX_HEIGHT = 300;
    private static final int MIN_HEIGHT = 45;
    private DocumentationManager myManager;
    private SmartPsiElementPointer myElement;
    private final Stack<Context> myBackStack = new Stack();
    private final Stack<Context> myForwardStack = new Stack();
    private ActionToolbar myToolBar;
    private boolean myIsEmpty;
    private boolean myIsShown;
    private final JLabel myElementLabel;
    private final JScrollPane myScrollPane;
    private final JEditorPane myEditorPane;
    private String myText;
    private final JPanel myControlPanel;
    private boolean myControlPanelVisible;
    private final ExternalDocAction myExternalDocAction;
    private JBPopup myHint;
    private final HashMap<KeyStroke, ActionListener> myKeyboardActions = new HashMap();

    @Override
    public boolean requestFocusInWindow() {
        return this.myScrollPane.requestFocusInWindow();
    }

    @Override
    public void requestFocus() {
        this.myScrollPane.requestFocus();
    }

    public DocumentationComponent(final DocumentationManager manager, AnAction[] additionalActions) {
        this.myManager = manager;
        this.myIsEmpty = true;
        this.myIsShown = false;
        this.myEditorPane = new JEditorPane("text/html", ""){
            {
                this.enableEvents(8L);
            }

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                if (this.getWidth() == 0 || this.getHeight() == 0) {
                    this.setSize(500, 300);
                }
                Insets ins = DocumentationComponent.this.myEditorPane.getInsets();
                View rootView = DocumentationComponent.this.myEditorPane.getUI().getRootView(DocumentationComponent.this.myEditorPane);
                rootView.setSize(500.0f, 300.0f);
                int prefHeight = (int)rootView.getPreferredSpan(1);
                return new Dimension(500, Math.max(45, Math.min(300, prefHeight += ins.bottom + ins.top + ((DocumentationComponent)DocumentationComponent.this).myScrollPane.getHorizontalScrollBar().getMaximumSize().height)));
            }

            @Override
            protected void processKeyEvent(KeyEvent e) {
                KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
                ActionListener listener = (ActionListener)DocumentationComponent.this.myKeyboardActions.get((Object)keyStroke);
                if (listener != null) {
                    listener.actionPerformed(new ActionEvent(DocumentationComponent.this, 0, ""));
                    e.consume();
                    return;
                }
                super.processKeyEvent(e);
            }
        };
        this.myText = "";
        this.myEditorPane.setEditable(false);
        this.myEditorPane.setBackground(HintUtil.INFORMATION_COLOR);
        this.myEditorPane.setEditorKit(UIUtil.getHTMLEditorKit());
        this.myScrollPane = new JScrollPane(this.myEditorPane);
        this.myScrollPane.setBorder(null);
        final MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DocumentationComponent.this.myManager.requestFocus();
            }
        };
        this.myEditorPane.addMouseListener(mouseAdapter);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                DocumentationComponent.this.myEditorPane.removeMouseListener(mouseAdapter);
            }
        });
        final FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Component previouslyFocused = WindowManagerEx.getInstanceEx().getFocusedComponent(manager.getProject(DocumentationComponent.this.getElement()));
                if (previouslyFocused != DocumentationComponent.this.myEditorPane && DocumentationComponent.this.myHint != null && !DocumentationComponent.this.myHint.isDisposed()) {
                    DocumentationComponent.this.myHint.cancel();
                }
            }
        };
        this.myEditorPane.addFocusListener(focusAdapter);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                DocumentationComponent.this.myEditorPane.removeFocusListener(focusAdapter);
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.myScrollPane, "Center");
        this.myScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 2, 2, 2));
        DefaultActionGroup actions = new DefaultActionGroup();
        actions.add((AnAction)new BackAction());
        actions.add((AnAction)new ForwardAction());
        this.myExternalDocAction = new ExternalDocAction();
        actions.add((AnAction)this.myExternalDocAction);
        if (additionalActions != null) {
            for (AnAction action : additionalActions) {
                actions.add(action);
            }
        }
        this.myToolBar = ActionManager.getInstance().createActionToolbar("JavadocToolbar", (ActionGroup)actions, true);
        this.myControlPanel = new JPanel();
        this.myControlPanel.setLayout(new BorderLayout());
        this.myControlPanel.setBorder((Border)new EdgeBorder(3840));
        JPanel dummyPanel = new JPanel();
        this.myElementLabel = new JLabel();
        dummyPanel.setLayout(new BorderLayout());
        dummyPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        dummyPanel.add((Component)this.myElementLabel, "East");
        this.myControlPanel.add((Component)this.myToolBar.getComponent(), "West");
        this.myControlPanel.add((Component)dummyPanel, "Center");
        this.myControlPanelVisible = false;
        final HyperlinkListener hyperlinkListener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                HyperlinkEvent.EventType type = e.getEventType();
                if (type == HyperlinkEvent.EventType.ACTIVATED) {
                    manager.navigateByLink(DocumentationComponent.this, e.getDescription());
                } else if (type == HyperlinkEvent.EventType.ENTERED) {
                    DocumentationComponent.this.myEditorPane.setCursor(Cursor.getPredefinedCursor(12));
                } else if (type == HyperlinkEvent.EventType.EXITED) {
                    DocumentationComponent.this.myEditorPane.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        };
        this.myEditorPane.addHyperlinkListener(hyperlinkListener);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                DocumentationComponent.this.myEditorPane.removeHyperlinkListener(hyperlinkListener);
            }
        });
        this.registerActions();
        this.updateControlState();
    }

    public DocumentationComponent(DocumentationManager manager) {
        this(manager, null);
    }

    public synchronized boolean isEmpty() {
        return this.myIsEmpty;
    }

    public synchronized void startWait() {
        this.myIsEmpty = true;
    }

    private void setControlPanelVisible(boolean visible) {
        if (visible == this.myControlPanelVisible) {
            return;
        }
        if (visible) {
            this.add((Component)this.myControlPanel, "North");
        } else {
            this.remove(this.myControlPanel);
        }
        this.myControlPanelVisible = visible;
    }

    public void setHint(JBPopup hint) {
        this.myHint = hint;
    }

    public JComponent getComponent() {
        return this.myEditorPane;
    }

    @Nullable
    public PsiElement getElement() {
        return this.myElement != null ? this.myElement.getElement() : null;
    }

    public void setText(String text, PsiElement element, boolean clearHistory) {
        this.setText(text, element, false, clearHistory);
    }

    public void setText(String text, PsiElement element, boolean clean, boolean clearHistory) {
        if (clean && this.myElement != null) {
            this.myBackStack.push(this.saveContext());
            this.myForwardStack.clear();
        }
        this.updateControlState();
        this.setData(element, text, clearHistory);
        if (clean) {
            this.myIsEmpty = false;
        }
        if (clearHistory) {
            this.clearHistory();
        }
    }

    private void clearHistory() {
        this.myForwardStack.clear();
        this.myBackStack.clear();
    }

    public void setData(PsiElement _element, String text, boolean clearHistory) {
        SmartPsiElementPointer element;
        if (this.myElement != null) {
            this.myBackStack.push(this.saveContext());
            this.myForwardStack.clear();
        }
        SmartPsiElementPointer smartPsiElementPointer = element = _element != null && _element.isValid() ? SmartPointerManager.getInstance((Project)_element.getProject()).createSmartPsiElementPointer(_element) : null;
        if (element != null) {
            this.myElement = element;
        }
        this.myIsEmpty = false;
        this.updateControlState();
        this.setDataInternal(element, text, new Rectangle(0, 0));
        if (clearHistory) {
            this.clearHistory();
        }
    }

    private void setDataInternal(SmartPsiElementPointer element, String text, Rectangle viewRect) {
        this.setDataInternal(element, text, viewRect, false);
    }

    private void setDataInternal(SmartPsiElementPointer element, String text, final Rectangle viewRect, boolean skip) {
        boolean justShown = false;
        this.myElement = element;
        if (!this.myIsShown && this.myHint != null) {
            this.myEditorPane.setText(text);
            this.myManager.showHint(this.myHint);
            justShown = true;
            this.myIsShown = true;
        }
        if (!justShown) {
            this.myEditorPane.setText(text);
        }
        if (!skip) {
            this.myText = text;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DocumentationComponent.this.myEditorPane.scrollRectToVisible(viewRect);
            }
        });
    }

    private void goBack() {
        if (this.myBackStack.isEmpty()) {
            return;
        }
        Context context = this.myBackStack.pop();
        this.myForwardStack.push(this.saveContext());
        this.restoreContext(context);
        this.updateControlState();
    }

    private void goForward() {
        if (this.myForwardStack.isEmpty()) {
            return;
        }
        Context context = this.myForwardStack.pop();
        this.myBackStack.push(this.saveContext());
        this.restoreContext(context);
        this.updateControlState();
    }

    private Context saveContext() {
        Rectangle rect = this.myScrollPane.getViewport().getViewRect();
        return new Context(this.myElement, this.myText, rect);
    }

    private void restoreContext(Context context) {
        this.setDataInternal(context.element, context.text, context.viewRect);
    }

    private void updateControlState() {
        ElementLocationUtil.customizeElementLabel(this.myElement != null ? this.myElement.getElement() : null, this.myElementLabel);
        this.myToolBar.updateActionsImmediately();
        this.setControlPanelVisible(true);
    }

    private void registerActions() {
        this.myExternalDocAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("ExternalJavaDoc").getShortcutSet(), this.myEditorPane);
        this.myKeyboardActions.put((Object)KeyStroke.getKeyStroke(38, 0), (Object)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getVerticalScrollBar();
                int value = scrollBar.getValue() - scrollBar.getUnitIncrement(-1);
                value = Math.max(value, 0);
                scrollBar.setValue(value);
            }
        });
        this.myKeyboardActions.put((Object)KeyStroke.getKeyStroke(40, 0), (Object)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getVerticalScrollBar();
                int value = scrollBar.getValue() + scrollBar.getUnitIncrement(1);
                value = Math.min(value, scrollBar.getMaximum());
                scrollBar.setValue(value);
            }
        });
        this.myKeyboardActions.put((Object)KeyStroke.getKeyStroke(37, 0), (Object)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getHorizontalScrollBar();
                int value = scrollBar.getValue() - scrollBar.getUnitIncrement(-1);
                value = Math.max(value, 0);
                scrollBar.setValue(value);
            }
        });
        this.myKeyboardActions.put((Object)KeyStroke.getKeyStroke(39, 0), (Object)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getHorizontalScrollBar();
                int value = scrollBar.getValue() + scrollBar.getUnitIncrement(1);
                value = Math.min(value, scrollBar.getMaximum());
                scrollBar.setValue(value);
            }
        });
        this.myKeyboardActions.put((Object)KeyStroke.getKeyStroke(33, 0), (Object)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getVerticalScrollBar();
                int value = scrollBar.getValue() - scrollBar.getBlockIncrement(-1);
                value = Math.max(value, 0);
                scrollBar.setValue(value);
            }
        });
        this.myKeyboardActions.put((Object)KeyStroke.getKeyStroke(34, 0), (Object)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getVerticalScrollBar();
                int value = scrollBar.getValue() + scrollBar.getBlockIncrement(1);
                value = Math.min(value, scrollBar.getMaximum());
                scrollBar.setValue(value);
            }
        });
        this.myKeyboardActions.put((Object)KeyStroke.getKeyStroke(36, 0), (Object)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getHorizontalScrollBar();
                scrollBar.setValue(0);
            }
        });
        this.myKeyboardActions.put((Object)KeyStroke.getKeyStroke(35, 0), (Object)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getHorizontalScrollBar();
                scrollBar.setValue(scrollBar.getMaximum());
            }
        });
        this.myKeyboardActions.put((Object)KeyStroke.getKeyStroke(36, 2), (Object)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getVerticalScrollBar();
                scrollBar.setValue(0);
            }
        });
        this.myKeyboardActions.put((Object)KeyStroke.getKeyStroke(35, 2), (Object)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getVerticalScrollBar();
                scrollBar.setValue(scrollBar.getMaximum());
            }
        });
    }

    public String getText() {
        return this.myText;
    }

    public void dispose() {
        this.myBackStack.clear();
        this.myForwardStack.clear();
        this.myKeyboardActions.clear();
        this.myElement = null;
        this.myManager = null;
        this.myHint = null;
    }

    private class ExternalDocAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        public ExternalDocAction() {
            super(CodeInsightBundle.message((String)"javadoc.action.view.external", (Object[])new Object[0]), null, IconLoader.getIcon((String)"/actions/browser-externalJavaDoc.png"));
            this.registerCustomShortcutSet(ActionManager.getInstance().getAction("ExternalJavaDoc").getShortcutSet(), null);
        }

        public void actionPerformed(AnActionEvent e) {
            if (DocumentationComponent.this.myElement != null) {
                PsiElement element = DocumentationComponent.this.myElement.getElement();
                DocumentationProvider provider = DocumentationManager.getProviderFromElement(element);
                List urls = provider.getUrlFor(element, DocumentationManager.getOriginalElement(element));
                assert (urls != null);
                assert (!urls.isEmpty());
                ExternalJavaDocAction.showExternalJavadoc(urls);
            }
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(false);
            if (DocumentationComponent.this.myElement != null) {
                PsiElement element = DocumentationComponent.this.myElement.getElement();
                DocumentationProvider provider = DocumentationManager.getProviderFromElement(element);
                List urls = provider.getUrlFor(element, DocumentationManager.getOriginalElement(element));
                presentation.setEnabled(element != null && urls != null && !urls.isEmpty());
            }
        }
    }

    private class ForwardAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        public ForwardAction() {
            super(CodeInsightBundle.message((String)"javadoc.action.forward", (Object[])new Object[0]), null, IconLoader.getIcon((String)"/actions/forward.png"));
        }

        public void actionPerformed(AnActionEvent e) {
            DocumentationComponent.this.goForward();
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(!DocumentationComponent.this.myForwardStack.isEmpty());
        }
    }

    private class BackAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        public BackAction() {
            super(CodeInsightBundle.message((String)"javadoc.action.back", (Object[])new Object[0]), null, IconLoader.getIcon((String)"/actions/back.png"));
        }

        public void actionPerformed(AnActionEvent e) {
            DocumentationComponent.this.goBack();
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(!DocumentationComponent.this.myBackStack.isEmpty());
        }
    }

    private static class Context {
        final SmartPsiElementPointer element;
        final String text;
        final Rectangle viewRect;

        public Context(SmartPsiElementPointer element, String text, Rectangle viewRect) {
            this.element = element;
            this.text = text;
            this.viewRect = viewRect;
        }
    }
}

