/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodArgumentFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public abstract class ArgumentFixerActionFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.ArgumentFixerActionFactory");

    @Nullable
    protected abstract PsiExpression getModifiedArgument(PsiExpression var1, PsiType var2) throws IncorrectOperationException;

    public void registerCastActions(CandidateInfo[] candidates, PsiCall call, HighlightInfo highlightInfo, TextRange fixRange) {
        int i;
        if (candidates.length == 0) {
            return;
        }
        ArrayList<CandidateInfo> methodCandidates = new ArrayList<CandidateInfo>(Arrays.asList(candidates));
        PsiExpressionList list = call.getArgumentList();
        PsiExpression[] expressions = list.getExpressions();
        if (expressions.length == 0) {
            return;
        }
        block2: for (i = methodCandidates.size() - 1; i >= 0; --i) {
            CandidateInfo candidate = (CandidateInfo)methodCandidates.get(i);
            PsiMethod method = (PsiMethod)candidate.getElement();
            PsiSubstitutor substitutor = candidate.getSubstitutor();
            assert (method != null);
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if (expressions.length != parameters.length) {
                methodCandidates.remove(i);
                continue;
            }
            for (int j = 0; j < parameters.length; ++j) {
                PsiParameter parameter = parameters[j];
                PsiExpression expression = expressions[j];
                PsiType exprType = expression.getType();
                PsiType parameterType = substitutor.substitute(parameter.getType());
                if (exprType != null && parameterType != null && this.areTypesConvertible(exprType, parameterType, (PsiElement)call)) continue;
                methodCandidates.remove(i);
                continue block2;
            }
        }
        if (methodCandidates.isEmpty()) {
            return;
        }
        try {
            for (i = 0; i < expressions.length; ++i) {
                PsiExpression expression = expressions[i];
                PsiType exprType = expression.getType();
                THashSet suggestedCasts = new THashSet();
                for (CandidateInfo candidate : methodCandidates) {
                    PsiMethod method = (PsiMethod)candidate.getElement();
                    PsiSubstitutor substitutor = candidate.getSubstitutor();
                    assert (method != null);
                    PsiParameter[] parameters = method.getParameterList().getParameters();
                    PsiType originalParameterType = parameters[i].getType();
                    PsiType parameterType = substitutor.substitute(originalParameterType);
                    if (parameterType instanceof PsiWildcardType || !GenericsUtil.isFromExternalTypeLanguage((PsiType)parameterType) || suggestedCasts.contains(parameterType.getCanonicalText()) || Comparing.equal((Object)exprType, (Object)parameterType)) continue;
                    PsiCall newCall = (PsiCall)call.copy();
                    PsiExpression modifiedExpression = this.getModifiedArgument(expression, parameterType);
                    if (modifiedExpression == null) continue;
                    newCall.getArgumentList().getExpressions()[i].replace((PsiElement)modifiedExpression);
                    JavaResolveResult resolveResult = newCall.resolveMethodGenerics();
                    if (resolveResult.getElement() == null || !resolveResult.isValidResult()) continue;
                    suggestedCasts.add(parameterType.getCanonicalText());
                    QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, this.createFix(list, i, parameterType), null);
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public abstract boolean areTypesConvertible(PsiType var1, PsiType var2, PsiElement var3);

    public abstract MethodArgumentFix createFix(PsiExpressionList var1, int var2, PsiType var3);
}

