/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReceiver;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class AnnotationsHighlightUtil {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.codeInsight.daemon.impl.analysis.AnnotationsHighlightUtil");
    @NonNls
    private static final String PACKAGE_INFO_JAVA = "package-info.java";

    public static HighlightInfo checkNameValuePair(PsiNameValuePair pair) {
        PsiReference ref = pair.getReference();
        if (ref == null) {
            return null;
        }
        PsiMethod method = (PsiMethod)ref.resolve();
        if (method == null) {
            if (pair.getName() != null) {
                String description = JavaErrorMessages.message("annotation.unknown.method", ref.getCanonicalText());
                return HighlightInfo.createHighlightInfo(HighlightInfoType.WRONG_REF, ref.getElement(), description);
            }
            String description = JavaErrorMessages.message("annotation.missing.method", ref.getCanonicalText());
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, ref.getElement(), description);
        }
        PsiType returnType = method.getReturnType();
        PsiAnnotationMemberValue value = pair.getValue();
        HighlightInfo info = AnnotationsHighlightUtil.checkMemberValueType(value, returnType);
        if (info != null) {
            return info;
        }
        return AnnotationsHighlightUtil.checkDuplicateAttribute(pair);
    }

    @Nullable
    private static HighlightInfo checkDuplicateAttribute(PsiNameValuePair pair) {
        PsiNameValuePair[] attributes;
        PsiAnnotationParameterList annotation = (PsiAnnotationParameterList)pair.getParent();
        for (PsiNameValuePair attribute : attributes = annotation.getAttributes()) {
            if (attribute == pair) break;
            if (!Comparing.equal((String)attribute.getName(), (String)pair.getName())) continue;
            String description = JavaErrorMessages.message("annotation.duplicate.attribute", pair.getName() == null ? "value" : pair.getName());
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)pair, description);
        }
        return null;
    }

    private static String formatReference(PsiJavaCodeReferenceElement ref) {
        return ref.getCanonicalText();
    }

    @Nullable
    public static HighlightInfo checkMemberValueType(PsiAnnotationMemberValue value, PsiType expectedType) {
        if (value == null) {
            return null;
        }
        if (value instanceof PsiAnnotation) {
            PsiClass aClass;
            PsiType componentType;
            PsiClass aClass2;
            PsiJavaCodeReferenceElement nameRef = ((PsiAnnotation)value).getNameReferenceElement();
            if (nameRef == null) {
                return null;
            }
            if (expectedType instanceof PsiClassType && nameRef.isReferenceTo((PsiElement)(aClass2 = ((PsiClassType)expectedType).resolve()))) {
                return null;
            }
            if (expectedType instanceof PsiArrayType && (componentType = ((PsiArrayType)expectedType).getComponentType()) instanceof PsiClassType && nameRef.isReferenceTo((PsiElement)(aClass = ((PsiClassType)componentType).resolve()))) {
                return null;
            }
            String description = JavaErrorMessages.message("annotation.incompatible.types", AnnotationsHighlightUtil.formatReference(nameRef), HighlightUtil.formatType(expectedType));
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)value, description);
        }
        if (value instanceof PsiArrayInitializerMemberValue) {
            if (expectedType instanceof PsiArrayType) {
                return null;
            }
            String description = JavaErrorMessages.message("annotation.illegal.array.initializer", HighlightUtil.formatType(expectedType));
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)value, description);
        }
        if (value instanceof PsiExpression) {
            PsiExpression expr = (PsiExpression)value;
            PsiType type = expr.getType();
            if (type != null && TypeConversionUtil.areTypesAssignmentCompatible((PsiType)expectedType, (PsiExpression)expr) || expectedType instanceof PsiArrayType && TypeConversionUtil.areTypesAssignmentCompatible((PsiType)((PsiArrayType)expectedType).getComponentType(), (PsiExpression)expr)) {
                return null;
            }
            String description = JavaErrorMessages.message("annotation.incompatible.types", HighlightUtil.formatType(type), HighlightUtil.formatType(expectedType));
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)value, description);
        }
        LOG.error("Unknown annotation member value: " + value);
        return null;
    }

    public static HighlightInfo checkDuplicatedAnnotations(PsiAnnotation annotationToCheck) {
        PsiAnnotation[] annotations;
        PsiAnnotationOwner owner = annotationToCheck.getOwner();
        if (owner == null) {
            return null;
        }
        PsiJavaCodeReferenceElement element = annotationToCheck.getNameReferenceElement();
        if (element == null) {
            return null;
        }
        PsiElement resolved = element.resolve();
        if (!(resolved instanceof PsiClass)) {
            return null;
        }
        for (PsiAnnotation annotation : annotations = owner.getApplicableAnnotations()) {
            PsiElement aClass;
            PsiJavaCodeReferenceElement nameRef;
            if (annotation == annotationToCheck || (nameRef = annotation.getNameReferenceElement()) == null || !resolved.equals(aClass = nameRef.resolve())) continue;
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)element, JavaErrorMessages.message("annotation.duplicate.annotation", new Object[0]));
        }
        return null;
    }

    @Nullable
    public static HighlightInfo checkMissingAttributes(PsiAnnotation annotation) {
        PsiJavaCodeReferenceElement nameRef = annotation.getNameReferenceElement();
        if (nameRef == null) {
            return null;
        }
        PsiClass aClass = (PsiClass)nameRef.resolve();
        if (aClass != null && aClass.isAnnotationType()) {
            PsiNameValuePair[] attributes;
            HashSet names = new HashSet();
            for (PsiNameValuePair attribute : attributes = annotation.getParameterList().getAttributes()) {
                if (attribute.getName() != null) {
                    names.add(attribute.getName());
                    continue;
                }
                names.add("value");
            }
            PsiMethod[] annotationMethods = aClass.getMethods();
            ArrayList<String> missed = new ArrayList<String>();
            for (PsiMethod method : annotationMethods) {
                PsiAnnotationMethod annotationMethod;
                if (!(method instanceof PsiAnnotationMethod) || (annotationMethod = (PsiAnnotationMethod)method).getDefaultValue() != null || names.contains(annotationMethod.getName())) continue;
                missed.add(annotationMethod.getName());
            }
            if (!missed.isEmpty()) {
                StringBuffer buff = new StringBuffer("'" + (String)missed.get(0) + "'");
                for (int i = 1; i < missed.size(); ++i) {
                    buff.append(", ");
                    buff.append("'").append((String)missed.get(i)).append("'");
                }
                String description = JavaErrorMessages.message("annotation.missing.attribute", buff);
                return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)nameRef, description);
            }
        }
        return null;
    }

    @Nullable
    public static HighlightInfo checkConstantExpression(PsiExpression expression) {
        if ((expression.getParent() instanceof PsiAnnotationMethod || expression.getParent() instanceof PsiNameValuePair) && (PsiType.NULL.equals(expression.getType()) || !PsiUtil.isConstantExpression((PsiExpression)expression))) {
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)expression, JavaErrorMessages.message("annotation.nonconstant.attribute.value", new Object[0]));
        }
        return null;
    }

    public static HighlightInfo checkValidAnnotationType(PsiTypeElement typeElement) {
        PsiType type = typeElement.getType();
        if (((Boolean)type.accept((PsiTypeVisitor)AnnotationReturnTypeVisitor.INSTANCE)).booleanValue()) {
            return null;
        }
        return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)typeElement, JavaErrorMessages.message("annotation.invalid.annotation.member.type", new Object[0]));
    }

    public static HighlightInfo checkApplicability(PsiAnnotation annotation) {
        PsiAnnotationOwner owner = annotation.getOwner();
        if (!(owner instanceof PsiModifierList || owner instanceof PsiTypeElement || owner instanceof PsiMethodReceiver || owner instanceof PsiTypeParameter)) {
            return null;
        }
        PsiElement member = ((PsiElement)owner).getParent();
        String[] elementTypeFields = AnnotationsHighlightUtil.getApplicableElementTypeFields(owner instanceof PsiModifierList ? member : (PsiElement)owner);
        if (AnnotationsHighlightUtil.isAnnotationApplicableTo(annotation, false, elementTypeFields)) {
            return null;
        }
        PsiJavaCodeReferenceElement nameRef = annotation.getNameReferenceElement();
        String description = JavaErrorMessages.message("annotation.not.applicable", nameRef.getText(), JavaErrorMessages.message("annotation.target." + elementTypeFields[0], new Object[0]));
        return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)nameRef, description);
    }

    public static boolean isAnnotationApplicableTo(PsiAnnotation annotation, boolean strict, String ... elementTypeFields) {
        if (elementTypeFields == null) {
            return true;
        }
        PsiJavaCodeReferenceElement nameRef = annotation.getNameReferenceElement();
        if (nameRef == null) {
            return !strict;
        }
        PsiElement resolved = nameRef.resolve();
        if (!(resolved instanceof PsiClass) || !((PsiClass)resolved).isAnnotationType()) {
            return !strict;
        }
        PsiClass annotationType = (PsiClass)resolved;
        PsiAnnotation target = annotationType.getModifierList().findAnnotation("java.lang.annotation.Target");
        if (target == null) {
            return !strict;
        }
        PsiNameValuePair[] attributes = target.getParameterList().getAttributes();
        if (attributes.length == 0) {
            return !strict;
        }
        PsiAnnotationMemberValue value = attributes[0].getValue();
        LOG.assertTrue(elementTypeFields.length > 0);
        PsiManager manager = annotation.getManager();
        PsiClass elementTypeClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.lang.annotation.ElementType", annotation.getResolveScope());
        if (elementTypeClass == null) {
            return !strict;
        }
        for (String fieldName : elementTypeFields) {
            PsiField field = elementTypeClass.findFieldByName(fieldName, false);
            if (field == null) continue;
            if (value instanceof PsiArrayInitializerMemberValue) {
                PsiAnnotationMemberValue[] initializers;
                for (PsiAnnotationMemberValue initializer : initializers = ((PsiArrayInitializerMemberValue)value).getInitializers()) {
                    PsiReferenceExpression refExpr;
                    if (!(initializer instanceof PsiReferenceExpression) || !(refExpr = (PsiReferenceExpression)initializer).isReferenceTo((PsiElement)field)) continue;
                    return true;
                }
                continue;
            }
            if (!(value instanceof PsiReferenceExpression) || !((PsiReferenceExpression)value).isReferenceTo((PsiElement)field)) continue;
            return true;
        }
        return false;
    }

    public static String[] getApplicableElementTypeFields(PsiElement owner) {
        if (owner instanceof PsiClass) {
            PsiClass aClass = (PsiClass)owner;
            if (aClass.isAnnotationType()) {
                return new String[]{"ANNOTATION_TYPE", "TYPE"};
            }
            if (aClass instanceof PsiTypeParameter) {
                return new String[]{"TYPE_PARAMETER"};
            }
            return new String[]{"TYPE"};
        }
        if (owner instanceof PsiMethod) {
            if (((PsiMethod)owner).isConstructor()) {
                return new String[]{"CONSTRUCTOR"};
            }
            return new String[]{"METHOD"};
        }
        if (owner instanceof PsiField) {
            return new String[]{"FIELD"};
        }
        if (owner instanceof PsiParameter) {
            return new String[]{"PARAMETER"};
        }
        if (owner instanceof PsiLocalVariable) {
            return new String[]{"LOCAL_VARIABLE"};
        }
        if (owner instanceof PsiPackageStatement) {
            return new String[]{"PACKAGE"};
        }
        if (owner instanceof PsiTypeElement) {
            return new String[]{"TYPE_USE"};
        }
        return null;
    }

    private static PsiField[] getFields(PsiClass elementTypeClass, String ... names) {
        PsiField[] result = new PsiField[names.length];
        for (int i = 0; i < names.length; ++i) {
            PsiField field = elementTypeClass.findFieldByName(names[i], false);
            if (field == null) {
                return null;
            }
            result[i] = field;
        }
        return result;
    }

    public static HighlightInfo checkAnnotationType(PsiAnnotation annotation) {
        PsiElement resolved;
        PsiJavaCodeReferenceElement nameReferenceElement = annotation.getNameReferenceElement();
        if (!(nameReferenceElement == null || (resolved = nameReferenceElement.resolve()) instanceof PsiClass && ((PsiClass)resolved).isAnnotationType())) {
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)nameReferenceElement, JavaErrorMessages.message("annotation.annotation.type.expected", new Object[0]));
        }
        return null;
    }

    public static HighlightInfo checkCyclicMemberType(PsiTypeElement typeElement, PsiClass aClass) {
        LOG.assertTrue(aClass.isAnnotationType());
        PsiType type = typeElement.getType();
        if (type instanceof PsiClassType && ((PsiClassType)type).resolve() == aClass) {
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)typeElement, JavaErrorMessages.message("annotation.cyclic.element.type", new Object[0]));
        }
        return null;
    }

    public static HighlightInfo checkAnnotationDeclaration(PsiElement parent, PsiReferenceList list) {
        if (parent instanceof PsiAnnotationMethod) {
            PsiAnnotationMethod method = (PsiAnnotationMethod)parent;
            if (list == method.getThrowsList()) {
                return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)list, JavaErrorMessages.message("annotation.members.may.not.have.throws.list", new Object[0]));
            }
        } else if (parent instanceof PsiClass && ((PsiClass)parent).isAnnotationType() && "extends".equals(list.getFirstChild().getText())) {
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)list, JavaErrorMessages.message("annotation.may.not.have.extends.list", new Object[0]));
        }
        return null;
    }

    public static HighlightInfo checkPackageAnnotationContainingFile(PsiPackageStatement statement) {
        if (statement.getAnnotationList() == null) {
            return null;
        }
        PsiFile file = statement.getContainingFile();
        if (file != null && !PACKAGE_INFO_JAVA.equals(file.getName())) {
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, statement.getAnnotationList().getTextRange(), JavaErrorMessages.message("invalid.package.annotation.containing.file", new Object[0]));
        }
        return null;
    }

    public static HighlightInfo checkTargetAnnotationDuplicates(PsiAnnotation annotation) {
        PsiJavaCodeReferenceElement nameRef = annotation.getNameReferenceElement();
        if (nameRef == null) {
            return null;
        }
        PsiElement resolved = nameRef.resolve();
        if (!(resolved instanceof PsiClass) || !"java.lang.annotation.Target".equals(((PsiClass)resolved).getQualifiedName())) {
            return null;
        }
        PsiNameValuePair[] attributes = annotation.getParameterList().getAttributes();
        if (attributes.length < 1) {
            return null;
        }
        PsiAnnotationMemberValue value = attributes[0].getValue();
        if (!(value instanceof PsiArrayInitializerMemberValue)) {
            return null;
        }
        PsiAnnotationMemberValue[] arrayInitializers = ((PsiArrayInitializerMemberValue)value).getInitializers();
        HashSet targets = new HashSet();
        for (PsiAnnotationMemberValue initializer : arrayInitializers) {
            PsiElement target;
            if (!(initializer instanceof PsiReferenceExpression) || (target = ((PsiReferenceExpression)initializer).resolve()) == null) continue;
            if (targets.contains(target)) {
                return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)initializer, JavaErrorMessages.message("repeated.annotation.target", new Object[0]));
            }
            targets.add(target);
        }
        return null;
    }

    private static class AnnotationReturnTypeVisitor
    extends PsiTypeVisitor<Boolean> {
        private static final AnnotationReturnTypeVisitor INSTANCE = new AnnotationReturnTypeVisitor();

        private AnnotationReturnTypeVisitor() {
        }

        public Boolean visitType(PsiType type) {
            return Boolean.FALSE;
        }

        public Boolean visitPrimitiveType(PsiPrimitiveType primitiveType) {
            return PsiType.VOID.equals(primitiveType) || PsiType.NULL.equals(primitiveType) ? Boolean.FALSE : Boolean.TRUE;
        }

        public Boolean visitArrayType(PsiArrayType arrayType) {
            if (arrayType.getArrayDimensions() != 1) {
                return Boolean.FALSE;
            }
            PsiType componentType = arrayType.getComponentType();
            return (Boolean)componentType.accept((PsiTypeVisitor)this);
        }

        public Boolean visitClassType(PsiClassType classType) {
            if (classType.getParameters().length > 0) {
                PsiClassType rawType = classType.rawType();
                if (rawType.equalsToText("java.lang.Class")) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            PsiClass aClass = classType.resolve();
            if (aClass != null && (aClass.isAnnotationType() || aClass.isEnum())) {
                return Boolean.TRUE;
            }
            return classType.equalsToText("java.lang.Class") || classType.equalsToText("java.lang.String") ? Boolean.TRUE : Boolean.FALSE;
        }
    }
}

