/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressManager;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.storage.ClasspathStorage;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.jsp.jspJava.JspHolderMethod;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddSuppressInspectionFix
extends SuppressIntentionAction {
    private String myID;
    private String myAlternativeID;
    private String myKey;

    public AddSuppressInspectionFix(HighlightDisplayKey key) {
        this(key.getID());
        this.myAlternativeID = HighlightDisplayKey.getAlternativeID((HighlightDisplayKey)key);
    }

    public AddSuppressInspectionFix(String ID2) {
        this.myID = ID2;
    }

    @NotNull
    public String getText() {
        String string = this.myKey != null ? InspectionsBundle.message((String)this.myKey, (Object[])new Object[0]) : "Suppress for member";
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/actions/AddSuppressInspectionFix.getText must not return null");
        }
        return string;
    }

    @Nullable
    protected PsiDocCommentOwner getContainer(PsiElement context) {
        if (context == null || !(context.getContainingFile().getLanguage() instanceof JavaLanguage) || context instanceof PsiFile) {
            return null;
        }
        PsiElement container = context;
        while (container instanceof PsiAnonymousClass || !(container instanceof PsiDocCommentOwner) || container instanceof PsiTypeParameter) {
            if ((container = PsiTreeUtil.getParentOfType((PsiElement)container, PsiDocCommentOwner.class)) != null) continue;
            return null;
        }
        return (PsiDocCommentOwner)container;
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionsBundle.message((String)"suppress.inspection.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/actions/AddSuppressInspectionFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @Nullable PsiElement context) {
        boolean isValid;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/actions/AddSuppressInspectionFix.isAvailable must not be null");
        }
        PsiDocCommentOwner container = this.getContainer(context);
        this.myKey = container instanceof PsiClass ? "suppress.inspection.class" : (container instanceof PsiMethod ? "suppress.inspection.method" : "suppress.inspection.field");
        boolean bl = isValid = container != null && !(container instanceof JspHolderMethod);
        if (!isValid) {
            return false;
        }
        return context != null && context.getManager().isInProject(context);
    }

    public void invoke(Project project, Editor editor, PsiElement element) throws IncorrectOperationException {
        PsiDocCommentOwner container = this.getContainer(element);
        assert (container != null);
        ReadonlyStatusHandler.OperationStatus status = ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(new VirtualFile[]{container.getContainingFile().getVirtualFile()});
        if (status.hasReadonlyFiles()) {
            return;
        }
        if (this.use15Suppressions(container)) {
            PsiModifierList modifierList = container.getModifierList();
            if (modifierList != null) {
                AddSuppressInspectionFix.addSuppressAnnotation(project, editor, (PsiElement)container, modifierList, this.getID((PsiElement)container));
            }
        } else {
            PsiDocComment docComment = container.getDocComment();
            PsiManager manager = PsiManager.getInstance((Project)project);
            if (docComment == null) {
                String commentText = "/** @noinspection " + this.getID((PsiElement)container) + "*/";
                docComment = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createDocCommentFromText(commentText, null);
                PsiElement firstChild = container.getFirstChild();
                container.addBefore((PsiElement)docComment, firstChild);
            } else {
                PsiDocTag noInspectionTag = docComment.findTagByName("noinspection");
                if (noInspectionTag != null) {
                    PsiDocTagValue valueElement = noInspectionTag.getValueElement();
                    String tagText = "@noinspection " + (valueElement != null ? valueElement.getText() + "," : "") + this.getID((PsiElement)container);
                    noInspectionTag.replace((PsiElement)JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createDocTagFromText(tagText, null));
                } else {
                    String tagText = "@noinspection " + this.getID((PsiElement)container);
                    docComment.add((PsiElement)JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createDocTagFromText(tagText, null));
                }
            }
        }
        DaemonCodeAnalyzer.getInstance((Project)project).restart();
    }

    public static void addSuppressAnnotation(Project project, Editor editor, PsiElement container, PsiModifierList modifierList, String id) throws IncorrectOperationException {
        PsiAnnotation annotation = modifierList.findAnnotation("java.lang.SuppressWarnings");
        if (annotation != null) {
            if (annotation.getText().indexOf("{") == -1) {
                PsiNameValuePair[] attributes = annotation.getParameterList().getAttributes();
                if (attributes.length == 1) {
                    String suppressedWarnings = attributes[0].getText();
                    PsiAnnotation newAnnotation = JavaPsiFacade.getInstance((Project)project).getElementFactory().createAnnotationFromText("@java.lang.SuppressWarnings({" + suppressedWarnings + ", \"" + id + "\"})", container);
                    annotation.replace((PsiElement)newAnnotation);
                }
            } else {
                int curlyBraceIndex = annotation.getText().lastIndexOf("}");
                if (curlyBraceIndex > 0) {
                    annotation.replace((PsiElement)JavaPsiFacade.getInstance((Project)project).getElementFactory().createAnnotationFromText(annotation.getText().substring(0, curlyBraceIndex) + ", \"" + id + "\"})", container));
                } else if (!ApplicationManager.getApplication().isUnitTestMode() && editor != null) {
                    Messages.showErrorDialog((Component)editor.getComponent(), (String)InspectionsBundle.message((String)"suppress.inspection.annotation.syntax.error", (Object[])new Object[]{annotation.getText()}));
                }
            }
        } else {
            annotation = JavaPsiFacade.getInstance((Project)project).getElementFactory().createAnnotationFromText("@java.lang.SuppressWarnings({\"" + id + "\"})", container);
            modifierList.addBefore((PsiElement)annotation, modifierList.getFirstChild());
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)modifierList);
        }
    }

    protected boolean use15Suppressions(PsiDocCommentOwner container) {
        return SuppressManager.getInstance().canHave15Suppressions((PsiElement)container) && !SuppressManager.getInstance().alreadyHas14Suppressions(container);
    }

    public boolean startInWriteAction() {
        return true;
    }

    public String getID(PsiElement place) {
        Module module;
        if (this.myAlternativeID != null && (module = ModuleUtil.findModuleForPsiElement((PsiElement)place)) != null && !ClasspathStorage.getStorageType(module).equals("default")) {
            return this.myAlternativeID;
        }
        return this.myID;
    }
}

