/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.impl.GutterIconTooltipHelper;
import com.intellij.codeInsight.daemon.impl.LineMarkerNavigator;
import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.ide.util.MethodCellRenderer;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JComponent;

public enum MarkerType {
    OVERRIDING_METHOD((Function<? super PsiElement, String>)new NullableFunction<PsiElement, String>(){

        public String fun(PsiElement element) {
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiMethod)) {
                return null;
            }
            PsiMethod method = (PsiMethod)parent;
            PsiMethod[] superMethods = method.findSuperMethods(false);
            if (superMethods.length == 0) {
                return null;
            }
            PsiMethod superMethod = superMethods[0];
            boolean isAbstract = method.hasModifierProperty("abstract");
            boolean isSuperAbstract = superMethod.hasModifierProperty("abstract");
            boolean sameSignature = superMethod.getSignature(PsiSubstitutor.EMPTY).equals(method.getSignature(PsiSubstitutor.EMPTY));
            String key = isSuperAbstract && !isAbstract ? (sameSignature ? "method.implements" : "method.implements.in") : (sameSignature ? "method.overrides" : "method.overrides.in");
            return GutterIconTooltipHelper.composeText((PsiElement[])superMethods, "", DaemonBundle.message((String)key, (Object[])new Object[0]));
        }
    }, new LineMarkerNavigator(){

        @Override
        public void browse(MouseEvent e, PsiElement element) {
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiMethod)) {
                return;
            }
            PsiMethod method = (PsiMethod)parent;
            PsiMethod[] superMethods = method.findSuperMethods(false);
            if (superMethods.length == 0) {
                return;
            }
            boolean showMethodNames = !PsiUtil.allMethodsHaveSameSignature((PsiMethod[])superMethods);
            PsiElementListNavigator.openTargets(e, (NavigatablePsiElement[])superMethods, DaemonBundle.message((String)"navigation.title.super.method", (Object[])new Object[]{method.getName()}), new MethodCellRenderer(showMethodNames));
        }
    }),
    OVERRIDEN_METHOD((Function<? super PsiElement, String>)new NullableFunction<PsiElement, String>(){

        public String fun(PsiElement element) {
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiMethod)) {
                return null;
            }
            PsiMethod method = (PsiMethod)parent;
            PsiElementProcessor.CollectElementsWithLimit processor = new PsiElementProcessor.CollectElementsWithLimit(5);
            OverridingMethodsSearch.search((PsiMethod)method, (SearchScope)method.getUseScope(), (boolean)true).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)processor));
            boolean isAbstract = method.hasModifierProperty("abstract");
            if (processor.isOverflow()) {
                return isAbstract ? DaemonBundle.message((String)"method.is.implemented.too.many", (Object[])new Object[0]) : DaemonBundle.message((String)"method.is.overridden.too.many", (Object[])new Object[0]);
            }
            PsiMethod[] overridings = (PsiMethod[])processor.toArray((PsiElement[])new PsiMethod[processor.getCollection().size()]);
            if (overridings.length == 0) {
                return null;
            }
            Comparator comparator = new MethodCellRenderer(false).getComparator();
            Arrays.sort(overridings, comparator);
            String start = isAbstract ? DaemonBundle.message((String)"method.is.implemented.header", (Object[])new Object[0]) : DaemonBundle.message((String)"method.is.overriden.header", (Object[])new Object[0]);
            String pattern = "&nbsp;&nbsp;&nbsp;&nbsp;{1}";
            return GutterIconTooltipHelper.composeText((PsiElement[])overridings, start, pattern);
        }
    }, new LineMarkerNavigator(){

        @Override
        public void browse(MouseEvent e, PsiElement element) {
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiMethod)) {
                return;
            }
            final PsiMethod method = (PsiMethod)parent;
            final CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor();
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    OverridingMethodsSearch.search((PsiMethod)method, (SearchScope)method.getUseScope(), (boolean)true).forEach((Processor)collectProcessor);
                }
            }, "Searching for overridding methods", true, method.getProject(), (JComponent)e.getComponent())) {
                return;
            }
            PsiMethod[] overridings = (PsiMethod[])collectProcessor.toArray((Object[])PsiMethod.EMPTY_ARRAY);
            if (overridings.length == 0) {
                return;
            }
            String title = method.hasModifierProperty("abstract") ? DaemonBundle.message((String)"navigation.title.implementation.method", (Object[])new Object[]{method.getName(), overridings.length}) : DaemonBundle.message((String)"navigation.title.overrider.method", (Object[])new Object[]{method.getName(), overridings.length});
            boolean showMethodNames = !PsiUtil.allMethodsHaveSameSignature((PsiMethod[])overridings);
            MethodCellRenderer renderer = new MethodCellRenderer(showMethodNames);
            Arrays.sort(overridings, renderer.getComparator());
            PsiElementListNavigator.openTargets(e, (NavigatablePsiElement[])overridings, title, renderer);
        }
    }),
    SUBCLASSED_CLASS((Function<? super PsiElement, String>)new NullableFunction<PsiElement, String>(){

        public String fun(PsiElement element) {
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiClass)) {
                return null;
            }
            PsiClass aClass = (PsiClass)parent;
            PsiElementProcessor.CollectElementsWithLimit processor = new PsiElementProcessor.CollectElementsWithLimit(5);
            ClassInheritorsSearch.search((PsiClass)aClass, (SearchScope)aClass.getUseScope(), (boolean)true).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)processor));
            if (processor.isOverflow()) {
                return aClass.isInterface() ? DaemonBundle.message((String)"interface.is.implemented.too.many", (Object[])new Object[0]) : DaemonBundle.message((String)"class.is.subclassed.too.many", (Object[])new Object[0]);
            }
            PsiClass[] subclasses = (PsiClass[])processor.toArray((PsiElement[])new PsiClass[processor.getCollection().size()]);
            if (subclasses.length == 0) {
                return null;
            }
            Comparator comparator = new PsiClassListCellRenderer().getComparator();
            Arrays.sort(subclasses, comparator);
            String start = aClass.isInterface() ? DaemonBundle.message((String)"interface.is.implemented.by.header", (Object[])new Object[0]) : DaemonBundle.message((String)"class.is.subclassed.by.header", (Object[])new Object[0]);
            String pattern = "&nbsp;&nbsp;&nbsp;&nbsp;{0}";
            return GutterIconTooltipHelper.composeText((PsiElement[])subclasses, start, pattern);
        }
    }, new LineMarkerNavigator(){

        @Override
        public void browse(MouseEvent e, PsiElement element) {
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiClass)) {
                return;
            }
            final PsiClass aClass = (PsiClass)parent;
            final CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor();
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    ClassInheritorsSearch.search((PsiClass)aClass, (SearchScope)aClass.getUseScope(), (boolean)true).forEach((Processor)collectProcessor);
                }
            }, "Searching for overridden methods", true, aClass.getProject(), (JComponent)e.getComponent())) {
                return;
            }
            PsiClass[] inheritors = (PsiClass[])collectProcessor.toArray((Object[])PsiClass.EMPTY_ARRAY);
            if (inheritors.length == 0) {
                return;
            }
            String title = aClass.isInterface() ? CodeInsightBundle.message((String)"goto.implementation.chooser.title", (Object[])new Object[]{aClass.getName(), inheritors.length}) : DaemonBundle.message((String)"navigation.title.subclass", (Object[])new Object[]{aClass.getName(), inheritors.length});
            PsiClassListCellRenderer renderer = new PsiClassListCellRenderer();
            Arrays.sort(inheritors, renderer.getComparator());
            PsiElementListNavigator.openTargets(e, (NavigatablePsiElement[])inheritors, title, renderer);
        }
    });

    private final GutterIconNavigationHandler handler;
    private final Function<? super PsiElement, String> myTooltip;

    private MarkerType(Function<? super PsiElement, String> tooltip, final LineMarkerNavigator navigator) {
        this.myTooltip = tooltip;
        this.handler = new GutterIconNavigationHandler(){

            public void navigate(MouseEvent e, PsiElement elt) {
                navigator.browse(e, elt);
            }
        };
    }

    public <T extends PsiElement> GutterIconNavigationHandler<T> getNavigationHandler() {
        return this.handler;
    }

    public <T extends PsiElement> Function<T, String> getTooltip() {
        return this.myTooltip;
    }
}

