/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.IndentGuideDescriptor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.IntStack;
import com.intellij.util.text.CharArrayUtil;
import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class IndentsPass
extends TextEditorHighlightingPass
implements DumbAware {
    private static final Key<List<RangeHighlighter>> INDENT_HIGHLIGHTERS_IN_EDITOR_KEY = Key.create((String)"INDENT_HIGHLIGHTERS_IN_EDITOR_KEY");
    private static final Key<Long> LAST_TIME_INDENTS_BUILT = Key.create((String)"LAST_TIME_INDENTS_BUILT");
    private final EditorEx myEditor;
    private final PsiFile myFile;
    public static final Comparator<TextRange> RANGE_COMPARATOR = new Comparator<TextRange>(){

        @Override
        public int compare(TextRange o1, TextRange o2) {
            if (o1.getStartOffset() == o2.getStartOffset()) {
                return o1.getEndOffset() - o2.getEndOffset();
            }
            return o1.getStartOffset() - o2.getStartOffset();
        }
    };
    private static final CustomHighlighterRenderer RENDERER = new CustomHighlighterRenderer(){

        public void paint(Editor editor, RangeHighlighter highlighter, Graphics g) {
            CaretModel caretModel;
            int caretOffset;
            int off;
            Document doc;
            int startOffset = highlighter.getStartOffset();
            if (startOffset >= (doc = highlighter.getDocument()).getTextLength()) {
                return;
            }
            int startLine = doc.getLineNumber(startOffset);
            do {
                int pos = doc.getLineStartOffset(startLine);
                off = CharArrayUtil.shiftForward((CharSequence)doc.getCharsSequence(), (int)pos, (String)" \t");
            } while (--startLine > 1 && doc.getCharsSequence().charAt(off) == '\n');
            VisualPosition startPosition = editor.offsetToVisualPosition(off);
            if (startPosition.column <= 0) {
                return;
            }
            FoldingModel foldingModel = editor.getFoldingModel();
            if (foldingModel.isOffsetCollapsed(off)) {
                return;
            }
            int endOffset = highlighter.getEndOffset();
            FoldRegion headerRegion = foldingModel.getCollapsedRegionAtOffset(doc.getLineEndOffset(doc.getLineNumber(off)));
            FoldRegion tailRegion = foldingModel.getCollapsedRegionAtOffset(doc.getLineStartOffset(doc.getLineNumber(endOffset)));
            if (tailRegion != null && tailRegion == headerRegion) {
                return;
            }
            IndentGuideDescriptor guide = editor.getIndentsModel().getCaretIndentGuide();
            boolean selected = guide != null ? (caretOffset = (caretModel = editor.getCaretModel()).getOffset()) >= off && caretOffset < endOffset && caretModel.getLogicalPosition().column == startPosition.column : false;
            Point start = editor.visualPositionToXY(new VisualPosition(startPosition.line + 1, startPosition.column));
            VisualPosition endPosition = editor.offsetToVisualPosition(endOffset);
            Point end = editor.visualPositionToXY(new VisualPosition(endPosition.line, endPosition.column));
            EditorColorsScheme scheme = editor.getColorsScheme();
            g.setColor(selected ? scheme.getColor(EditorColors.SELECTED_INDENT_GUIDE_COLOR) : scheme.getColor(EditorColors.INDENT_GUIDE_COLOR));
            g.drawLine(start.x + 2, start.y, start.x + 2, end.y);
        }
    };

    public IndentsPass(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/IndentsPass.<init> must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/IndentsPass.<init> must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/IndentsPass.<init> must not be null");
        }
        super(project, editor.getDocument(), false);
        this.myEditor = (EditorEx)editor;
        this.myFile = file;
    }

    @Override
    public void doCollectInformation(ProgressIndicator progress) {
    }

    private long nowStamp() {
        if (!this.myEditor.getSettings().isIndentGuidesShown()) {
            return -1L;
        }
        return this.myDocument.getModificationStamp();
    }

    @Override
    public void doApplyInformationToEditor() {
        Long stamp = (Long)this.myEditor.getUserData(LAST_TIME_INDENTS_BUILT);
        if (stamp != null && stamp.longValue() == this.nowStamp()) {
            return;
        }
        List<IndentGuideDescriptor> descriptors = this.buildDescriptors();
        ArrayList<TextRange> ranges = new ArrayList<TextRange>();
        for (IndentGuideDescriptor descriptor : descriptors) {
            int endOffset = descriptor.endLine < this.myDocument.getLineCount() ? this.myDocument.getLineStartOffset(descriptor.endLine) : this.myDocument.getTextLength();
            ranges.add(new TextRange(this.myDocument.getLineStartOffset(descriptor.startLine), endOffset));
        }
        Collections.sort(ranges, RANGE_COMPARATOR);
        List oldHighlighters = (List)this.myEditor.getUserData(INDENT_HIGHLIGHTERS_IN_EDITOR_KEY);
        ArrayList<RangeHighlighter> newHighlighters = new ArrayList<RangeHighlighter>();
        MarkupModel mm = this.myEditor.getMarkupModel();
        int curRange = 0;
        if (oldHighlighters != null) {
            int curHighlight = 0;
            while (curRange < ranges.size() && curHighlight < oldHighlighters.size()) {
                RangeHighlighter highlighter;
                TextRange range = (TextRange)ranges.get(curRange);
                int cmp = IndentsPass.compare(range, highlighter = (RangeHighlighter)oldHighlighters.get(curHighlight));
                if (cmp < 0) {
                    newHighlighters.add(IndentsPass.createHighlighter(mm, range));
                    ++curRange;
                    continue;
                }
                if (cmp > 0) {
                    mm.removeHighlighter(highlighter);
                    ++curHighlight;
                    continue;
                }
                newHighlighters.add(highlighter);
                ++curHighlight;
                ++curRange;
            }
            while (curHighlight < oldHighlighters.size()) {
                mm.removeHighlighter((RangeHighlighter)oldHighlighters.get(curHighlight));
                ++curHighlight;
            }
        }
        while (curRange < ranges.size()) {
            newHighlighters.add(IndentsPass.createHighlighter(mm, (TextRange)ranges.get(curRange)));
            ++curRange;
        }
        this.myEditor.putUserData(INDENT_HIGHLIGHTERS_IN_EDITOR_KEY, newHighlighters);
        this.myEditor.putUserData(LAST_TIME_INDENTS_BUILT, this.nowStamp());
        this.myEditor.getIndentsModel().assumeIndents(descriptors);
    }

    private List<IndentGuideDescriptor> buildDescriptors() {
        if (!this.myEditor.getSettings().isIndentGuidesShown()) {
            return Collections.emptyList();
        }
        int[] lineIndents = this.calcIndents();
        ArrayList<IndentGuideDescriptor> descriptors = new ArrayList<IndentGuideDescriptor>();
        IntStack lines = new IntStack();
        IntStack indents = new IntStack();
        lines.push(0);
        indents.push(0);
        CharSequence chars = this.myDocument.getCharsSequence();
        for (int line = 1; line < lineIndents.length; ++line) {
            int curIndent = lineIndents[line];
            while (!indents.empty() && curIndent <= indents.peek()) {
                int level = indents.pop();
                int startLine = lines.pop();
                descriptors.add(this.createDescriptor(level, startLine, line, chars));
            }
            int prevLine = line - 1;
            int prevIndent = lineIndents[prevLine];
            if (curIndent - prevIndent <= 1) continue;
            lines.push(prevLine);
            indents.push(prevIndent);
        }
        while (!indents.empty()) {
            int level = indents.pop();
            if (level <= 0) continue;
            int startLine = lines.pop();
            descriptors.add(this.createDescriptor(level, startLine, this.myDocument.getLineCount(), chars));
        }
        return descriptors;
    }

    private IndentGuideDescriptor createDescriptor(int level, int startLine, int endLine, CharSequence chars) {
        while (startLine > 0 && this.isBlankLine(startLine, chars)) {
            --startLine;
        }
        return new IndentGuideDescriptor(level, startLine, endLine);
    }

    private boolean isBlankLine(int line, CharSequence chars) {
        int startOffset = this.myDocument.getLineStartOffset(line);
        return CharArrayUtil.shiftForward((CharSequence)chars, (int)startOffset, (String)" \t") >= this.myDocument.getLineEndOffset(line);
    }

    private int[] calcIndents() {
        Document doc = this.myDocument;
        CharSequence chars = doc.getCharsSequence();
        int[] lineIndents = new int[doc.getLineCount()];
        TokenSet comments = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(this.myFile.getLanguage())).getCommentTokens();
        int prevColumn = -1;
        EditorHighlighter highlighter = this.myEditor.getHighlighter();
        for (int line = 0; line < lineIndents.length; ++line) {
            int lineStart = doc.getLineStartOffset(line);
            int lineEnd = doc.getLineEndOffset(line);
            int nonWhitespaceOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)lineStart, (String)" \t");
            if (nonWhitespaceOffset < lineEnd) {
                HighlighterIterator it;
                int column = this.myEditor.calcColumnNumber(nonWhitespaceOffset, line);
                if (column < prevColumn && comments.contains((it = highlighter.createIterator(nonWhitespaceOffset)).getTokenType())) {
                    lineIndents[line] = -1;
                    continue;
                }
                lineIndents[line] = column;
                prevColumn = column;
                continue;
            }
            lineIndents[line] = -1;
        }
        int topIndent = 0;
        for (int line = 0; line < lineIndents.length; ++line) {
            int nonWhitespaceOffset;
            HighlighterIterator iterator;
            if (lineIndents[line] >= 0) {
                topIndent = lineIndents[line];
                continue;
            }
            int startLine = line;
            while (line < lineIndents.length && lineIndents[line] == -1) {
                ++line;
            }
            int bottomIndent = line < lineIndents.length ? lineIndents[line] : topIndent;
            int indent = Math.min(topIndent, bottomIndent);
            if (bottomIndent < topIndent && BraceMatchingUtil.isRBraceToken(iterator = highlighter.createIterator(nonWhitespaceOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)doc.getLineStartOffset(line), (String)" \t")), chars, this.myFile.getFileType())) {
                indent = topIndent;
            }
            for (int blankLine = startLine; blankLine < line; ++blankLine) {
                assert (lineIndents[blankLine] == -1);
                lineIndents[blankLine] = Math.min(topIndent, indent);
            }
            --line;
        }
        return lineIndents;
    }

    private static RangeHighlighter createHighlighter(MarkupModel mm, TextRange range) {
        RangeHighlighter highlighter = mm.addRangeHighlighter(range.getStartOffset(), range.getEndOffset(), 0, null, HighlighterTargetArea.EXACT_RANGE);
        highlighter.setCustomRenderer(RENDERER);
        return highlighter;
    }

    private static int compare(TextRange r, RangeHighlighter h) {
        int answer = r.getStartOffset() - h.getStartOffset();
        return answer != 0 ? answer : r.getEndOffset() - h.getEndOffset();
    }
}

