/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInspection.CustomSuppressableInspectionTool;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.actions.CleanupInspectionIntention;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightInfo {
    public static final HighlightInfo[] EMPTY_ARRAY = new HighlightInfo[0];
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.HighlightInfo");
    private final boolean myNeedsUpdateOnTyping;
    public JComponent fileLevelComponent;
    public final TextAttributes forcedTextAttributes;
    public final HighlightInfoType type;
    public int group;
    public final int startOffset;
    public final int endOffset;
    public int fixStartOffset;
    public int fixEndOffset;
    public RangeMarker fixMarker;
    public final String description;
    public final String toolTip;
    public final HighlightSeverity severity;
    public final boolean isAfterEndOfLine;
    public final boolean isFileLevelAnnotation;
    public int navigationShift;
    public RangeHighlighterEx highlighter;
    public String text;
    public List<Pair<IntentionActionDescriptor, TextRange>> quickFixActionRanges;
    public List<Pair<IntentionActionDescriptor, RangeMarker>> quickFixActionMarkers;
    private boolean hasHint;
    private GutterIconRenderer gutterIconRenderer;

    public HighlightSeverity getSeverity() {
        return this.severity;
    }

    public TextAttributes getTextAttributes(PsiElement element) {
        return this.forcedTextAttributes == null ? HighlightInfo.getAttributesByType(element, this.type) : this.forcedTextAttributes;
    }

    public static TextAttributes getAttributesByType(@Nullable PsiElement element, @NotNull HighlightInfoType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/HighlightInfo.getAttributesByType must not be null");
        }
        TextAttributes textAttributes = SeverityRegistrar.getInstance(element != null ? element.getProject() : null).getTextAttributesBySeverity(type.getSeverity(element));
        if (textAttributes != null) {
            return textAttributes;
        }
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        TextAttributesKey key = type.getAttributesKey();
        return scheme.getAttributes(key);
    }

    @Nullable
    public Color getErrorStripeMarkColor(PsiElement element) {
        if (this.forcedTextAttributes != null && this.forcedTextAttributes.getErrorStripeColor() != null) {
            return this.forcedTextAttributes.getErrorStripeColor();
        }
        if (this.severity == HighlightSeverity.ERROR) {
            return EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.ERRORS_ATTRIBUTES).getErrorStripeColor();
        }
        if (this.severity == HighlightSeverity.WARNING) {
            return EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.WARNINGS_ATTRIBUTES).getErrorStripeColor();
        }
        if (this.severity == HighlightSeverity.INFO) {
            return EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.INFO_ATTRIBUTES).getErrorStripeColor();
        }
        if (this.severity == HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING) {
            return EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.GENERIC_SERVER_ERROR_OR_WARNING).getErrorStripeColor();
        }
        TextAttributes attributes = HighlightInfo.getAttributesByType(element, this.type);
        return attributes == null ? null : attributes.getErrorStripeColor();
    }

    public static HighlightInfo createHighlightInfo(@NotNull HighlightInfoType type, @NotNull PsiElement element, String description) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/HighlightInfo.createHighlightInfo must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/HighlightInfo.createHighlightInfo must not be null");
        }
        return HighlightInfo.createHighlightInfo(type, element, description, HighlightInfo.htmlEscapeToolTip(description));
    }

    @Nullable
    @NonNls
    public static String htmlEscapeToolTip(String description) {
        return description == null ? null : "<html><body>" + XmlStringUtil.escapeString((String)description) + "</body></html>";
    }

    public static HighlightInfo createHighlightInfo(@NotNull HighlightInfoType type, @NotNull PsiElement element, String description, String toolTip) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/HighlightInfo.createHighlightInfo must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/HighlightInfo.createHighlightInfo must not be null");
        }
        TextRange range = element.getTextRange();
        int start = range.getStartOffset();
        int end = range.getEndOffset();
        return HighlightInfo.createHighlightInfo(type, element, start, end, description, toolTip);
    }

    public static HighlightInfo createHighlightInfo(@NotNull HighlightInfoType type, @Nullable PsiElement element, int start, int end, String description, String toolTip, boolean isEndOfLine, TextAttributes forcedAttributes) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/HighlightInfo.createHighlightInfo must not be null");
        }
        LOG.assertTrue(ArrayUtil.find((Object[])HighlightSeverity.DEFAULT_SEVERITIES, (Object)type.getSeverity(element)) != -1 || element != null, (Object)"Custom type demands element to detect text attributes");
        HighlightInfo highlightInfo = new HighlightInfo(forcedAttributes, type, start, end, description, toolTip, type.getSeverity(null), isEndOfLine, null, false);
        for (HighlightInfoFilter filter : HighlightInfo.getFilters()) {
            if (filter.accept(highlightInfo, element != null ? element.getContainingFile() : null)) continue;
            return null;
        }
        return highlightInfo;
    }

    public static HighlightInfo createHighlightInfo(@NotNull HighlightInfoType type, @Nullable PsiElement element, int start, int end, String description, String toolTip) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/HighlightInfo.createHighlightInfo must not be null");
        }
        return HighlightInfo.createHighlightInfo(type, element, start, end, description, toolTip, false, null);
    }

    @NotNull
    private static HighlightInfoFilter[] getFilters() {
        HighlightInfoFilter[] highlightInfoFilterArray = (HighlightInfoFilter[])ApplicationManager.getApplication().getExtensions(HighlightInfoFilter.EXTENSION_POINT_NAME);
        if (highlightInfoFilterArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/HighlightInfo.getFilters must not return null");
        }
        return highlightInfoFilterArray;
    }

    public static HighlightInfo createHighlightInfo(@NotNull HighlightInfoType type, int start, int end, String description) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/HighlightInfo.createHighlightInfo must not be null");
        }
        return HighlightInfo.createHighlightInfo(type, null, start, end, description, HighlightInfo.htmlEscapeToolTip(description));
    }

    public static HighlightInfo createHighlightInfo(@NotNull HighlightInfoType type, @NotNull TextRange textRange, String description) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/HighlightInfo.createHighlightInfo must not be null");
        }
        if (textRange == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/HighlightInfo.createHighlightInfo must not be null");
        }
        return HighlightInfo.createHighlightInfo(type, textRange.getStartOffset(), textRange.getEndOffset(), description);
    }

    public static HighlightInfo createHighlightInfo(@NotNull HighlightInfoType type, @NotNull TextRange textRange, String description, String toolTip, TextAttributes textAttributes) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/HighlightInfo.createHighlightInfo must not be null");
        }
        if (textRange == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/HighlightInfo.createHighlightInfo must not be null");
        }
        return new HighlightInfo(textAttributes, type, textRange.getStartOffset(), textRange.getEndOffset(), description, HighlightInfo.htmlEscapeToolTip(toolTip), type.getSeverity(null), false, null, false);
    }

    public boolean needUpdateOnTyping() {
        return this.myNeedsUpdateOnTyping;
    }

    public HighlightInfo(HighlightInfoType type, int startOffset, int endOffset, String description, String toolTip) {
        this(null, type, startOffset, endOffset, description, toolTip, type.getSeverity(null), false, null, false);
    }

    public HighlightInfo(@Nullable TextAttributes textAttributes, @NotNull HighlightInfoType type, int startOffset, int endOffset, @Nullable String description, @Nullable String toolTip, @NotNull HighlightSeverity severity, boolean afterEndOfLine, @Nullable Boolean needsUpdateOnTyping, boolean isFileLevelAnnotation) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/HighlightInfo.<init> must not be null");
        }
        if (severity == null) {
            throw new IllegalArgumentException("Argument 6 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/HighlightInfo.<init> must not be null");
        }
        this.navigationShift = 0;
        if (startOffset < 0 || startOffset > endOffset) {
            LOG.error("Incorrect highlightInfo bounds. description=" + description + "; startOffset=" + startOffset + "; endOffset=" + endOffset + ";type=" + type);
        }
        this.forcedTextAttributes = textAttributes;
        this.type = type;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.fixStartOffset = startOffset;
        this.fixEndOffset = endOffset;
        this.description = description;
        this.toolTip = toolTip;
        this.severity = severity;
        this.isAfterEndOfLine = afterEndOfLine;
        this.myNeedsUpdateOnTyping = HighlightInfo.calcNeedUpdateOnTyping(needsUpdateOnTyping, type);
        this.isFileLevelAnnotation = isFileLevelAnnotation;
    }

    private static boolean calcNeedUpdateOnTyping(Boolean needsUpdateOnTyping, HighlightInfoType type) {
        if (needsUpdateOnTyping != null) {
            return needsUpdateOnTyping;
        }
        if (type == HighlightInfoType.TODO) {
            return false;
        }
        if (type == HighlightInfoType.LOCAL_VARIABLE) {
            return false;
        }
        if (type == HighlightInfoType.INSTANCE_FIELD) {
            return false;
        }
        if (type == HighlightInfoType.STATIC_FIELD) {
            return false;
        }
        if (type == HighlightInfoType.PARAMETER) {
            return false;
        }
        if (type == HighlightInfoType.METHOD_CALL) {
            return false;
        }
        if (type == HighlightInfoType.METHOD_DECLARATION) {
            return false;
        }
        if (type == HighlightInfoType.STATIC_METHOD) {
            return false;
        }
        if (type == HighlightInfoType.CONSTRUCTOR_CALL) {
            return false;
        }
        if (type == HighlightInfoType.CONSTRUCTOR_DECLARATION) {
            return false;
        }
        if (type == HighlightInfoType.INTERFACE_NAME) {
            return false;
        }
        if (type == HighlightInfoType.ABSTRACT_CLASS_NAME) {
            return false;
        }
        return type != HighlightInfoType.CLASS_NAME;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HighlightInfo)) {
            return false;
        }
        HighlightInfo info = (HighlightInfo)obj;
        return info.getSeverity() == this.getSeverity() && info.startOffset == this.startOffset && info.endOffset == this.endOffset && Comparing.equal((Object)info.type, (Object)this.type) && Comparing.equal((Object)info.gutterIconRenderer, (Object)this.gutterIconRenderer) && Comparing.equal((Object)info.forcedTextAttributes, (Object)this.forcedTextAttributes) && Comparing.strEqual((String)info.description, (String)this.description);
    }

    public boolean equalsByActualOffset(HighlightInfo info) {
        if (info == this) {
            return true;
        }
        return info.getSeverity() == this.getSeverity() && info.getActualStartOffset() == this.getActualStartOffset() && info.getActualEndOffset() == this.getActualEndOffset() && Comparing.equal((Object)info.type, (Object)this.type) && Comparing.equal((Object)info.gutterIconRenderer, (Object)this.gutterIconRenderer) && Comparing.equal((Object)info.forcedTextAttributes, (Object)this.forcedTextAttributes) && Comparing.strEqual((String)info.description, (String)this.description);
    }

    public int hashCode() {
        return this.startOffset;
    }

    @NonNls
    public String toString() {
        String s = "HighlightInfo(" + this.startOffset + "," + this.endOffset + ")";
        if (this.getActualStartOffset() != this.startOffset || this.getActualEndOffset() != this.endOffset) {
            s = s + "; actual: (" + this.getActualStartOffset() + "," + this.getActualEndOffset() + ")";
        }
        if (this.text != null) {
            s = s + " text='" + this.text + "'";
        }
        if (this.description != null) {
            s = s + ", description='" + this.description + "'";
        }
        if (this.toolTip != null) {
            s = s + ", toolTip='" + this.toolTip + "'";
        }
        s = s + " severity=" + this.severity;
        return s;
    }

    public static HighlightInfo createHighlightInfo(@NotNull HighlightInfoType type, @NotNull ASTNode childByRole, String localizedMessage) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/HighlightInfo.createHighlightInfo must not be null");
        }
        if (childByRole == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/HighlightInfo.createHighlightInfo must not be null");
        }
        return HighlightInfo.createHighlightInfo(type, SourceTreeToPsiMap.treeElementToPsi(childByRole), localizedMessage);
    }

    public GutterIconRenderer getGutterIconRenderer() {
        return this.gutterIconRenderer;
    }

    public void setGutterIconRenderer(GutterIconRenderer gutterIconRenderer) {
        this.gutterIconRenderer = gutterIconRenderer;
    }

    public static HighlightInfo createHighlightInfo(@NotNull HighlightInfoType type, @NotNull PsiElement element, String message, TextAttributes attributes) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/HighlightInfo.createHighlightInfo must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/HighlightInfo.createHighlightInfo must not be null");
        }
        TextRange textRange = element.getTextRange();
        return new HighlightInfo(attributes, type, textRange.getStartOffset(), textRange.getEndOffset(), message, HighlightInfo.htmlEscapeToolTip(message), type.getSeverity(element), false, Boolean.FALSE, false);
    }

    public static HighlightInfo fromAnnotation(@NotNull Annotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/HighlightInfo.fromAnnotation must not be null");
        }
        return HighlightInfo.fromAnnotation(annotation, null);
    }

    public static HighlightInfo fromAnnotation(@NotNull Annotation annotation, @Nullable TextRange fixedRange) {
        if (annotation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/HighlightInfo.fromAnnotation must not be null");
        }
        TextAttributes attributes = annotation.getEnforcedTextAttributes();
        if (attributes == null) {
            attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(annotation.getTextAttributes());
        }
        HighlightInfo info = new HighlightInfo(attributes, HighlightInfo.convertType(annotation), fixedRange != null ? fixedRange.getStartOffset() : annotation.getStartOffset(), fixedRange != null ? fixedRange.getEndOffset() : annotation.getEndOffset(), annotation.getMessage(), annotation.getTooltip(), annotation.getSeverity(), annotation.isAfterEndOfLine(), annotation.needsUpdateOnTyping(), annotation.isFileLevelAnnotation());
        info.setGutterIconRenderer(annotation.getGutterIconRenderer());
        List fixes = annotation.getQuickFixes();
        if (fixes != null) {
            for (Annotation.QuickFixInfo quickFixInfo : fixes) {
                QuickFixAction.registerQuickFixAction(info, fixedRange != null ? fixedRange : quickFixInfo.textRange, quickFixInfo.quickFix, quickFixInfo.key);
            }
        }
        return info;
    }

    public static HighlightInfoType convertType(Annotation annotation) {
        ProblemHighlightType type = annotation.getHighlightType();
        if (type == ProblemHighlightType.LIKE_UNUSED_SYMBOL) {
            return HighlightInfoType.UNUSED_SYMBOL;
        }
        if (type == ProblemHighlightType.LIKE_UNKNOWN_SYMBOL) {
            return HighlightInfoType.WRONG_REF;
        }
        if (type == ProblemHighlightType.LIKE_DEPRECATED) {
            return HighlightInfoType.DEPRECATED;
        }
        return HighlightInfo.convertSeverity(annotation.getSeverity());
    }

    public static HighlightInfoType convertSeverity(HighlightSeverity severity) {
        return severity == HighlightSeverity.ERROR ? HighlightInfoType.ERROR : (severity == HighlightSeverity.WARNING ? HighlightInfoType.WARNING : (severity == HighlightSeverity.INFO ? HighlightInfoType.INFO : HighlightInfoType.INFORMATION));
    }

    public static ProblemHighlightType convertType(HighlightInfoType infoType) {
        if (infoType == HighlightInfoType.ERROR || infoType == HighlightInfoType.WRONG_REF) {
            return ProblemHighlightType.ERROR;
        }
        if (infoType == HighlightInfoType.WARNING) {
            return ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
        }
        if (infoType == HighlightInfoType.INFORMATION) {
            return ProblemHighlightType.INFORMATION;
        }
        return ProblemHighlightType.INFO;
    }

    public static ProblemHighlightType convertSeverityToProblemHighlight(HighlightSeverity severity) {
        return severity == HighlightSeverity.ERROR ? ProblemHighlightType.ERROR : (severity == HighlightSeverity.WARNING ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : (severity == HighlightSeverity.INFO ? ProblemHighlightType.INFO : ProblemHighlightType.INFORMATION));
    }

    public boolean hasHint() {
        return this.hasHint;
    }

    public void setHint(boolean hasHint) {
        this.hasHint = hasHint;
    }

    public int getActualStartOffset() {
        return this.highlighter == null ? this.startOffset : this.highlighter.getStartOffset();
    }

    public int getActualEndOffset() {
        return this.highlighter == null ? this.endOffset : this.highlighter.getEndOffset();
    }

    public static class IntentionActionDescriptor {
        private final IntentionAction myAction;
        private volatile List<IntentionAction> myOptions;
        private volatile HighlightDisplayKey myKey;
        private final String myDisplayName;
        private final Icon myIcon;

        public IntentionActionDescriptor(@NotNull IntentionAction action, HighlightDisplayKey key) {
            if (action == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/HighlightInfo$IntentionActionDescriptor.<init> must not be null");
            }
            this(action, null, HighlightDisplayKey.getDisplayNameByKey((HighlightDisplayKey)key), null);
            this.myKey = key;
        }

        public IntentionActionDescriptor(@NotNull IntentionAction action, List<IntentionAction> options, String displayName) {
            if (action == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/HighlightInfo$IntentionActionDescriptor.<init> must not be null");
            }
            this(action, options, displayName, null);
        }

        public IntentionActionDescriptor(@NotNull IntentionAction action, Icon icon) {
            if (action == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/HighlightInfo$IntentionActionDescriptor.<init> must not be null");
            }
            this(action, null, null, icon);
        }

        public IntentionActionDescriptor(@NotNull IntentionAction action, List<IntentionAction> options, String displayName, Icon icon) {
            if (action == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/HighlightInfo$IntentionActionDescriptor.<init> must not be null");
            }
            this.myAction = action;
            this.myOptions = options;
            this.myDisplayName = displayName;
            this.myIcon = icon;
        }

        @NotNull
        public IntentionAction getAction() {
            IntentionAction intentionAction = this.myAction;
            if (intentionAction == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/HighlightInfo$IntentionActionDescriptor.getAction must not return null");
            }
            return intentionAction;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public List<IntentionAction> getOptions(@NotNull PsiElement element) {
            HighlightDisplayKey idkey;
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/HighlightInfo$IntentionActionDescriptor.getOptions must not be null");
            }
            List options = this.myOptions;
            HighlightDisplayKey key = this.myKey;
            if (options != null || key == null) {
                return options;
            }
            List newOptions = IntentionManager.getInstance().getStandardIntentionOptions(key, element);
            InspectionProfile profile = InspectionProjectProfileManager.getInstance(element.getProject()).getInspectionProfile();
            InspectionProfileEntry tool = profile.getInspectionTool(key.toString(), element);
            if (!(tool instanceof LocalInspectionToolWrapper) && (idkey = HighlightDisplayKey.findById((String)key.toString())) != null) {
                tool = profile.getInspectionTool(idkey.toString(), element);
            }
            if (tool instanceof LocalInspectionToolWrapper) {
                SuppressIntentionAction[] suppressActions;
                LocalInspectionTool localInspectionTool = ((LocalInspectionToolWrapper)tool).getTool();
                Class<?> aClass = this.myAction.getClass();
                if (this.myAction instanceof QuickFixWrapper) {
                    aClass = ((QuickFixWrapper)this.myAction).getFix().getClass();
                }
                newOptions.add(new CleanupInspectionIntention(localInspectionTool, aClass));
                if (localInspectionTool instanceof CustomSuppressableInspectionTool && (suppressActions = ((CustomSuppressableInspectionTool)localInspectionTool).getSuppressActions(element)) != null) {
                    newOptions.addAll(Arrays.asList(suppressActions));
                }
            }
            IntentionActionDescriptor intentionActionDescriptor = this;
            synchronized (intentionActionDescriptor) {
                options = this.myOptions;
                if (options == null) {
                    this.myOptions = options = newOptions;
                }
                this.myKey = null;
            }
            return options;
        }

        public String getDisplayName() {
            return this.myDisplayName;
        }

        @NonNls
        public String toString() {
            return "descriptor: " + this.getAction().getText();
        }

        public Icon getIcon() {
            return this.myIcon;
        }
    }
}

