/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.ExportSchemeAction;
import com.intellij.application.options.SaveSchemeDialog;
import com.intellij.application.options.SchemesToImportPopup;
import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.ColorSettingsUtil;
import com.intellij.application.options.colors.FontOptions;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsManagerImpl;
import com.intellij.openapi.editor.colors.impl.EditorColorsSchemeImpl;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.util.EventDispatcher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class SchemesPanel
extends JPanel {
    private final ColorAndFontOptions myOptions;
    private JComboBox mySchemeComboBox;
    private JButton myDeleteButton;
    private JButton myExportButton;
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);
    private boolean myListLoaded = false;

    public SchemesPanel(ColorAndFontOptions options) {
        super(new BorderLayout());
        this.myOptions = options;
        JPanel schemesGroup = new JPanel(new BorderLayout());
        JPanel panel = new JPanel(new BorderLayout());
        schemesGroup.add((Component)this.createSchemePanel(), "North");
        schemesGroup.add((Component)panel, "Center");
        this.add((Component)schemesGroup, "Center");
        this.mySchemeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SchemesPanel.this.mySchemeComboBox.getSelectedIndex() != -1) {
                    EditorColorsScheme selected = SchemesPanel.this.myOptions.selectScheme((String)SchemesPanel.this.mySchemeComboBox.getSelectedItem());
                    if (ColorAndFontOptions.isReadOnly(selected)) {
                        SchemesPanel.this.myDeleteButton.setEnabled(false);
                        if (SchemesPanel.this.myExportButton != null) {
                            SchemesPanel.this.myExportButton.setEnabled(false);
                        }
                    } else if (ColorSettingsUtil.isSharedScheme(selected)) {
                        SchemesPanel.this.myDeleteButton.setEnabled(true);
                        if (SchemesPanel.this.myExportButton != null) {
                            SchemesPanel.this.myExportButton.setEnabled(false);
                        }
                    } else {
                        SchemesPanel.this.myDeleteButton.setEnabled(true);
                        if (SchemesPanel.this.myExportButton != null) {
                            SchemesPanel.this.myExportButton.setEnabled(true);
                        }
                    }
                    if (SchemesPanel.this.areSchemesLoaded()) {
                        ((ColorAndFontSettingsListener)SchemesPanel.this.myDispatcher.getMulticaster()).schemeChanged(SchemesPanel.this);
                    }
                }
            }
        });
    }

    public boolean areSchemesLoaded() {
        return this.myListLoaded;
    }

    public void clearSearch() {
    }

    @Nullable
    public static <T> T safeCast(Object obj, Class<T> expectedClass) {
        if (expectedClass.isInstance(obj)) {
            return (T)obj;
        }
        return null;
    }

    private JPanel createSchemePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(ApplicationBundle.message((String)"combobox.scheme.name", (Object[])new Object[0])), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.mySchemeComboBox = new JComboBox();
        panel.add((Component)this.mySchemeComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        JButton saveAsButton = new JButton(ApplicationBundle.message((String)"button.save.as", (Object[])new Object[0]));
        saveAsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemesPanel.this.showSaveAsDialog();
            }
        });
        panel.add((Component)saveAsButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.myDeleteButton = new JButton(ApplicationBundle.message((String)"button.delete", (Object[])new Object[0]));
        this.myDeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SchemesPanel.this.mySchemeComboBox.getSelectedIndex() != -1) {
                    SchemesPanel.this.myOptions.removeScheme((String)SchemesPanel.this.mySchemeComboBox.getSelectedItem());
                }
            }
        });
        panel.add((Component)this.myDeleteButton, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        SchemesManager<EditorColorsScheme, EditorColorsSchemeImpl> schemesManager = ((EditorColorsManagerImpl)EditorColorsManager.getInstance()).getSchemesManager();
        if (schemesManager.isExportAvailable()) {
            this.myExportButton = new JButton("Share...");
            this.myExportButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditorColorsScheme selected = SchemesPanel.this.myOptions.getOriginalSelectedScheme();
                    ExportSchemeAction.doExport((EditorColorsSchemeImpl)selected, ((EditorColorsManagerImpl)EditorColorsManager.getInstance()).getSchemesManager());
                }
            });
            panel.add((Component)this.myExportButton, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
            this.myExportButton.setMnemonic('S');
        }
        if (schemesManager.isImportAvailable()) {
            JButton myImportButton = new JButton("Import Shared...");
            myImportButton.setMnemonic('I');
            myImportButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SchemesToImportPopup<EditorColorsScheme, EditorColorsSchemeImpl> popup = new SchemesToImportPopup<EditorColorsScheme, EditorColorsSchemeImpl>((Component)SchemesPanel.this){

                        @Override
                        protected void onSchemeSelected(EditorColorsSchemeImpl scheme) {
                            if (scheme != null) {
                                SchemesPanel.this.myOptions.addImportedScheme(scheme);
                            }
                        }
                    };
                    popup.show(((EditorColorsManagerImpl)EditorColorsManager.getInstance()).getSchemesManager(), SchemesPanel.this.myOptions.getSchemes());
                }
            });
            panel.add((Component)myImportButton, new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        }
        return panel;
    }

    private void showSaveAsDialog() {
        EditorColorsScheme[] allSchemes;
        ArrayList<String> names = new ArrayList<String>();
        for (EditorColorsScheme scheme : allSchemes = EditorColorsManager.getInstance().getAllSchemes()) {
            names.add(scheme.getName());
        }
        SaveSchemeDialog dialog = new SaveSchemeDialog(this, ApplicationBundle.message((String)"title.save.color.scheme.as", (Object[])new Object[0]), names);
        dialog.show();
        if (dialog.isOK()) {
            this.myOptions.saveSchemeAs(dialog.getSchemeName());
        }
    }

    private void changeToScheme() {
        this.updateDescription(false);
    }

    public boolean updateDescription(boolean modified) {
        EditorColorsScheme scheme = this.myOptions.getSelectedScheme();
        if (modified && (ColorAndFontOptions.isReadOnly(scheme) || ColorSettingsUtil.isSharedScheme(scheme))) {
            FontOptions.showReadOnlyMessage(this, ColorSettingsUtil.isSharedScheme(scheme));
            return false;
        }
        return true;
    }

    public void resetSchemesCombo(Object source) {
        if (this != source) {
            String[] schemeNames;
            this.setListLoaded(false);
            String selectedSchemeBackup = this.myOptions.getSelectedScheme().getName();
            this.mySchemeComboBox.removeAllItems();
            for (String schemeName : schemeNames = this.myOptions.getSchemeNames()) {
                this.mySchemeComboBox.addItem(schemeName);
            }
            this.mySchemeComboBox.setSelectedItem(selectedSchemeBackup);
            this.setListLoaded(true);
            this.changeToScheme();
            ((ColorAndFontSettingsListener)this.myDispatcher.getMulticaster()).schemeChanged(this);
        }
    }

    private void setListLoaded(boolean b) {
        this.myListLoaded = b;
    }

    public void addListener(ColorAndFontSettingsListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void disposeUIResources() {
    }
}

