/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.SharedScheme;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

public abstract class SchemesToImportPopup<T extends Scheme, E extends ExternalizableScheme> {
    private final Component myParent;

    public SchemesToImportPopup(Component parent) {
        this.myParent = parent;
    }

    public void show(SchemesManager<T, E> schemesManager, Collection<T> currentSchemeNames) {
        Collection schemes = schemesManager.loadSharedSchemes(currentSchemeNames);
        if (schemes.isEmpty()) {
            Messages.showMessageDialog((String)"There are no available schemes to import", (String)"Import", (Icon)Messages.getWarningIcon());
            return;
        }
        final JList list = new JList(this.createModel(schemes));
        list.setSelectionMode(0);
        list.setCellRenderer(new SchemesToImportListCellRenderer());
        Runnable selectAction = new Runnable(){

            @Override
            public void run() {
                SchemesToImportPopup.this.onSchemeSelected(((SharedScheme)list.getSelectedValue()).getScheme());
            }
        };
        this.showList(list, selectAction);
    }

    private ListModel createModel(Collection<SharedScheme<E>> cc) {
        DefaultListModel<SharedScheme<E>> m = new DefaultListModel<SharedScheme<E>>();
        for (SharedScheme<E> c : cc) {
            m.addElement(c);
        }
        return m;
    }

    private void showList(JList list, Runnable selectAction) {
        new PopupChooserBuilder(list).setTitle(this.getTitle()).setItemChoosenCallback(selectAction).createPopup().showInCenterOf(this.myParent);
    }

    private String getTitle() {
        return "Import Scheme";
    }

    protected abstract void onSchemeSelected(E var1);

    private static class SchemesToImportListCellRenderer
    implements ListCellRenderer {
        private final JPanel myPanel = new JPanel(new BorderLayout());
        private final JLabel myNameLabel = new JLabel("", 2);

        public SchemesToImportListCellRenderer() {
            this.myPanel.add((Component)this.myNameLabel, "Center");
        }

        public Component getListCellRendererComponent(JList l, Object val, int i, boolean isSelected, boolean cellHasFocus) {
            SharedScheme c = (SharedScheme)val;
            this.myNameLabel.setText(c.getScheme().getName());
            this.updateColors(isSelected);
            this.myPanel.setToolTipText("<html><p>Shared by <b>" + c.getUserName() + "</b><br>" + c.getDescription() + "</p></html>");
            return this.myPanel;
        }

        private void updateColors(boolean isSelected) {
            Color bg = isSelected ? UIUtil.getTableSelectionBackground() : UIUtil.getTableBackground();
            Color fg = isSelected ? UIUtil.getTableSelectionForeground() : UIUtil.getTableForeground();
            this.setColors(bg, fg, this.myPanel, this.myNameLabel);
        }

        private void setColors(Color bg, Color fg, JComponent ... cc) {
            for (JComponent c : cc) {
                c.setBackground(bg);
                c.setForeground(fg);
            }
        }
    }
}

