/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NamedJDOMExternalizable;
import com.intellij.openapi.util.RoamingTypeDisabled;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.concurrency.JBReentrantReadWriteLock;
import com.intellij.util.concurrency.LockFactory;
import com.intellij.util.containers.HashMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PathMacrosImpl
extends PathMacros
implements ApplicationComponent,
NamedJDOMExternalizable,
RoamingTypeDisabled {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.application.options.PathMacrosImpl");
    private final Map<String, String> myMacros = new HashMap();
    private final JBReentrantReadWriteLock myLock = LockFactory.createReadWriteLock();
    private final List<String> myIgnoredMacros = new CopyOnWriteArrayList<String>();
    @NonNls
    public static final String MACRO_ELEMENT = "macro";
    @NonNls
    public static final String NAME_ATTR = "name";
    @NonNls
    public static final String VALUE_ATTR = "value";
    @NonNls
    public static final String IGNORED_MACRO_ELEMENT = "ignoredMacro";
    @NonNls
    public static final String APPLICATION_HOME_MACRO_NAME = "APPLICATION_HOME_DIR";
    @NonNls
    public static final String PROJECT_DIR_MACRO_NAME = "PROJECT_DIR";
    @NonNls
    public static final String MODULE_DIR_MACRO_NAME = "MODULE_DIR";
    private static final Set<String> ourSystemMacroNames = new HashSet<String>();
    @NonNls
    public static final String EXT_FILE_NAME = "path.macros";
    private static final Set<String> ourToolsMacros;

    public static PathMacrosImpl getInstanceEx() {
        return (PathMacrosImpl)((Object)ApplicationManager.getApplication().getComponent(PathMacros.class));
    }

    @NotNull
    public String getComponentName() {
        if ("PathMacrosImpl" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/application/options/PathMacrosImpl.getComponentName must not return null");
        }
        return "PathMacrosImpl";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public String getExternalFileName() {
        return EXT_FILE_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getUserMacroNames() {
        this.myLock.readLock().lock();
        try {
            Set<String> set = this.myMacros.keySet();
            return set;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    public static Set<String> getToolMacroNames() {
        return ourToolsMacros;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getSystemMacroNames() {
        try {
            this.myLock.readLock().lock();
            Set<String> set = ourSystemMacroNames;
            return set;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    public Collection<String> getIgnoredMacroNames() {
        return this.myIgnoredMacros;
    }

    public void setIgnoredMacroNames(@NotNull Collection<String> names) {
        if (names == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/application/options/PathMacrosImpl.setIgnoredMacroNames must not be null");
        }
        this.myIgnoredMacros.clear();
        this.myIgnoredMacros.addAll(names);
    }

    public void addIgnoredMacro(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/application/options/PathMacrosImpl.addIgnoredMacro must not be null");
        }
        if (!this.myIgnoredMacros.contains(name)) {
            this.myIgnoredMacros.add(name);
        }
    }

    public boolean isIgnoredMacroName(@NotNull String macro) {
        if (macro == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/application/options/PathMacrosImpl.isIgnoredMacroName must not be null");
        }
        return this.myIgnoredMacros.contains(macro);
    }

    public Set<String> getAllMacroNames() {
        Set<String> userMacroNames = this.getUserMacroNames();
        Set<String> systemMacroNames = this.getSystemMacroNames();
        HashSet<String> allNames = new HashSet<String>(userMacroNames.size() + systemMacroNames.size());
        allNames.addAll(systemMacroNames);
        allNames.addAll(userMacroNames);
        return allNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValue(String name) {
        try {
            this.myLock.readLock().lock();
            String string = this.myMacros.get(name);
            return string;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllMacros() {
        try {
            this.myLock.writeLock().lock();
            this.myMacros.clear();
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMacro(@NotNull String name, @NotNull String value) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/application/options/PathMacrosImpl.setMacro must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/application/options/PathMacrosImpl.setMacro must not be null");
        }
        if (value.trim().length() == 0) {
            return;
        }
        try {
            this.myLock.writeLock().lock();
            this.myMacros.put(name, value);
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMacro(String name) {
        try {
            this.myLock.writeLock().lock();
            String value = this.myMacros.remove(name);
            LOG.assertTrue(value != null);
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    public void readExternal(Element element) throws InvalidDataException {
        List children = element.getChildren(MACRO_ELEMENT);
        for (Object aChildren : children) {
            Element macro = (Element)aChildren;
            String name = macro.getAttributeValue(NAME_ATTR);
            String value = macro.getAttributeValue(VALUE_ATTR);
            if (name == null || value == null) {
                throw new InvalidDataException();
            }
            this.myMacros.put(name, value);
        }
        List ignoredChildren = element.getChildren(IGNORED_MACRO_ELEMENT);
        for (Object child : ignoredChildren) {
            Element macroElement = (Element)child;
            String ignoredName = macroElement.getAttributeValue(NAME_ATTR);
            if (ignoredName == null || ignoredName.length() <= 0 || this.myIgnoredMacros.contains(ignoredName)) continue;
            this.myIgnoredMacros.add(ignoredName);
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        Set<Map.Entry<String, String>> entries = this.myMacros.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String value = entry.getValue();
            if (value == null || value.trim().length() <= 0) continue;
            Element macro = new Element(MACRO_ELEMENT);
            macro.setAttribute(NAME_ATTR, entry.getKey());
            macro.setAttribute(VALUE_ATTR, value);
            element.addContent(macro);
        }
        for (String macro : this.myIgnoredMacros) {
            Element macroElement = new Element(IGNORED_MACRO_ELEMENT);
            macroElement.setAttribute(NAME_ATTR, macro);
            element.addContent(macroElement);
        }
    }

    public void addMacroReplacements(ReplacePathToMacroMap result) {
        Set<String> macroNames = this.getUserMacroNames();
        for (String name : macroNames) {
            String value = this.getValue(name);
            if (value == null || value.trim().length() <= 0) continue;
            result.addMacroReplacement(value, name);
        }
    }

    public void addMacroExpands(ExpandMacroToPathMap result) {
        Set<String> macroNames = this.getUserMacroNames();
        for (String name : macroNames) {
            String value = this.getValue(name);
            if (value == null || value.trim().length() <= 0) continue;
            result.addMacroExpand(name, value);
        }
    }

    static {
        ourSystemMacroNames.add(APPLICATION_HOME_MACRO_NAME);
        ourSystemMacroNames.add(PROJECT_DIR_MACRO_NAME);
        ourSystemMacroNames.add(MODULE_DIR_MACRO_NAME);
        ourToolsMacros = new HashSet<String>();
        ourToolsMacros.add("ClasspathEntry");
        ourToolsMacros.add("Classpath");
        ourToolsMacros.add("ColumnNumber");
        ourToolsMacros.add("FileClass");
        ourToolsMacros.add("FileDir");
        ourToolsMacros.add("FileDirRelativeToProjectRoot");
        ourToolsMacros.add("/FileDirRelativeToProjectRoot");
        ourToolsMacros.add("FileDirRelativeToSourcepath");
        ourToolsMacros.add("/FileDirRelativeToSourcepath");
        ourToolsMacros.add("FileExt");
        ourToolsMacros.add("FileFQPackage");
        ourToolsMacros.add("FileName");
        ourToolsMacros.add("FileNameWithoutExtension");
        ourToolsMacros.add("FilePackage");
        ourToolsMacros.add("FilePath");
        ourToolsMacros.add("FilePathRelativeToProjectRoot");
        ourToolsMacros.add("/FilePathRelativeToProjectRoot");
        ourToolsMacros.add("FilePathRelativeToSourcepath");
        ourToolsMacros.add("/FilePathRelativeToSourcepath");
        ourToolsMacros.add("FileRelativeDir");
        ourToolsMacros.add("/FileRelativeDir");
        ourToolsMacros.add("FileRelativePath");
        ourToolsMacros.add("/FileRelativePath");
        ourToolsMacros.add("JavaDocPath");
        ourToolsMacros.add("JDKPath");
        ourToolsMacros.add("LineNumber");
        ourToolsMacros.add("ModuleFileDir");
        ourToolsMacros.add("ModuleFilePath");
        ourToolsMacros.add("ModuleName");
        ourToolsMacros.add("ModuleSourcePath");
        ourToolsMacros.add("OutputPath");
        ourToolsMacros.add("ProjectFileDir");
        ourToolsMacros.add("ProjectFilePath");
        ourToolsMacros.add("ProjectName");
        ourToolsMacros.add("Projectpath");
        ourToolsMacros.add("Prompt");
        ourToolsMacros.add("SourcepathEntry");
        ourToolsMacros.add("Sourcepath");
    }
}

