/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.PathMacrosImpl;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.PathMacroMap;
import com.intellij.util.NotNullFunction;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathMacrosCollector
extends PathMacroMap {
    public static final Pattern MACRO_PATTERN = Pattern.compile("\\$([\\w\\-\\.]+?)\\$");
    private final Matcher myMatcher = MACRO_PATTERN.matcher("");
    private static final Set<String> ourSystemMacroNames = new HashSet<String>(Arrays.asList("APPLICATION_HOME_DIR", "MODULE_DIR", "PROJECT_DIR"));
    private static final String FILE_PROTOCOL = "file:";
    private static final String JAR_PROTOCOL = "jar:";

    private PathMacrosCollector() {
    }

    public static Set<String> getMacroNames(Element root, @Nullable NotNullFunction<Object, Boolean> filter) {
        return PathMacrosCollector.getMacroNames(root, filter, null);
    }

    public static Set<String> getMacroNames(Element root, @Nullable NotNullFunction<Object, Boolean> filter, @Nullable NotNullFunction<Object, Boolean> recursiveFilter, @NotNull PathMacros pathMacros) {
        if (pathMacros == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/application/options/PathMacrosCollector.getMacroNames must not be null");
        }
        PathMacrosCollector collector = new PathMacrosCollector();
        collector.substitute(root, true, false, filter, recursiveFilter);
        HashSet<String> result = new HashSet<String>(collector.myMacroMap.keySet());
        result.removeAll(ourSystemMacroNames);
        result.removeAll(PathMacrosImpl.getToolMacroNames());
        result.removeAll(pathMacros.getIgnoredMacroNames());
        return result;
    }

    public static Set<String> getMacroNames(Element root, @Nullable NotNullFunction<Object, Boolean> filter, @Nullable NotNullFunction<Object, Boolean> recursiveFilter) {
        return PathMacrosCollector.getMacroNames(root, filter, recursiveFilter, PathMacros.getInstance());
    }

    @Override
    public String substituteRecursively(String text, boolean caseSensitive) {
        if (text == null || text.length() == 0) {
            return text;
        }
        this.myMatcher.reset(text);
        while (this.myMatcher.find()) {
            String macroName = this.myMatcher.group(1);
            this.myMacroMap.put(macroName, null);
        }
        return text;
    }

    @Override
    public String substitute(String text, boolean caseSensitive) {
        if (text == null || text.length() == 0) {
            return text;
        }
        String protocol = null;
        if (text.length() > 7 && text.charAt(0) == 'f') {
            protocol = FILE_PROTOCOL;
        } else if (text.length() > 6 && text.charAt(0) == 'j') {
            protocol = JAR_PROTOCOL;
        } else if ('$' != text.charAt(0)) {
            return text;
        }
        if (protocol != null && !text.startsWith(protocol)) {
            return text;
        }
        this.myMatcher.reset(text);
        if (this.myMatcher.find()) {
            String macroName = this.myMatcher.group(1);
            this.myMacroMap.put(macroName, null);
        }
        return text;
    }
}

