/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.opassign;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.EquivalenceChecker;
import com.siyeh.ipp.psiutils.ErrorUtil;
import com.siyeh.ipp.psiutils.SideEffectChecker;

class AssignmentExpressionReplaceableWithOperatorAssigment
implements PsiElementPredicate {
    AssignmentExpressionReplaceableWithOperatorAssigment() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiAssignmentExpression)) {
            return false;
        }
        PsiAssignmentExpression assignment = (PsiAssignmentExpression)element;
        PsiJavaToken sign = assignment.getOperationSign();
        IElementType tokenType = sign.getTokenType();
        if (!JavaTokenType.EQ.equals(tokenType)) {
            return false;
        }
        PsiExpression rhs = assignment.getRExpression();
        PsiExpression expression = PsiUtil.deparenthesizeExpression((PsiExpression)rhs);
        if (expression == null) {
            return false;
        }
        if (!(expression instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryRhs = (PsiBinaryExpression)expression;
        PsiExpression rhsRhs = binaryRhs.getROperand();
        PsiExpression rhsLhs = binaryRhs.getLOperand();
        if (rhsRhs == null) {
            return false;
        }
        PsiJavaToken operatorSign = binaryRhs.getOperationSign();
        IElementType rhsTokenType = operatorSign.getTokenType();
        if (JavaTokenType.OROR.equals(rhsTokenType) || JavaTokenType.ANDAND.equals(rhsTokenType) || JavaTokenType.EQEQ.equals(rhsTokenType) || JavaTokenType.NE.equals(rhsTokenType)) {
            return false;
        }
        PsiExpression lhs = assignment.getLExpression();
        if (SideEffectChecker.mayHaveSideEffects(lhs)) {
            return false;
        }
        if (!EquivalenceChecker.expressionsAreEquivalent(lhs, rhsLhs)) {
            return false;
        }
        return !ErrorUtil.containsError(element);
    }
}

