/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.expression;

import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.expression.ExpressionPredicate;
import org.jetbrains.annotations.NotNull;

public class FlipExpressionIntention
extends MutablyNamedIntention {
    @Override
    public String getTextForElement(PsiElement element) {
        PsiBinaryExpression expression = (PsiBinaryExpression)element;
        PsiJavaToken sign = expression.getOperationSign();
        String operatorText = sign.getText();
        return IntentionPowerPackBundle.message("flip.smth.intention.name", operatorText);
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        ExpressionPredicate expressionPredicate = new ExpressionPredicate();
        if (expressionPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/expression/FlipExpressionIntention.getElementPredicate must not return null");
        }
        return expressionPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/expression/FlipExpressionIntention.processIntention must not be null");
        }
        PsiBinaryExpression expression = (PsiBinaryExpression)element;
        PsiExpression lhs = expression.getLOperand();
        PsiExpression rhs = expression.getROperand();
        PsiJavaToken sign = expression.getOperationSign();
        if (rhs == null) {
            return;
        }
        String signText = sign.getText();
        String lhsText = lhs.getText();
        String rhsText = rhs.getText();
        StringBuilder newExpression = new StringBuilder(rhsText);
        newExpression.append(signText);
        if (lhsText.startsWith(signText)) {
            newExpression.append(' ');
        }
        newExpression.append(lhsText);
        FlipExpressionIntention.replaceExpression(newExpression.toString(), (PsiExpression)expression);
    }
}

