/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.concatenation;

import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.concatenation.AppendUtil;

class AppendChainPredicate
implements PsiElementPredicate {
    AppendChainPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        PsiDeclarationStatement declarationStatement;
        if (!AppendUtil.isAppendCall(element)) {
            return false;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)element;
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (!(qualifier instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression qualifierCall = (PsiMethodCallExpression)element;
        if (!AppendUtil.isAppendCall((PsiElement)qualifierCall)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiExpressionStatement) {
            return true;
        }
        PsiElement grandParent = parent.getParent();
        if (parent instanceof PsiLocalVariable && grandParent instanceof PsiDeclarationStatement && (declarationStatement = (PsiDeclarationStatement)grandParent).getDeclaredElements().length == 1) {
            return true;
        }
        return parent instanceof PsiAssignmentExpression && grandParent instanceof PsiExpressionStatement;
    }
}

