/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gpp;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.gpp.GppTypeConverter;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.GroovyExpectedTypesContributor;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.GroovyExpectedTypesProvider;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.SubtypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;

public class GppExpectedTypesContributor
extends GroovyExpectedTypesContributor {
    public List<TypeConstraint> calculateTypeConstraints(@NotNull GrExpression expression) {
        GrListOrMap list;
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/gpp/GppExpectedTypesContributor.calculateTypeConstraints must not be null");
        }
        PsiElement parent = expression.getParent();
        if (parent instanceof GrListOrMap && !(list = (GrListOrMap)parent).isMap()) {
            return GppExpectedTypesContributor.addExpectedConstructorParameters(expression, list);
        }
        return Collections.emptyList();
    }

    private static List<TypeConstraint> addExpectedConstructorParameters(GrExpression expression, GrListOrMap list) {
        PsiType listType = list.getType();
        if (!(listType instanceof GrTupleType)) {
            return Collections.emptyList();
        }
        PsiType[] argTypes = ((GrTupleType)listType).getComponentTypes();
        int argIndex = Arrays.asList(list.getInitializers()).indexOf(expression);
        assert (argIndex >= 0);
        ArrayList<TypeConstraint> result = new ArrayList<TypeConstraint>();
        for (PsiType type : GroovyExpectedTypesProvider.getDefaultExpectedTypes((GrExpression)expression)) {
            if (!(type instanceof PsiClassType)) continue;
            for (GroovyResolveResult resolveResult : GppTypeConverter.getConstructorCandidates((PsiClassType)type, argTypes, (GroovyPsiElement)expression)) {
                PsiParameter[] constructorParameters;
                PsiElement method = resolveResult.getElement();
                if (!(method instanceof PsiMethod) || !((PsiMethod)method).isConstructor() || (constructorParameters = ((PsiMethod)method).getParameterList().getParameters()).length <= argIndex) continue;
                PsiType toCastTo = resolveResult.getSubstitutor().substitute(constructorParameters[argIndex].getType());
                result.add((TypeConstraint)SubtypeConstraint.create((PsiType)toCastTo));
            }
        }
        return result;
    }
}

