/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class WaitWhileHoldingTwoLocksInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("wait.while.holding.two.locks.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/WaitWhileHoldingTwoLocksInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("wait.while.holding.two.locks.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/WaitWhileHoldingTwoLocksInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new WaitWhileHoldingTwoLocksVisitor();
    }

    private static class WaitWhileHoldingTwoLocksVisitor
    extends BaseInspectionVisitor {
        private WaitWhileHoldingTwoLocksVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            this.checkErrorsIn((PsiElement)method);
        }

        public void visitClassInitializer(PsiClassInitializer initializer) {
            this.checkErrorsIn((PsiElement)initializer);
        }

        private void checkErrorsIn(PsiElement context) {
            context.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){
                private int m_numLocksHeld = 0;

                public void visitClass(PsiClass aClass) {
                }

                public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
                    PsiType parameterType;
                    if (expression == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/threading/WaitWhileHoldingTwoLocksInspection$WaitWhileHoldingTwoLocksVisitor$1.visitMethodCallExpression must not be null");
                    }
                    super.visitMethodCallExpression(expression);
                    if (this.m_numLocksHeld < 2) {
                        return;
                    }
                    PsiReferenceExpression methodExpression = expression.getMethodExpression();
                    String methodName = methodExpression.getReferenceName();
                    if (!"wait".equals(methodName)) {
                        return;
                    }
                    PsiMethod method = expression.resolveMethod();
                    if (method == null) {
                        return;
                    }
                    PsiParameterList parameterList = method.getParameterList();
                    int numParams = parameterList.getParametersCount();
                    if (numParams > 2) {
                        return;
                    }
                    PsiParameter[] parameters = parameterList.getParameters();
                    if (numParams > 0 && !(parameterType = parameters[0].getType()).equals(PsiType.LONG)) {
                        return;
                    }
                    if (numParams > 1 && !(parameterType = parameters[1].getType()).equals(PsiType.INT)) {
                        return;
                    }
                    WaitWhileHoldingTwoLocksVisitor.this.registerMethodCallError(expression, new Object[0]);
                }

                public void visitMethod(@NotNull PsiMethod method) {
                    if (method == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/threading/WaitWhileHoldingTwoLocksInspection$WaitWhileHoldingTwoLocksVisitor$1.visitMethod must not be null");
                    }
                    if (method.hasModifierProperty("synchronized")) {
                        ++this.m_numLocksHeld;
                    }
                    super.visitMethod(method);
                    if (method.hasModifierProperty("synchronized")) {
                        --this.m_numLocksHeld;
                    }
                }

                public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement synchronizedStatement) {
                    if (synchronizedStatement == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/threading/WaitWhileHoldingTwoLocksInspection$WaitWhileHoldingTwoLocksVisitor$1.visitSynchronizedStatement must not be null");
                    }
                    ++this.m_numLocksHeld;
                    super.visitSynchronizedStatement(synchronizedStatement);
                    --this.m_numLocksHeld;
                }
            });
        }
    }
}

