/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.ReplaceInheritanceWithDelegationFix;
import org.jetbrains.annotations.NotNull;

public class ExtendsThreadInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("ClassExplicitlyExtendsThread" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/ExtendsThreadInspection.getID must not return null");
        }
        return "ClassExplicitlyExtendsThread";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("extends.thread.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/ExtendsThreadInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("extends.thread.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/ExtendsThreadInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiClass superClass = (PsiClass)infos[0];
        if (superClass instanceof PsiAnonymousClass) {
            return null;
        }
        return new ReplaceInheritanceWithDelegationFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ExtendsThreadVisitor();
    }

    private static class ExtendsThreadVisitor
    extends BaseInspectionVisitor {
        private ExtendsThreadVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/threading/ExtendsThreadInspection$ExtendsThreadVisitor.visitClass must not be null");
            }
            if (aClass.isInterface() || aClass.isAnnotationType() || aClass.isEnum()) {
                return;
            }
            PsiClass superClass = aClass.getSuperClass();
            if (superClass == null) {
                return;
            }
            String superclassName = superClass.getQualifiedName();
            if (!"java.lang.Thread".equals(superclassName)) {
                return;
            }
            this.registerClassError(aClass, aClass);
        }
    }
}

