/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryAnnotationParenthesesInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.annotation.parentheses.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryAnnotationParenthesesInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.annotation.parentheses.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryAnnotationParenthesesInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryAnnotationParenthesesFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryAnnotatinoParenthesesVisitor();
    }

    private static class UnnecessaryAnnotatinoParenthesesVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryAnnotatinoParenthesesVisitor() {
        }

        public void visitAnnotation(PsiAnnotation annotation) {
            PsiMethod[] methods;
            super.visitAnnotation(annotation);
            PsiJavaCodeReferenceElement reference = annotation.getNameReferenceElement();
            if (reference == null) {
                return;
            }
            PsiAnnotationParameterList parameterList = annotation.getParameterList();
            PsiElement[] children = parameterList.getChildren();
            if (children.length == 0) {
                return;
            }
            PsiNameValuePair[] nameValuePairs = parameterList.getAttributes();
            if (nameValuePairs.length > 0) {
                return;
            }
            PsiElement target = reference.resolve();
            if (!(target instanceof PsiClass)) {
                return;
            }
            PsiClass annotationClass = (PsiClass)target;
            for (PsiMethod method : methods = annotationClass.getMethods()) {
                PsiAnnotationMethod annotationMethod;
                PsiAnnotationMemberValue defaultValue;
                if (!(method instanceof PsiAnnotationMethod) || (defaultValue = (annotationMethod = (PsiAnnotationMethod)method).getDefaultValue()) != null) continue;
                return;
            }
            this.registerError((PsiElement)parameterList, new Object[0]);
        }
    }

    private static class UnnecessaryAnnotationParenthesesFix
    extends InspectionGadgetsFix {
        private UnnecessaryAnnotationParenthesesFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("unnecessary.annotation.parameter.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryAnnotationParenthesesInspection$UnnecessaryAnnotationParenthesesFix.getName must not return null");
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement[] children;
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiAnnotationParameterList)) {
                return;
            }
            for (PsiElement child : children = element.getChildren()) {
                child.delete();
            }
        }
    }
}

