/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ig.psiutils.ArrayContentsAccessedVisitor;
import com.siyeh.ig.psiutils.ArrayContentsAssignedVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableAssignedFromVisitor;
import com.siyeh.ig.psiutils.VariableAssignedVisitor;
import com.siyeh.ig.psiutils.VariablePassedAsArgumentExcludedVisitor;
import com.siyeh.ig.psiutils.VariablePassedAsArgumentVisitor;
import com.siyeh.ig.psiutils.VariableReturnedVisitor;
import com.siyeh.ig.psiutils.VariableUsedInArrayInitializerVisitor;
import com.siyeh.ig.psiutils.VariableUsedInInnerClassVisitor;
import com.siyeh.ig.psiutils.VariableUsedVisitor;
import com.siyeh.ig.psiutils.VariableValueUsedVisitor;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableAccessUtils {
    private VariableAccessUtils() {
    }

    public static boolean variableIsAssignedFrom(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableAccessUtils.variableIsAssignedFrom must not be null");
        }
        if (context == null) {
            return false;
        }
        VariableAssignedFromVisitor visitor = new VariableAssignedFromVisitor(variable);
        context.accept((PsiElementVisitor)visitor);
        return visitor.isAssignedFrom();
    }

    public static boolean variableIsPassedAsMethodArgument(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableAccessUtils.variableIsPassedAsMethodArgument must not be null");
        }
        if (context == null) {
            return false;
        }
        VariablePassedAsArgumentVisitor visitor = new VariablePassedAsArgumentVisitor(variable);
        context.accept((PsiElementVisitor)visitor);
        return visitor.isPassed();
    }

    public static boolean variableIsPassedAsMethodArgument(@NotNull PsiVariable variable, Set<String> excludes, @Nullable PsiElement context) {
        if (variable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableAccessUtils.variableIsPassedAsMethodArgument must not be null");
        }
        if (context == null) {
            return false;
        }
        VariablePassedAsArgumentExcludedVisitor visitor = new VariablePassedAsArgumentExcludedVisitor(variable, excludes);
        context.accept((PsiElementVisitor)visitor);
        return visitor.isPassed();
    }

    public static boolean variableIsUsedInArrayInitializer(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableAccessUtils.variableIsUsedInArrayInitializer must not be null");
        }
        if (context == null) {
            return false;
        }
        VariableUsedInArrayInitializerVisitor visitor = new VariableUsedInArrayInitializerVisitor(variable);
        context.accept((PsiElementVisitor)visitor);
        return visitor.isPassed();
    }

    public static boolean variableIsAssigned(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableAccessUtils.variableIsAssigned must not be null");
        }
        if (context == null) {
            return false;
        }
        VariableAssignedVisitor visitor = new VariableAssignedVisitor(variable, true);
        context.accept((PsiElementVisitor)visitor);
        return visitor.isAssigned();
    }

    public static boolean variableIsAssigned(@NotNull PsiVariable variable, @Nullable PsiElement context, boolean recurseIntoClasses) {
        if (variable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableAccessUtils.variableIsAssigned must not be null");
        }
        if (context == null) {
            return false;
        }
        VariableAssignedVisitor visitor = new VariableAssignedVisitor(variable, recurseIntoClasses);
        context.accept((PsiElementVisitor)visitor);
        return visitor.isAssigned();
    }

    public static boolean variableIsReturned(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableAccessUtils.variableIsReturned must not be null");
        }
        if (context == null) {
            return false;
        }
        VariableReturnedVisitor visitor = new VariableReturnedVisitor(variable);
        context.accept((PsiElementVisitor)visitor);
        return visitor.isReturned();
    }

    public static boolean variableValueIsUsed(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableAccessUtils.variableValueIsUsed must not be null");
        }
        if (context == null) {
            return false;
        }
        VariableValueUsedVisitor visitor = new VariableValueUsedVisitor(variable);
        context.accept((PsiElementVisitor)visitor);
        return visitor.isVariableValueUsed();
    }

    public static boolean arrayContentsAreAccessed(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableAccessUtils.arrayContentsAreAccessed must not be null");
        }
        if (context == null) {
            return false;
        }
        ArrayContentsAccessedVisitor visitor = new ArrayContentsAccessedVisitor(variable);
        context.accept((PsiElementVisitor)visitor);
        return visitor.isAccessed();
    }

    public static boolean arrayContentsAreAssigned(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableAccessUtils.arrayContentsAreAssigned must not be null");
        }
        if (context == null) {
            return false;
        }
        ArrayContentsAssignedVisitor visitor = new ArrayContentsAssignedVisitor(variable);
        context.accept((PsiElementVisitor)visitor);
        return visitor.isAssigned();
    }

    public static boolean variableIsUsedInInnerClass(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableAccessUtils.variableIsUsedInInnerClass must not be null");
        }
        if (context == null) {
            return false;
        }
        VariableUsedInInnerClassVisitor visitor = new VariableUsedInInnerClassVisitor(variable);
        context.accept((PsiElementVisitor)visitor);
        return visitor.isUsedInInnerClass();
    }

    public static boolean mayEvaluateToVariable(@Nullable PsiExpression expression, @NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/VariableAccessUtils.mayEvaluateToVariable must not be null");
        }
        if (expression == null) {
            return false;
        }
        if (expression instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
            PsiExpression lOperand = binaryExpression.getLOperand();
            PsiExpression rOperand = binaryExpression.getROperand();
            return VariableAccessUtils.mayEvaluateToVariable(lOperand, variable) || VariableAccessUtils.mayEvaluateToVariable(rOperand, variable);
        }
        if (expression instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
            PsiExpression containedExpression = parenthesizedExpression.getExpression();
            return VariableAccessUtils.mayEvaluateToVariable(containedExpression, variable);
        }
        if (expression instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)expression;
            PsiExpression containedExpression = typeCastExpression.getOperand();
            return VariableAccessUtils.mayEvaluateToVariable(containedExpression, variable);
        }
        if (expression instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditional = (PsiConditionalExpression)expression;
            PsiExpression thenExpression = conditional.getThenExpression();
            PsiExpression elseExpression = conditional.getElseExpression();
            return VariableAccessUtils.mayEvaluateToVariable(thenExpression, variable) || VariableAccessUtils.mayEvaluateToVariable(elseExpression, variable);
        }
        if (expression instanceof PsiArrayAccessExpression) {
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiArrayAccessExpression) {
                return false;
            }
            PsiType type = variable.getType();
            if (!(type instanceof PsiArrayType)) {
                return false;
            }
            PsiArrayType arrayType = (PsiArrayType)type;
            int dimensions = arrayType.getArrayDimensions();
            if (dimensions <= 1) {
                return false;
            }
            PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)expression;
            PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            int count = 1;
            while (arrayExpression instanceof PsiArrayAccessExpression) {
                arrayAccessExpression = (PsiArrayAccessExpression)arrayExpression;
                arrayExpression = arrayAccessExpression.getArrayExpression();
                ++count;
            }
            return count != dimensions && VariableAccessUtils.mayEvaluateToVariable(arrayExpression, variable);
        }
        return VariableAccessUtils.evaluatesToVariable(expression, variable);
    }

    public static boolean evaluatesToVariable(@Nullable PsiExpression expression, @NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/VariableAccessUtils.evaluatesToVariable must not be null");
        }
        PsiExpression strippedExpression = ParenthesesUtils.stripParentheses(expression);
        if (strippedExpression == null) {
            return false;
        }
        if (!(expression instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
        PsiElement referent = referenceExpression.resolve();
        return variable.equals(referent);
    }

    public static boolean variableIsUsed(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableAccessUtils.variableIsUsed must not be null");
        }
        if (context == null) {
            return false;
        }
        VariableUsedVisitor visitor = new VariableUsedVisitor(variable);
        context.accept((PsiElementVisitor)visitor);
        return visitor.isUsed();
    }

    public static boolean variableIsIncremented(@NotNull PsiVariable variable, @Nullable PsiStatement statement) {
        if (variable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableAccessUtils.variableIsIncremented must not be null");
        }
        if (!(statement instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
        PsiExpression expression = expressionStatement.getExpression();
        if ((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression;
            PsiJavaToken sign = prefixExpression.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (!tokenType.equals(JavaTokenType.PLUSPLUS)) {
                return false;
            }
            PsiExpression operand = prefixExpression.getOperand();
            return VariableAccessUtils.evaluatesToVariable(operand, variable);
        }
        if (expression instanceof PsiPostfixExpression) {
            PsiPostfixExpression postfixExpression = (PsiPostfixExpression)expression;
            PsiJavaToken sign = postfixExpression.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (!tokenType.equals(JavaTokenType.PLUSPLUS)) {
                return false;
            }
            PsiExpression operand = postfixExpression.getOperand();
            return VariableAccessUtils.evaluatesToVariable(operand, variable);
        }
        if (expression instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
            IElementType tokenType = assignmentExpression.getOperationTokenType();
            PsiExpression lhs = assignmentExpression.getLExpression();
            if (!VariableAccessUtils.evaluatesToVariable(lhs = ParenthesesUtils.stripParentheses(lhs), variable)) {
                return false;
            }
            PsiExpression rhs = assignmentExpression.getRExpression();
            rhs = ParenthesesUtils.stripParentheses(rhs);
            if (tokenType == JavaTokenType.EQ) {
                if (!(rhs instanceof PsiBinaryExpression)) {
                    return false;
                }
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)rhs;
                PsiExpression lOperand = binaryExpression.getLOperand();
                lOperand = ParenthesesUtils.stripParentheses(lOperand);
                PsiExpression rOperand = binaryExpression.getROperand();
                rOperand = ParenthesesUtils.stripParentheses(rOperand);
                if (ExpressionUtils.isOne(lOperand) ? VariableAccessUtils.evaluatesToVariable(rOperand, variable) : ExpressionUtils.isOne(rOperand) && VariableAccessUtils.evaluatesToVariable(lOperand, variable)) {
                    return true;
                }
            } else if (tokenType == JavaTokenType.PLUSEQ && ExpressionUtils.isOne(rhs)) {
                return true;
            }
        }
        return false;
    }

    public static boolean variableIsAssignedBeforeReference(@NotNull PsiReferenceExpression referenceExpression, @Nullable PsiElement context) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableAccessUtils.variableIsAssignedBeforeReference must not be null");
        }
        if (context == null) {
            return false;
        }
        PsiElement target = referenceExpression.resolve();
        if (!(target instanceof PsiVariable)) {
            return false;
        }
        PsiVariable variable = (PsiVariable)target;
        return VariableAccessUtils.variableIsAssignedAtPoint(variable, context, (PsiElement)referenceExpression);
    }

    public static boolean variableIsAssignedAtPoint(@NotNull PsiVariable variable, @Nullable PsiElement context, @NotNull PsiElement point) {
        PsiElement[] children;
        if (variable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableAccessUtils.variableIsAssignedAtPoint must not be null");
        }
        if (point == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/siyeh/ig/psiutils/VariableAccessUtils.variableIsAssignedAtPoint must not be null");
        }
        if (context == null) {
            return false;
        }
        PsiElement directChild = VariableAccessUtils.getDirectChildWhichContainsElement(context, point);
        if (directChild == null) {
            return false;
        }
        for (PsiElement child : children = context.getChildren()) {
            if (child == directChild) {
                return VariableAccessUtils.variableIsAssignedAtPoint(variable, directChild, point);
            }
            if (!VariableAccessUtils.variableIsAssigned(variable, child)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static PsiElement getDirectChildWhichContainsElement(@NotNull PsiElement ancestor, @NotNull PsiElement descendant) {
        if (ancestor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableAccessUtils.getDirectChildWhichContainsElement must not be null");
        }
        if (descendant == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/VariableAccessUtils.getDirectChildWhichContainsElement must not be null");
        }
        if (ancestor == descendant) {
            return null;
        }
        PsiElement child = descendant;
        PsiElement parent = child.getParent();
        while (!parent.equals(ancestor)) {
            child = parent;
            if ((parent = child.getParent()) != null) continue;
            return null;
        }
        return child;
    }
}

