/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.MethodSignature;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExceptionUtils;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InitializationUtils {
    private InitializationUtils() {
    }

    public static boolean methodAssignsVariableOrFails(@Nullable PsiMethod method, @NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/InitializationUtils.methodAssignsVariableOrFails must not be null");
        }
        return InitializationUtils.methodAssignsVariableOrFails(method, variable, false);
    }

    public static boolean methodAssignsVariableOrFails(@Nullable PsiMethod method, @NotNull PsiVariable variable, boolean strict) {
        if (variable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/InitializationUtils.methodAssignsVariableOrFails must not be null");
        }
        if (method == null) {
            return false;
        }
        PsiCodeBlock body = method.getBody();
        return body != null && InitializationUtils.blockAssignsVariableOrFails(body, variable, strict);
    }

    public static boolean classInitializerAssignsVariableOrFails(@Nullable PsiClassInitializer initializer, @NotNull PsiVariable variable, boolean strict) {
        if (variable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/InitializationUtils.classInitializerAssignsVariableOrFails must not be null");
        }
        if (initializer == null) {
            return false;
        }
        PsiCodeBlock body = initializer.getBody();
        return InitializationUtils.blockAssignsVariableOrFails(body, variable, strict);
    }

    public static boolean blockAssignsVariableOrFails(@Nullable PsiCodeBlock block, @NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/InitializationUtils.blockAssignsVariableOrFails must not be null");
        }
        return InitializationUtils.blockAssignsVariableOrFails(block, variable, false);
    }

    public static boolean blockAssignsVariableOrFails(@Nullable PsiCodeBlock block, @NotNull PsiVariable variable, boolean strict) {
        if (variable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/InitializationUtils.blockAssignsVariableOrFails must not be null");
        }
        return InitializationUtils.blockAssignsVariableOrFails(block, variable, new HashSet<MethodSignature>(), strict);
    }

    private static boolean blockAssignsVariableOrFails(@Nullable PsiCodeBlock block, @NotNull PsiVariable variable, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        if (variable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/InitializationUtils.blockAssignsVariableOrFails must not be null");
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/siyeh/ig/psiutils/InitializationUtils.blockAssignsVariableOrFails must not be null");
        }
        if (block == null) {
            return false;
        }
        PsiStatement[] statements = block.getStatements();
        int assignmentCount = 0;
        for (PsiStatement statement : statements) {
            if (!InitializationUtils.statementAssignsVariableOrFails(statement, variable, checkedMethods, strict)) continue;
            if (strict) {
                ++assignmentCount;
                continue;
            }
            return true;
        }
        return assignmentCount == 1;
    }

    private static boolean statementAssignsVariableOrFails(@Nullable PsiStatement statement, PsiVariable variable, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        if (checkedMethods == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/siyeh/ig/psiutils/InitializationUtils.statementAssignsVariableOrFails must not be null");
        }
        if (statement == null) {
            return false;
        }
        if (ExceptionUtils.statementThrowsException(statement)) {
            return true;
        }
        if (statement instanceof PsiBreakStatement || statement instanceof PsiContinueStatement || statement instanceof PsiAssertStatement || statement instanceof PsiEmptyStatement) {
            return false;
        }
        if (statement instanceof PsiReturnStatement) {
            PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
            PsiExpression returnValue = returnStatement.getReturnValue();
            return InitializationUtils.expressionAssignsVariableOrFails(returnValue, variable, checkedMethods, strict);
        }
        if (statement instanceof PsiThrowStatement) {
            PsiThrowStatement throwStatement = (PsiThrowStatement)statement;
            PsiExpression exception = throwStatement.getException();
            return InitializationUtils.expressionAssignsVariableOrFails(exception, variable, checkedMethods, strict);
        }
        if (statement instanceof PsiExpressionListStatement) {
            PsiExpression[] expressions;
            PsiExpressionListStatement list = (PsiExpressionListStatement)statement;
            PsiExpressionList expressionList = list.getExpressionList();
            for (PsiExpression expression : expressions = expressionList.getExpressions()) {
                if (!InitializationUtils.expressionAssignsVariableOrFails(expression, variable, checkedMethods, strict)) continue;
                return true;
            }
            return false;
        }
        if (statement instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
            PsiExpression expression = expressionStatement.getExpression();
            return InitializationUtils.expressionAssignsVariableOrFails(expression, variable, checkedMethods, strict);
        }
        if (statement instanceof PsiDeclarationStatement) {
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement;
            return InitializationUtils.declarationStatementAssignsVariableOrFails(declarationStatement, variable, checkedMethods, strict);
        }
        if (statement instanceof PsiForStatement) {
            PsiForStatement forStatement = (PsiForStatement)statement;
            return InitializationUtils.forStatementAssignsVariableOrFails(forStatement, variable, checkedMethods, strict);
        }
        if (statement instanceof PsiForeachStatement) {
            PsiForeachStatement foreachStatement = (PsiForeachStatement)statement;
            return InitializationUtils.foreachStatementAssignsVariableOrFails(variable, foreachStatement);
        }
        if (statement instanceof PsiWhileStatement) {
            PsiWhileStatement whileStatement = (PsiWhileStatement)statement;
            return InitializationUtils.whileStatementAssignsVariableOrFails(whileStatement, variable, checkedMethods, strict);
        }
        if (statement instanceof PsiDoWhileStatement) {
            PsiDoWhileStatement doWhileStatement = (PsiDoWhileStatement)statement;
            return InitializationUtils.doWhileAssignsVariableOrFails(doWhileStatement, variable, checkedMethods, strict);
        }
        if (statement instanceof PsiSynchronizedStatement) {
            PsiSynchronizedStatement synchronizedStatement = (PsiSynchronizedStatement)statement;
            PsiCodeBlock body = synchronizedStatement.getBody();
            return InitializationUtils.blockAssignsVariableOrFails(body, variable, checkedMethods, strict);
        }
        if (statement instanceof PsiBlockStatement) {
            PsiBlockStatement blockStatement = (PsiBlockStatement)statement;
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            return InitializationUtils.blockAssignsVariableOrFails(codeBlock, variable, checkedMethods, strict);
        }
        if (statement instanceof PsiLabeledStatement) {
            PsiLabeledStatement labeledStatement = (PsiLabeledStatement)statement;
            PsiStatement statementLabeled = labeledStatement.getStatement();
            return InitializationUtils.statementAssignsVariableOrFails(statementLabeled, variable, checkedMethods, strict);
        }
        if (statement instanceof PsiIfStatement) {
            PsiIfStatement ifStatement = (PsiIfStatement)statement;
            return InitializationUtils.ifStatementAssignsVariableOrFails(ifStatement, variable, checkedMethods, strict);
        }
        if (statement instanceof PsiTryStatement) {
            PsiTryStatement tryStatement = (PsiTryStatement)statement;
            return InitializationUtils.tryStatementAssignsVariableOrFails(tryStatement, variable, checkedMethods, strict);
        }
        if (statement instanceof PsiSwitchStatement) {
            PsiSwitchStatement switchStatement = (PsiSwitchStatement)statement;
            return InitializationUtils.switchStatementAssignsVariableOrFails(switchStatement, variable, checkedMethods, strict);
        }
        return false;
    }

    public static boolean switchStatementAssignsVariableOrFails(@NotNull PsiSwitchStatement switchStatement, @NotNull PsiVariable variable, boolean strict) {
        if (switchStatement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/InitializationUtils.switchStatementAssignsVariableOrFails must not be null");
        }
        if (variable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/InitializationUtils.switchStatementAssignsVariableOrFails must not be null");
        }
        return InitializationUtils.switchStatementAssignsVariableOrFails(switchStatement, variable, new HashSet<MethodSignature>(), strict);
    }

    private static boolean switchStatementAssignsVariableOrFails(@NotNull PsiSwitchStatement switchStatement, @NotNull PsiVariable variable, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        if (switchStatement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/InitializationUtils.switchStatementAssignsVariableOrFails must not be null");
        }
        if (variable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/InitializationUtils.switchStatementAssignsVariableOrFails must not be null");
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/siyeh/ig/psiutils/InitializationUtils.switchStatementAssignsVariableOrFails must not be null");
        }
        PsiExpression expression = switchStatement.getExpression();
        if (InitializationUtils.expressionAssignsVariableOrFails(expression, variable, checkedMethods, strict)) {
            return true;
        }
        PsiCodeBlock body = switchStatement.getBody();
        if (body == null) {
            return false;
        }
        PsiStatement[] statements = body.getStatements();
        boolean containsDefault = false;
        boolean assigns = false;
        for (int i = 0; i < statements.length; ++i) {
            PsiStatement statement = statements[i];
            if (statement instanceof PsiSwitchLabelStatement) {
                PsiSwitchLabelStatement labelStatement = (PsiSwitchLabelStatement)statement;
                if (i == statements.length - 1) {
                    return false;
                }
                if (labelStatement.isDefaultCase()) {
                    containsDefault = true;
                }
                assigns = false;
                continue;
            }
            if (statement instanceof PsiBreakStatement) {
                PsiBreakStatement breakStatement = (PsiBreakStatement)statement;
                if (breakStatement.getLabelIdentifier() != null) {
                    return false;
                }
                if (!assigns) {
                    return false;
                }
                assigns = false;
                continue;
            }
            if (i != statements.length - 1 || (assigns |= InitializationUtils.statementAssignsVariableOrFails(statement, variable, checkedMethods, strict))) continue;
            return false;
        }
        return containsDefault;
    }

    private static boolean declarationStatementAssignsVariableOrFails(PsiDeclarationStatement declarationStatement, PsiVariable variable, Set<MethodSignature> checkedMethods, boolean strict) {
        PsiElement[] elements;
        for (PsiElement element : elements = declarationStatement.getDeclaredElements()) {
            PsiVariable declaredVariable;
            PsiExpression initializer;
            if (!(element instanceof PsiVariable) || !InitializationUtils.expressionAssignsVariableOrFails(initializer = (declaredVariable = (PsiVariable)element).getInitializer(), variable, checkedMethods, strict)) continue;
            return true;
        }
        return false;
    }

    private static boolean tryStatementAssignsVariableOrFails(@NotNull PsiTryStatement tryStatement, PsiVariable variable, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        PsiCodeBlock[] catchBlocks;
        if (tryStatement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/InitializationUtils.tryStatementAssignsVariableOrFails must not be null");
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/siyeh/ig/psiutils/InitializationUtils.tryStatementAssignsVariableOrFails must not be null");
        }
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        boolean initializedInTryAndCatch = InitializationUtils.blockAssignsVariableOrFails(tryBlock, variable, checkedMethods, strict);
        for (PsiCodeBlock catchBlock : catchBlocks = tryStatement.getCatchBlocks()) {
            if (strict) {
                initializedInTryAndCatch &= ExceptionUtils.blockThrowsException(catchBlock);
                continue;
            }
            initializedInTryAndCatch &= InitializationUtils.blockAssignsVariableOrFails(catchBlock, variable, checkedMethods, strict);
        }
        if (initializedInTryAndCatch) {
            return true;
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        return InitializationUtils.blockAssignsVariableOrFails(finallyBlock, variable, checkedMethods, strict);
    }

    private static boolean ifStatementAssignsVariableOrFails(@NotNull PsiIfStatement ifStatement, PsiVariable variable, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        if (ifStatement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/InitializationUtils.ifStatementAssignsVariableOrFails must not be null");
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/siyeh/ig/psiutils/InitializationUtils.ifStatementAssignsVariableOrFails must not be null");
        }
        PsiExpression condition = ifStatement.getCondition();
        if (InitializationUtils.expressionAssignsVariableOrFails(condition, variable, checkedMethods, strict)) {
            return true;
        }
        PsiStatement thenBranch = ifStatement.getThenBranch();
        PsiStatement elseBranch = ifStatement.getElseBranch();
        if (BoolUtils.isTrue(condition)) {
            return InitializationUtils.statementAssignsVariableOrFails(thenBranch, variable, checkedMethods, strict);
        }
        if (BoolUtils.isFalse(condition)) {
            return InitializationUtils.statementAssignsVariableOrFails(elseBranch, variable, checkedMethods, strict);
        }
        return InitializationUtils.statementAssignsVariableOrFails(thenBranch, variable, checkedMethods, strict) && InitializationUtils.statementAssignsVariableOrFails(elseBranch, variable, checkedMethods, strict);
    }

    private static boolean doWhileAssignsVariableOrFails(@NotNull PsiDoWhileStatement doWhileStatement, PsiVariable variable, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        if (doWhileStatement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/InitializationUtils.doWhileAssignsVariableOrFails must not be null");
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/siyeh/ig/psiutils/InitializationUtils.doWhileAssignsVariableOrFails must not be null");
        }
        PsiExpression condition = doWhileStatement.getCondition();
        PsiStatement body = doWhileStatement.getBody();
        return InitializationUtils.expressionAssignsVariableOrFails(condition, variable, checkedMethods, strict) || InitializationUtils.statementAssignsVariableOrFails(body, variable, checkedMethods, strict);
    }

    private static boolean whileStatementAssignsVariableOrFails(@NotNull PsiWhileStatement whileStatement, PsiVariable variable, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        PsiStatement body;
        if (whileStatement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/InitializationUtils.whileStatementAssignsVariableOrFails must not be null");
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/siyeh/ig/psiutils/InitializationUtils.whileStatementAssignsVariableOrFails must not be null");
        }
        PsiExpression condition = whileStatement.getCondition();
        if (InitializationUtils.expressionAssignsVariableOrFails(condition, variable, checkedMethods, strict)) {
            return true;
        }
        return BoolUtils.isTrue(condition) && InitializationUtils.statementAssignsVariableOrFails(body = whileStatement.getBody(), variable, checkedMethods, strict);
    }

    private static boolean forStatementAssignsVariableOrFails(@NotNull PsiForStatement forStatement, PsiVariable variable, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        if (forStatement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/InitializationUtils.forStatementAssignsVariableOrFails must not be null");
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/siyeh/ig/psiutils/InitializationUtils.forStatementAssignsVariableOrFails must not be null");
        }
        PsiStatement initialization = forStatement.getInitialization();
        if (InitializationUtils.statementAssignsVariableOrFails(initialization, variable, checkedMethods, strict)) {
            return true;
        }
        PsiExpression test = forStatement.getCondition();
        if (InitializationUtils.expressionAssignsVariableOrFails(test, variable, checkedMethods, strict)) {
            return true;
        }
        if (BoolUtils.isTrue(test)) {
            PsiStatement body = forStatement.getBody();
            if (InitializationUtils.statementAssignsVariableOrFails(body, variable, checkedMethods, strict)) {
                return true;
            }
            PsiStatement update = forStatement.getUpdate();
            if (InitializationUtils.statementAssignsVariableOrFails(update, variable, checkedMethods, strict)) {
                return true;
            }
        }
        return false;
    }

    private static boolean foreachStatementAssignsVariableOrFails(PsiVariable field, PsiForeachStatement forStatement) {
        return false;
    }

    private static boolean expressionAssignsVariableOrFails(@Nullable PsiExpression expression, PsiVariable variable, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        if (checkedMethods == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/siyeh/ig/psiutils/InitializationUtils.expressionAssignsVariableOrFails must not be null");
        }
        if (expression == null) {
            return false;
        }
        if (expression instanceof PsiThisExpression || expression instanceof PsiLiteralExpression || expression instanceof PsiSuperExpression || expression instanceof PsiClassObjectAccessExpression) {
            return false;
        }
        if (expression instanceof PsiReferenceExpression) {
            return false;
        }
        if (expression instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            return InitializationUtils.methodCallAssignsVariableOrFails(methodCallExpression, variable, checkedMethods, strict);
        }
        if (expression instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)expression;
            return InitializationUtils.newExpressionAssignsVariableOrFails(newExpression, variable, checkedMethods, strict);
        }
        if (expression instanceof PsiArrayInitializerExpression) {
            PsiExpression[] initializers;
            PsiArrayInitializerExpression array = (PsiArrayInitializerExpression)expression;
            for (PsiExpression initializer : initializers = array.getInitializers()) {
                if (!InitializationUtils.expressionAssignsVariableOrFails(initializer, variable, checkedMethods, strict)) continue;
                return true;
            }
            return false;
        }
        if (expression instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression typeCast = (PsiTypeCastExpression)expression;
            PsiExpression operand = typeCast.getOperand();
            return InitializationUtils.expressionAssignsVariableOrFails(operand, variable, checkedMethods, strict);
        }
        if (expression instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression accessExpression = (PsiArrayAccessExpression)expression;
            PsiExpression arrayExpression = accessExpression.getArrayExpression();
            PsiExpression indexExpression = accessExpression.getIndexExpression();
            return InitializationUtils.expressionAssignsVariableOrFails(arrayExpression, variable, checkedMethods, strict) || InitializationUtils.expressionAssignsVariableOrFails(indexExpression, variable, checkedMethods, strict);
        }
        if (expression instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression;
            PsiExpression operand = prefixExpression.getOperand();
            return InitializationUtils.expressionAssignsVariableOrFails(operand, variable, checkedMethods, strict);
        }
        if (expression instanceof PsiPostfixExpression) {
            PsiPostfixExpression postfixExpression = (PsiPostfixExpression)expression;
            PsiExpression operand = postfixExpression.getOperand();
            return InitializationUtils.expressionAssignsVariableOrFails(operand, variable, checkedMethods, strict);
        }
        if (expression instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            return InitializationUtils.expressionAssignsVariableOrFails(lhs, variable, checkedMethods, strict) || InitializationUtils.expressionAssignsVariableOrFails(rhs, variable, checkedMethods, strict);
        }
        if (expression instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditional = (PsiConditionalExpression)expression;
            PsiExpression condition = conditional.getCondition();
            if (InitializationUtils.expressionAssignsVariableOrFails(condition, variable, checkedMethods, strict)) {
                return true;
            }
            PsiExpression thenExpression = conditional.getThenExpression();
            PsiExpression elseExpression = conditional.getElseExpression();
            return InitializationUtils.expressionAssignsVariableOrFails(thenExpression, variable, checkedMethods, strict) && InitializationUtils.expressionAssignsVariableOrFails(elseExpression, variable, checkedMethods, strict);
        }
        if (expression instanceof PsiAssignmentExpression) {
            PsiElement element;
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)expression;
            PsiExpression lhs = assignment.getLExpression();
            if (InitializationUtils.expressionAssignsVariableOrFails(lhs, variable, checkedMethods, strict)) {
                return true;
            }
            PsiExpression rhs = assignment.getRExpression();
            if (InitializationUtils.expressionAssignsVariableOrFails(rhs, variable, checkedMethods, strict)) {
                return true;
            }
            return lhs instanceof PsiReferenceExpression && (element = ((PsiReference)lhs).resolve()) != null && element.equals(variable);
        }
        return false;
    }

    private static boolean newExpressionAssignsVariableOrFails(@NotNull PsiNewExpression newExpression, PsiVariable variable, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        PsiExpression[] arrayDimensions;
        PsiArrayInitializerExpression arrayInitializer;
        if (newExpression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/InitializationUtils.newExpressionAssignsVariableOrFails must not be null");
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/siyeh/ig/psiutils/InitializationUtils.newExpressionAssignsVariableOrFails must not be null");
        }
        PsiExpressionList argumentList = newExpression.getArgumentList();
        if (argumentList != null) {
            PsiExpression[] args;
            for (PsiExpression arg : args = argumentList.getExpressions()) {
                if (!InitializationUtils.expressionAssignsVariableOrFails(arg, variable, checkedMethods, strict)) continue;
                return true;
            }
        }
        if (InitializationUtils.expressionAssignsVariableOrFails((PsiExpression)(arrayInitializer = newExpression.getArrayInitializer()), variable, checkedMethods, strict)) {
            return true;
        }
        for (PsiExpression dim : arrayDimensions = newExpression.getArrayDimensions()) {
            if (!InitializationUtils.expressionAssignsVariableOrFails(dim, variable, checkedMethods, strict)) continue;
            return true;
        }
        return false;
    }

    private static boolean methodCallAssignsVariableOrFails(@NotNull PsiMethodCallExpression callExpression, PsiVariable variable, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        PsiExpression[] args;
        if (callExpression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/InitializationUtils.methodCallAssignsVariableOrFails must not be null");
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/siyeh/ig/psiutils/InitializationUtils.methodCallAssignsVariableOrFails must not be null");
        }
        PsiExpressionList argList = callExpression.getArgumentList();
        for (PsiExpression arg : args = argList.getExpressions()) {
            if (!InitializationUtils.expressionAssignsVariableOrFails(arg, variable, checkedMethods, strict)) continue;
            return true;
        }
        PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
        if (InitializationUtils.expressionAssignsVariableOrFails((PsiExpression)methodExpression, variable, checkedMethods, strict)) {
            return true;
        }
        PsiMethod method = callExpression.resolveMethod();
        if (method == null) {
            return false;
        }
        MethodSignature methodSignature = method.getSignature(PsiSubstitutor.EMPTY);
        if (!checkedMethods.add(methodSignature)) {
            return false;
        }
        PsiClass containingClass = ClassUtils.getContainingClass((PsiElement)callExpression);
        PsiClass calledClass = method.getContainingClass();
        if (calledClass == null || !calledClass.equals(containingClass)) {
            return false;
        }
        if (method.hasModifierProperty("static") || method.isConstructor() || method.hasModifierProperty("private") || method.hasModifierProperty("final") || calledClass.hasModifierProperty("final")) {
            PsiCodeBlock body = method.getBody();
            return InitializationUtils.blockAssignsVariableOrFails(body, variable, checkedMethods, strict);
        }
        return false;
    }
}

