/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import org.jetbrains.annotations.NotNull;

public class ArrayContentsAccessedVisitor
extends JavaRecursiveElementVisitor {
    private boolean accessed;
    private final PsiVariable variable;

    public ArrayContentsAccessedVisitor(@NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ArrayContentsAccessedVisitor.<init> must not be null");
        }
        this.accessed = false;
        this.variable = variable;
    }

    public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ArrayContentsAccessedVisitor.visitForeachStatement must not be null");
        }
        if (this.accessed) {
            return;
        }
        super.visitForeachStatement(statement);
        PsiExpression qualifier = statement.getIteratedValue();
        if (!(qualifier instanceof PsiReferenceExpression)) {
            return;
        }
        PsiElement referent = ((PsiReference)qualifier).resolve();
        if (referent == null) {
            return;
        }
        if (!referent.equals(this.variable)) {
            return;
        }
        this.accessed = true;
    }

    public void visitArrayAccessExpression(PsiArrayAccessExpression arg) {
        if (this.accessed) {
            return;
        }
        super.visitArrayAccessExpression(arg);
        if (arg.getParent() instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)arg.getParent()).getLExpression().equals(arg)) {
            return;
        }
        PsiExpression arrayExpression = arg.getArrayExpression();
        if (!(arrayExpression instanceof PsiReferenceExpression)) {
            return;
        }
        PsiElement referent = ((PsiReference)arrayExpression).resolve();
        if (referent == null) {
            return;
        }
        if (referent.equals(this.variable)) {
            this.accessed = true;
        }
    }

    public boolean isAccessed() {
        return this.accessed;
    }
}

