/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.portability;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class UseOfSunClassesInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("use.sun.classes.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/portability/UseOfSunClassesInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("use.sun.classes.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/portability/UseOfSunClassesInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UseOfSunClassesVisitor();
    }

    private static class UseOfSunClassesVisitor
    extends BaseInspectionVisitor {
        private UseOfSunClassesVisitor() {
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/portability/UseOfSunClassesInspection$UseOfSunClassesVisitor.visitVariable must not be null");
            }
            super.visitVariable(variable);
            PsiType type = variable.getType();
            PsiType deepComponentType = type.getDeepComponentType();
            if (!(deepComponentType instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)deepComponentType;
            String className = classType.getCanonicalText();
            if (className == null || !className.startsWith("sun.")) {
                return;
            }
            PsiTypeElement typeElement = variable.getTypeElement();
            if (typeElement == null) {
                return;
            }
            this.registerError((PsiElement)typeElement, new Object[0]);
        }

        public void visitNewExpression(@NotNull PsiNewExpression newExpression) {
            if (newExpression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/portability/UseOfSunClassesInspection$UseOfSunClassesVisitor.visitNewExpression must not be null");
            }
            super.visitNewExpression(newExpression);
            PsiType type = newExpression.getType();
            if (type == null) {
                return;
            }
            if (!(type instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)type;
            String className = classType.getCanonicalText();
            if (className == null || !className.startsWith("sun.")) {
                return;
            }
            this.registerNewExpressionError(newExpression, new Object[0]);
        }
    }
}

