/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.portability;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class SystemExitInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("CallToSystemExit" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/portability/SystemExitInspection.getID must not return null");
        }
        return "CallToSystemExit";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("system.exit.call.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/portability/SystemExitInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String className = (String)infos[0];
        String string = InspectionGadgetsBundle.message("system.exit.call.problem.descriptor", className);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/portability/SystemExitInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SystemExitVisitor();
    }

    private static class SystemExitVisitor
    extends BaseInspectionVisitor {
        private SystemExitVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/portability/SystemExitInspection$SystemExitVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            String exit = "exit";
            String halt = "halt";
            if (!"exit".equals(methodName) && !"halt".equals(methodName)) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() != 1) {
                return;
            }
            PsiParameter[] parameters = parameterList.getParameters();
            PsiType parameterType = parameters[0].getType();
            if (!parameterType.equals(PsiType.INT)) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            String className = aClass.getQualifiedName();
            if (className == null) {
                return;
            }
            if ("java.lang.System".equals(className)) {
                this.registerMethodCallError(expression, "System");
            } else if ("java.lang.Runtime".equals(className)) {
                this.registerMethodCallError(expression, "Runtime");
            }
        }
    }
}

