/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfusingFloatingPointLiteralInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("confusing.floating.point.literal.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/numeric/ConfusingFloatingPointLiteralInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("confusing.floating.point.literal.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/numeric/ConfusingFloatingPointLiteralInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ConfusingFloatingPointLiteralFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConfusingFloatingPointLiteralVisitor();
    }

    private static class ConfusingFloatingPointLiteralVisitor
    extends BaseInspectionVisitor {
        private ConfusingFloatingPointLiteralVisitor() {
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression literal) {
            if (literal == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/numeric/ConfusingFloatingPointLiteralInspection$ConfusingFloatingPointLiteralVisitor.visitLiteralExpression must not be null");
            }
            super.visitLiteralExpression(literal);
            PsiType type = literal.getType();
            if (type == null) {
                return;
            }
            if (!type.equals(PsiType.FLOAT) && !type.equals(PsiType.DOUBLE)) {
                return;
            }
            String text = literal.getText();
            if (text == null) {
                return;
            }
            if (!ConfusingFloatingPointLiteralVisitor.isConfusing(text)) {
                return;
            }
            this.registerError((PsiElement)literal, new Object[0]);
        }

        private static boolean isConfusing(@Nullable CharSequence text) {
            if (text == null) {
                return false;
            }
            int length = text.length();
            if (length < 3) {
                return true;
            }
            boolean hexadecimal = true;
            char firstChar = text.charAt(0);
            if (firstChar != '0') {
                hexadecimal = false;
            } else if (firstChar < '0' && firstChar > '9') {
                return true;
            }
            char secondChar = text.charAt(1);
            if (hexadecimal && secondChar != 'x' && secondChar != 'X') {
                hexadecimal = false;
            }
            int index = hexadecimal ? 2 : 1;
            char nextChar = text.charAt(index);
            if (hexadecimal && (nextChar < '0' || nextChar > '9')) {
                return true;
            }
            while (nextChar >= '0' && nextChar <= '9') {
                if (++index >= length) {
                    return true;
                }
                nextChar = text.charAt(index);
            }
            if (nextChar != '.') {
                return true;
            }
            if (++index >= length) {
                return true;
            }
            nextChar = text.charAt(index);
            if (nextChar < '0' || nextChar > '9') {
                return true;
            }
            while (nextChar >= '0' && nextChar <= '9') {
                if (++index >= length) {
                    return hexadecimal;
                }
                nextChar = text.charAt(index);
            }
            if (hexadecimal) {
                if (nextChar != 'p' && nextChar != 'P') {
                    return true;
                }
            } else if (nextChar != 'e' && nextChar != 'E') {
                return nextChar != 'f' && nextChar != 'F' && nextChar != 'd' && nextChar != 'D' || index != length - 1;
            }
            if (++index >= length) {
                return true;
            }
            nextChar = text.charAt(index);
            if (nextChar == '-') {
                if (++index >= length) {
                    return true;
                }
                nextChar = text.charAt(index);
            }
            while (nextChar >= '0' && nextChar <= '9') {
                if (++index >= length) {
                    return false;
                }
                nextChar = text.charAt(index);
            }
            return false;
        }
    }

    private static class ConfusingFloatingPointLiteralFix
    extends InspectionGadgetsFix {
        private ConfusingFloatingPointLiteralFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("confusing.floating.point.literal.change.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/numeric/ConfusingFloatingPointLiteralInspection$ConfusingFloatingPointLiteralFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiExpression literalExpression = (PsiExpression)descriptor.getPsiElement();
            String text = literalExpression.getText();
            String newText = ConfusingFloatingPointLiteralFix.getCanonicalForm(text);
            ConfusingFloatingPointLiteralFix.replaceExpression(literalExpression, newText);
        }

        private static String getCanonicalForm(String text) {
            String prefix;
            String suffix;
            boolean isHexadecimal = text.startsWith("0x") || text.startsWith("0X");
            int breakPoint = text.indexOf(101);
            if (breakPoint < 0) {
                breakPoint = text.indexOf(69);
            }
            if (breakPoint < 0) {
                breakPoint = text.indexOf(102);
            }
            if (breakPoint < 0) {
                breakPoint = text.indexOf(70);
            }
            if (breakPoint < 0) {
                breakPoint = text.indexOf(112);
            }
            if (breakPoint < 0) {
                breakPoint = text.indexOf(80);
            }
            if (breakPoint < 0) {
                breakPoint = text.indexOf(100);
            }
            if (breakPoint < 0) {
                breakPoint = text.indexOf(68);
            }
            if (breakPoint < 0) {
                suffix = "";
                prefix = text;
            } else {
                suffix = text.substring(breakPoint);
                prefix = text.substring(0, breakPoint);
            }
            int indexPoint = prefix.indexOf(46);
            if (indexPoint < 0) {
                return prefix + ".0" + suffix;
            }
            if (isHexadecimal && indexPoint == 2) {
                return prefix.substring(0, 2) + '0' + prefix.substring(2) + suffix;
            }
            if (indexPoint == 0) {
                return '0' + prefix + suffix;
            }
            return prefix + '0' + suffix;
        }
    }
}

